/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.iogame.assets;

import com.iosoft.helpers.Misc;
import com.iosoft.helpers.awt.ImageCollection;
import com.iosoft.helpers.awt.MiscImg;
import com.iosoft.helpers.datasource.ISubableDataSource;
import com.iosoft.helpers.datasource.Resource;
import com.iosoft.helpers.ui.awt.MiscAWT;
import com.iosoft.iogame.assets.ImagePreparer;
import java.awt.image.BufferedImage;
import java.io.IOException;

public class ImageLoader {
    public final ISubableDataSource Source;
    public final ImagePreparer ImagePreparer;

    public ImageLoader(String basePath) {
        this(new Resource(basePath));
    }

    public ImageLoader(ISubableDataSource source) {
        this(source, new ImagePreparer(MiscAWT.getGraphicsConfiguration()));
    }

    public ImageLoader(ISubableDataSource source, ImagePreparer imagePreparer) {
        this.Source = Misc.notNull(source);
        this.ImagePreparer = Misc.notNull(imagePreparer);
    }

    private int getTransparencyType(String res) {
        String resUpper = Misc.toUpper(res);
        return resUpper.endsWith(".JPG") || resUpper.endsWith(".JPEG") ? 1 : this.ImagePreparer.TransparencyType;
    }

    public BufferedImage load(String res) throws IOException {
        return this.load(res, this.getTransparencyType(res));
    }

    public BufferedImage load(String res, int transparencyType) throws IOException {
        return MiscImg.prepareImage(this.ImagePreparer.Cfg, MiscImg.loadImage(this.Source.sub(res)), transparencyType);
    }

    public ImageCollection load(String res, int cols, int rows) throws IOException {
        BufferedImage source = MiscImg.loadImage(this.Source.sub(res));
        BufferedImage preparedSource = MiscImg.prepareImage(this.ImagePreparer.Cfg, source, this.ImagePreparer.TransparencyType);
        return new ImageCollection(preparedSource, cols, rows);
    }

    public BufferedImage[] load1DLeaky(String res, int cols, int rows) throws IOException {
        return this.load((String)res, (int)cols, (int)rows).Images;
    }

    public BufferedImage[][] load2DLeaky(String res, int cols, int rows) throws IOException {
        BufferedImage[][] images = new BufferedImage[cols][rows];
        ImageCollection source = this.load(res, cols, rows);
        Misc.split(source.Images, images, true);
        return images;
    }

    public BufferedImage tryLoadUnpreparedIfExists(String res) throws IOException {
        return MiscImg.tryLoadImage(this.Source.sub(res));
    }

    public BufferedImage tryLoadIfExists(String res) throws IOException {
        BufferedImage image = MiscImg.tryLoadImage(this.Source.sub(res));
        return image == null ? null : MiscImg.prepareImage(this.ImagePreparer.Cfg, image, this.getTransparencyType(res));
    }

    public BufferedImage loadUnprepared(String res) throws IOException {
        return MiscImg.loadImage(this.Source.sub(res));
    }

    public ImageCollection loadUnprepared(String res, int cols, int rows) throws IOException {
        BufferedImage source = MiscImg.loadImage(this.Source.sub(res));
        return new ImageCollection(source, cols, rows);
    }

    public BufferedImage[] load1DUnpreparedLeaky(String res, int cols, int rows) throws IOException {
        return this.loadUnprepared((String)res, (int)cols, (int)rows).Images;
    }

    public BufferedImage[][] load2DUnpreparedLeaky(String res, int cols, int rows) throws IOException {
        BufferedImage[][] images = new BufferedImage[cols][rows];
        ImageCollection source = this.loadUnprepared(res, cols, rows);
        Misc.split(source.Images, images, true);
        return images;
    }

    public ImageLoader getSubPath(String path) {
        return new ImageLoader(this.Source.sub(path), this.ImagePreparer.copy());
    }
}

