/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.iogame;

import com.iosoft.helpers.Stopwatch;

public class UpsCounter {
    private long sw_startOfSecond = UpsCounter.getStartOfSecond(Stopwatch.start());
    private long unitsLastSecond;
    private long unitsThisSecond;

    public long count() {
        return this.count(1L);
    }

    public long count(long units) {
        if (this.isNextCycle()) {
            this.unitsLastSecond = this.unitsThisSecond;
            this.unitsThisSecond = 0L;
        }
        this.unitsThisSecond += units;
        return this.unitsLastSecond;
    }

    public long set(long units) {
        if (this.isNextCycle()) {
            this.unitsLastSecond = units - this.unitsThisSecond;
            this.unitsThisSecond = units;
        }
        return this.unitsLastSecond;
    }

    private boolean isNextCycle() {
        long sw_now = Stopwatch.start();
        if (sw_now - this.sw_startOfSecond < 1000000000L) {
            return false;
        }
        this.sw_startOfSecond = UpsCounter.getStartOfSecond(sw_now);
        return true;
    }

    private static long getStartOfSecond(long sw) {
        long sw_startOfSecond = sw / 1000000000L;
        if (sw < 0L && sw % 1000000000L != 0L) {
            --sw_startOfSecond;
        }
        return sw_startOfSecond *= 1000000000L;
    }
}

