/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.iogame;

import com.iosoft.helpers.Log;
import com.iosoft.helpers.Mutable;
import com.iosoft.helpers.Stopwatch;
import com.iosoft.helpers.WrapException;
import com.iosoft.helpers.async.Async;
import com.iosoft.helpers.async.VTask;
import com.iosoft.helpers.binding.BoolObservable;
import com.iosoft.helpers.binding.MyBoolObservable;
import com.iosoft.iogame.ISettingsProvider;
import com.iosoft.iogame.saveload.IKVNode;
import com.iosoft.iogame.saveload.IKVRW;
import com.iosoft.iogame.saveload.IKVRead;
import com.iosoft.iogame.saveload.IKVWrite;
import java.io.IOException;

public abstract class Settings {
    private static final double IntervalSec = 0.5;
    private final MyBoolObservable _saving = new MyBoolObservable(false);
    public final BoolObservable Saving;
    private boolean _resave;
    protected ISettingsProvider _provider;
    protected IKVNode _root;

    public Settings() {
        this.Saving = this._saving.Getter;
        this._resave = false;
    }

    public void init(ISettingsProvider provider) {
        this._provider = provider;
    }

    public void load() {
        try {
            Log.App.info("Loading settings");
            this._root = this._provider.load();
            this.read(this._root);
        }
        catch (IOException e) {
            throw new WrapException("Setting could not be loaded", e);
        }
    }

    protected void read(IKVRead kv) {
        this.rw(kv.reader());
    }

    protected void write() {
        this.write(this._root);
    }

    protected void write(IKVWrite kv) {
        this.rw(kv.writer());
    }

    protected void rw(IKVRW rw) {
    }

    protected boolean blockingSave() {
        return false;
    }

    protected void onSave() {
    }

    public void save() {
        if (this._root == null) {
            throw new IllegalStateException("Cannot save before settings have been loaded");
        }
        Mutable<Long> sw_save = new Mutable<Long>(Stopwatch.start());
        this.onSave();
        if (this.blockingSave()) {
            try {
                this.write();
                this._provider.saveBlocking();
            }
            catch (IOException e) {
                this.onError(e);
            }
            Log.App.info("Settings saved in " + Stopwatch.getMillis((Long)sw_save.Value) + " ms");
        } else {
            this._resave = true;
            if (this.Saving.get()) {
                return;
            }
            this._saving.set(true);
            Async.whileDo(() -> {
                if (!this._resave) {
                    return null;
                }
                return VTask.delay(0.5).awaitAndContinueTask(() -> {
                    this._resave = false;
                    this.write();
                    return this._provider.saveAsync();
                }).awaitAndContinue(ex -> {
                    long now = Stopwatch.start();
                    Log.App.info("Settings saved in " + Stopwatch.getMillis((Long)mutable.Value, now) + " ms");
                    mutable.Value = now;
                    if (ex != null) {
                        this._resave = false;
                        this.onError((IOException)ex);
                    }
                });
            }).await(() -> this._saving.set(false));
        }
    }

    protected abstract void onError(IOException var1);
}

