/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.iogame;

import com.iosoft.helpers.Pair;
import com.iosoft.helpers.async.Task;
import com.iosoft.helpers.datasource.FileSource;
import com.iosoft.iogame.AbstractSettingsProvider;
import com.iosoft.iogame.saveload.IKVNode;
import com.iosoft.propdb.PropDB;
import com.iosoft.propdb.saveload.PropDBKVNode;
import java.io.File;
import java.io.IOException;

public class PropDBSettingsProvider
extends AbstractSettingsProvider<PropDB> {
    public PropDBSettingsProvider(File settingsFolder) throws IOException {
        super(settingsFolder);
    }

    @Override
    protected String getFileExtension() {
        return "dat";
    }

    @Override
    protected Pair<PropDB, IKVNode> load(File file, boolean getFresh) throws IOException {
        PropDB propDB = getFresh ? new PropDB() : PropDB.loadSource(new FileSource(file));
        PropDB.Node root = propDB.getRoot();
        if (root == null) {
            propDB.clear();
            root = propDB.getRoot();
        }
        return new Pair<PropDB, IKVNode>(propDB, new PropDBKVNode(root));
    }

    @Override
    protected void saveBlocking(PropDB container, IKVNode node, File file) throws IOException {
        container.save(file);
    }

    @Override
    protected Task<IOException> saveAsync(PropDB container, IKVNode node, File file) {
        return container.saveAsync(file);
    }
}

