/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.iogame;

import com.iosoft.helpers.Misc;
import com.iosoft.helpers.WrapException;
import com.iosoft.helpers.io.MiscIO;
import com.iosoft.iogame.AppSettings;
import com.iosoft.iogame.saveload.IKVRW;
import java.io.File;
import java.io.IOException;
import java.util.function.Consumer;

public class GameSettings
extends AppSettings {
    public String PlayerName = "";
    public String Language = "";
    public boolean ForceOpenGL;
    public Consumer<IOException> ErrorHandler;
    private String _gameName;

    public void init(String currentVersion, String gameName) {
        this.init(currentVersion);
        this._gameName = gameName;
        try {
            MiscIO.mkdirs(this.getScreenshotsPath());
        }
        catch (IOException e) {
            throw new WrapException(e);
        }
    }

    @Override
    protected void onError(IOException ex) {
        if (this.ErrorHandler != null) {
            this.ErrorHandler.accept(ex);
        } else {
            ex.printStackTrace();
        }
    }

    @Override
    public File getSettingsPath() {
        return new File(Misc.getIosoftDir(), this._gameName);
    }

    public File getScreenshotsPath() {
        return new File(this.getSettingsPath(), "screenshots/");
    }

    @Override
    protected void rw(IKVRW rw) {
        super.rw(rw);
        this.PlayerName = rw.rwString("playerName", this.PlayerName).trim();
        if (this.PlayerName.isEmpty()) {
            this.PlayerName = Misc.getUserName("Player");
        }
        this.Language = rw.rwString("language", this.Language);
        this.ForceOpenGL = rw.rwBool("forceOpenGL", this.ForceOpenGL);
    }

    public void setPlayerName(String value) {
        if (!this.PlayerName.equals(value)) {
            this.PlayerName = value;
            this.save();
        }
    }

    public void setLanguage(String newLanguage) {
        if (!this.Language.equals(newLanguage)) {
            this.Language = newLanguage;
            this.save();
        }
    }

    public void setForceOpenGL(boolean value) {
        if (this.ForceOpenGL != value) {
            this.ForceOpenGL = value;
            this.save();
        }
    }
}

