/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.iogame;

import com.iosoft.helpers.IDisposable;
import com.iosoft.helpers.JVMKeeper;
import com.iosoft.helpers.Log;
import com.iosoft.helpers.Misc;
import com.iosoft.helpers.WrapException;
import com.iosoft.helpers.async.Async;
import com.iosoft.helpers.async.Task;
import com.iosoft.helpers.async.TaskSourceBase;
import com.iosoft.helpers.async.VTask;
import com.iosoft.helpers.async.VTaskSource;
import com.iosoft.helpers.async.dispatcher.Dispatcher;
import com.iosoft.helpers.async.dispatcher.EDTDispatcher;
import com.iosoft.helpers.awt.ImageCollection;
import com.iosoft.helpers.awt.MiscImg;
import com.iosoft.helpers.binding.BoolObservable;
import com.iosoft.helpers.datasource.Resource;
import com.iosoft.helpers.game.UpdateChecker;
import com.iosoft.helpers.localizer.Language;
import com.iosoft.helpers.localizer.LocalizationParser;
import com.iosoft.helpers.localizer.Localizer;
import com.iosoft.helpers.ui.awt.MiscAWT;
import com.iosoft.iogame.AppSettings;
import com.iosoft.iogame.GameSettings;
import com.iosoft.iogame.ISettingsProvider;
import com.iosoft.iogame.PropDBSettingsProvider;
import com.iosoft.iogame.Settings;
import com.iosoft.iogame.assets.IAsset;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.ImageIcon;

public abstract class Game<S extends GameSettings> {
    private List<IAsset> assets = new ArrayList<IAsset>();
    private boolean developer;
    private boolean errorAfterStoppedReported = false;
    private IDisposable jvmKeepalive;
    private VTask lastLoader;
    private VTask shutDowner;
    private Task<UpdateChecker.Result> updateCheckerTask;
    public final S Settings = this.createSettings();
    private ISettingsProvider _settingsProvider;
    private final Object logLock = new Object();
    public final Localizer Localizer;
    private final VTaskSource shutdownStarted = new VTaskSource();
    public final VTask ShutdownStarted = (VTask)this.shutdownStarted.getTask();
    private final VTaskSource shutdownDone = new VTaskSource();
    private final LinkedList<Runnable> _runOnShutdown = new LinkedList();
    public final VTask ShutdownDone = (VTask)this.shutdownDone.getTask();
    private volatile boolean stopped = false;

    protected Game() {
        this(new Localizer("english"));
    }

    protected Game(Localizer localizer) {
        this.ShutdownStarted.await(() -> {
            Runnable[] callbacks = this._runOnShutdown.toArray(new Runnable[this._runOnShutdown.size()]);
            this._runOnShutdown.clear();
            Runnable[] runnableArray = callbacks;
            int n = callbacks.length;
            int n2 = 0;
            while (n2 < n) {
                Runnable callback = runnableArray[n2];
                callback.run();
                ++n2;
            }
        });
        this.Localizer = localizer;
        Misc.setSystemOutToUtf8(true);
        try {
            ((GameSettings)this.Settings).init(this.getVersion(), this.getName());
            this._settingsProvider = this.createSettingsProvider(((GameSettings)this.Settings).getSettingsPath());
            ((Settings)this.Settings).init(this._settingsProvider);
        }
        catch (IOException e) {
            throw new WrapException(e);
        }
    }

    public ISettingsProvider getSettingsProvider() {
        return this._settingsProvider;
    }

    protected ISettingsProvider createSettingsProvider(File gameFolder) throws IOException {
        return new PropDBSettingsProvider(gameFolder);
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public Dispatcher start(String[] args) {
        this.parseArguments(Arrays.asList(args));
        Dispatcher dispatcher = this.createDispatcher();
        dispatcher.dispatch(this::doStart);
        return dispatcher;
    }

    public void startDirectly(String[] args) {
        this.parseArguments(Arrays.asList(args));
        this.doStart();
    }

    protected boolean useLFAndAA() {
        return true;
    }

    protected boolean mustLoadSettingsFirst() {
        return false;
    }

    private void doStart() {
        Dispatcher dispatcher = Dispatcher.getForCurrentThread();
        boolean mustLoadSettingsFirst = this.mustLoadSettingsFirst();
        if (mustLoadSettingsFirst) {
            this.initSettings();
            ((Settings)this.Settings).load();
            this.onSettingsLoaded();
        }
        ArrayList<IDisposable> keepAlives = new ArrayList<IDisposable>();
        if (dispatcher instanceof EDTDispatcher) {
            if (GraphicsEnvironment.isHeadless()) {
                throw new RuntimeException("Cannot launch in a headless environment");
            }
            if (this.useLFAndAA()) {
                MiscAWT.setSystemLookAndFeel();
            }
            keepAlives.add(MiscAWT.createEDTKeepalive());
        }
        dispatcher.setMainUnhandledExceptionHandler(this::onError);
        keepAlives.add(JVMKeeper.createThread());
        keepAlives.add(dispatcher.createKeepAliveToken());
        keepAlives.trimToSize();
        this.jvmKeepalive = () -> keepAlives.forEach(IDisposable::dispose);
        if (!mustLoadSettingsFirst) {
            this.initSettings();
        }
        this.initialize();
        this.postInitialize();
        ArrayList<Supplier<VTask>> loadOrder = new ArrayList<Supplier<VTask>>();
        if (!mustLoadSettingsFirst) {
            loadOrder.add(() -> VTask.runAsync(() -> ((Settings)this.Settings).load()).awaitAndContinue(this::onSettingsLoaded));
        }
        if (this.shouldLoadLocalizations()) {
            loadOrder.add(() -> this.loadLocalizationsAsync().awaitAndContinue(this::onLocalizationsLoaded));
        }
        loadOrder.add(() -> this.loadImportantAssetsAsync().awaitAndContinue(this::onImportantLoaded));
        loadOrder.add(() -> this.loadAssetsAsync().awaitAndContinue(this::onLoaded));
        this.lastLoader = Async.forEach(loadOrder, Supplier::get);
        this.lastLoader.await(() -> {
            VTask vTask = this.lastLoader = null;
        });
    }

    protected boolean skipLoadMedia() {
        return false;
    }

    protected boolean shouldLoadLocalizations() {
        return true;
    }

    protected void initSettings() {
        ((GameSettings)this.Settings).ErrorHandler = this::onError;
    }

    protected void initialize() {
    }

    protected void postInitialize() {
    }

    protected void onSettingsLoaded() {
        UpdateCheckerInfo updateCheckerInfo;
        MiscAWT.setOpenGL(((GameSettings)this.Settings).ForceOpenGL);
        if (this.shouldCheckForUpdates() && (updateCheckerInfo = this.getUpdateCheckerInfo()) != null) {
            this.updateCheckerTask = UpdateChecker.checkForUpdatesAsync(updateCheckerInfo.Url, updateCheckerInfo.Signature, this.getVersion());
        }
    }

    protected VTask loadLocalizationsAsync() {
        LocalizationParser localizationParser = new LocalizationParser(this.Localizer);
        this.addLocalizationPaths(localizationParser);
        return localizationParser.loadTextsAsync().awaitAndContinue(WrapException::throwIfNotNull);
    }

    protected void addLocalizationPaths(LocalizationParser parser) {
        parser.addTextsJSON(new Resource("/res/ioengine/text/"), "languages_base.json");
        List<IAsset> allAssets = this.assets;
        this.assets = null;
        for (IAsset asset : allAssets) {
            asset.addLocalizationPaths(parser);
        }
    }

    protected void onLocalizationsLoaded() {
        Language language;
        String languageName = ((GameSettings)this.Settings).Language;
        Language language2 = language = Misc.isNullOrEmpty(languageName) ? null : this.Localizer.tryGetLanguage(languageName);
        if (language == null) {
            this.Localizer.setDefaultLanguageBySystemLanguage();
        } else {
            this.Localizer.setDefaultLanguage(language);
        }
    }

    public void setLanguage(Language language) {
        if (language == this.Localizer.DefaultLanguage.get()) {
            return;
        }
        this.Localizer.setDefaultLanguage(language);
        ((GameSettings)this.Settings).setLanguage(language.Name);
    }

    protected VTask loadImportantAssetsAsync() {
        return VTask.COMPLETED_TASK;
    }

    protected void onImportantLoaded() {
    }

    protected VTask loadAssetsAsync() {
        if (this.skipLoadMedia()) {
            return VTask.COMPLETED_TASK;
        }
        return Async.runAsyncEnforced(() -> new ImageCollection((BufferedImage)MiscImg.loadImage((String)"/res/ioengine/images/flags.png"), (int)1, (int)2).Images).awaitAndContinue(this::onFlagsLoaded);
    }

    protected void onLoaded() {
        this.startExaminingUpdateChecker();
    }

    protected abstract Dispatcher createDispatcher();

    protected void onFlagsLoaded(BufferedImage[] flags) {
        ImageIcon[] flagIcons = new ImageIcon[flags.length];
        int i = 0;
        while (i < flags.length) {
            flagIcons[i] = new ImageIcon(flags[i]);
            ++i;
        }
        for (Language language : this.Localizer) {
            Integer idInteger = language.getProperty("flagID", null);
            if (idInteger == null) continue;
            int id = idInteger;
            if (id >= 0 && id < flagIcons.length) {
                language.setProperty("flagIcon", flagIcons[id]);
                language.setProperty("flagImg", flags[id]);
                continue;
            }
            Log.Developer.error("Language '" + language.Name + "' has an invalid flag ID (" + id + ")");
        }
    }

    public abstract String getVersion();

    protected UpdateCheckerInfo getUpdateCheckerInfo() {
        return null;
    }

    protected Localizer createLocalizer() {
        return new Localizer();
    }

    protected void parseArguments(List<String> cmd) {
        if (cmd.contains("-developer") || cmd.contains("-dev")) {
            this.developer = true;
        }
    }

    private void startExaminingUpdateChecker() {
        if (this.updateCheckerTask != null) {
            this.updateCheckerTask.await((UpdateChecker.Result)((Object)((Consumer<UpdateChecker.Result>)result -> {
                this.updateCheckerTask = null;
                ((AppSettings)this.Settings).onUpdateChecked();
                if (result.Successful && result.HasNewVersion) {
                    this.onUpdateFound(result.Version, result.OtherData);
                }
            })));
        }
    }

    protected abstract void onUpdateFound(String var1, String var2);

    public boolean isDevmode() {
        return this.developer;
    }

    protected S createSettings() {
        return (S)new GameSettings();
    }

    protected File getErrorFile() {
        if (this.Settings != null) {
            return new File(((GameSettings)this.Settings).getSettingsPath(), "errorlog.txt");
        }
        return new File(String.valueOf(this.getName()) + "_errorlog.txt");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToErrorLog(Throwable ex) {
        Object object = this.logLock;
        synchronized (object) {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (StringWriter sw = new StringWriter();){
                    Throwable throwable2 = null;
                    Object var7_11 = null;
                    try (PrintWriter pw = new PrintWriter(sw);){
                        pw.println(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                        pw.println(String.valueOf(this.getName()) + " " + this.getVersion());
                        ex.printStackTrace(pw);
                        pw.println();
                        pw.println();
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                    Files.write(this.getErrorFile().toPath(), sw.toString().getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.APPEND);
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void onError(Throwable ex) {
        try {
            if (this.stopped) {
                if (this.errorAfterStoppedReported) {
                    return;
                }
                this.errorAfterStoppedReported = true;
                ex.printStackTrace();
                Log.App.fatal("Another error occured. No more errors are being reported now.");
                this.addToErrorLog(ex);
                return;
            }
            Log.App.fatal("Error occured: " + ex);
            ex.printStackTrace();
            this.addToErrorLog(ex);
            this.shutDown();
            this.onFatalError(ex);
        }
        catch (Throwable r) {
            System.out.println("Error while processing onError? :(");
            r.printStackTrace();
            Log.App.fatalFull("Error while processing onError? :(", r);
        }
    }

    public final void shutDown() {
        if (this.isShuttingDown()) {
            return;
        }
        this.stopped = true;
        Log.App.info("Game stopped!");
        this.onStop();
        try {
            this.shutdownStarted.setFulfilled();
        }
        finally {
            this.shutDowner = this.doShutDownAsync();
            this.shutDowner.await(this.shutdownDone::setFulfilled);
            this.shutDowner.await(this.jvmKeepalive::dispose);
            if (this.updateCheckerTask != null) {
                if (this.updateCheckerTask.isRunning()) {
                    this.updateCheckerTask.cancel();
                }
                this.updateCheckerTask = null;
            }
        }
    }

    public BoolObservable getWriting() {
        return ((GameSettings)this.Settings).Saving;
    }

    public boolean isShuttingDown() {
        return this.shutDowner != null || this.stopped;
    }

    protected VTask doShutDownAsync() {
        BoolObservable savingObservable = this.getWriting();
        if (!savingObservable.get()) {
            return VTask.COMPLETED_TASK;
        }
        VTaskSource taskSource = new VTaskSource(TaskSourceBase.CANNOT_CANCEL);
        IDisposable awaiting = savingObservable.await(x -> !x, taskSource::setFulfilled);
        taskSource.CancelHandler = () -> awaiting.dispose();
        return (VTask)taskSource.getTask();
    }

    protected void onStop() {
        if (this.lastLoader != null && this.lastLoader.isRunning()) {
            try {
                this.lastLoader.cancel();
                this.lastLoader = null;
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
                this.addToErrorLog(e);
            }
        }
    }

    protected abstract void onFatalError(Throwable var1);

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public String getFullName() {
        return String.valueOf(this.getName()) + " " + this.getVersion();
    }

    protected boolean shouldCheckForUpdates() {
        return ((AppSettings)this.Settings).shouldCheckForUpdates();
    }

    public void addAsset(IAsset asset) {
        if (this.assets == null) {
            throw new IllegalStateException("Cannot load assets now");
        }
        this.assets.add(asset);
    }

    public IDisposable registerOnShutdown(Runnable runner) {
        if (this.ShutdownStarted.isCompleted()) {
            runner.run();
            return IDisposable.DO_NOTHING;
        }
        this._runOnShutdown.add(runner);
        return () -> {
            boolean bl = this._runOnShutdown.remove(runner);
        };
    }

    public static final class UpdateCheckerInfo {
        public final String Url;
        public final String Signature;

        public UpdateCheckerInfo(String url, String signature) {
            this.Url = Misc.notNull(url);
            this.Signature = Misc.notNull(signature);
        }
    }
}

