/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.iogame;

import com.iosoft.helpers.Misc;
import java.util.ArrayList;
import java.util.Arrays;

public class ConsoleCommand {
    public final String Action;
    public final String[] Params;

    public ConsoleCommand(String command, String[] params) {
        this.Action = Misc.notNull(command);
        this.Params = Misc.notNull(params);
    }

    public String pretty() {
        return String.valueOf(this.Action) + " (" + String.join((CharSequence)", ", Arrays.asList(this.Params)) + ")";
    }

    public String toString() {
        return "ConsoleCommand(" + this.pretty() + ")";
    }

    public static ConsoleCommand parse(String line) {
        String cmd;
        int length = line.length();
        int firstSpace = line.indexOf(32);
        String string = cmd = firstSpace == -1 ? line : line.substring(0, firstSpace);
        if (firstSpace == -1) {
            firstSpace = line.length();
        }
        boolean quoted = false;
        boolean slashed = false;
        String currentArg = null;
        ArrayList<String> args = new ArrayList<String>();
        int i = firstSpace + 1;
        while (i < length) {
            char c = line.charAt(i);
            switch (c) {
                case ' ': {
                    if (currentArg != null) {
                        if (quoted) {
                            currentArg = String.valueOf(currentArg) + c;
                        } else {
                            args.add(currentArg);
                            currentArg = null;
                        }
                    }
                    slashed = false;
                    break;
                }
                case '\\': {
                    if (slashed) {
                        if (currentArg == null) {
                            currentArg = "\\";
                            quoted = false;
                        } else {
                            currentArg = String.valueOf(currentArg) + '\\';
                        }
                        slashed = false;
                        break;
                    }
                    slashed = true;
                    break;
                }
                case '\"': {
                    if (slashed) {
                        if (currentArg == null) {
                            currentArg = "\"";
                            quoted = false;
                        } else {
                            currentArg = String.valueOf(currentArg) + '\"';
                        }
                        slashed = false;
                        break;
                    }
                    if (currentArg == null) {
                        currentArg = "";
                        quoted = true;
                        break;
                    }
                    args.add(currentArg);
                    currentArg = null;
                    quoted = false;
                    break;
                }
                default: {
                    slashed = false;
                    if (currentArg == null) {
                        currentArg = "" + c;
                        quoted = false;
                        break;
                    }
                    currentArg = String.valueOf(currentArg) + c;
                }
            }
            ++i;
        }
        if (currentArg != null) {
            args.add(currentArg);
        }
        return new ConsoleCommand(cmd, args.toArray(new String[args.size()]));
    }
}

