/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.iogame;

import com.iosoft.helpers.Log;
import com.iosoft.iogame.Settings;
import com.iosoft.iogame.saveload.IKVRW;
import com.iosoft.iogame.saveload.IKVRead;
import com.iosoft.iogame.saveload.IKVWrite;
import java.io.File;

public abstract class AppSettings
extends Settings {
    protected long _timeUpdateCheckIntervalMillis = 86400000L;
    public boolean UpdateCheckEnabled = true;
    private long _lastUpdateCheck;
    protected String _settingsVersion;
    protected String _currentGameVersion;

    public void init(String currentGameVersion) {
        this._currentGameVersion = currentGameVersion;
    }

    protected abstract File getSettingsPath();

    public boolean shouldCheckForUpdates() {
        return this.UpdateCheckEnabled && this._lastUpdateCheck + this._timeUpdateCheckIntervalMillis < System.currentTimeMillis();
    }

    protected boolean settingsNeedUpdate() {
        return !this._settingsVersion.equals(this._currentGameVersion);
    }

    @Override
    protected void read(IKVRead kv) {
        this._settingsVersion = kv.getString("settingsVersion", "");
        super.read(kv);
    }

    @Override
    protected void write(IKVWrite kv) {
        if (this.settingsNeedUpdate()) {
            Log.Developer.info("Updating settings");
            this._settingsVersion = this._currentGameVersion;
            kv.setString("settingsVersion", this._currentGameVersion);
        }
        super.write(kv);
    }

    @Override
    protected void rw(IKVRW rw) {
        this._lastUpdateCheck = rw.rwLong("lastUpdateCheck", this._lastUpdateCheck);
        this.UpdateCheckEnabled = rw.rwBool("updateEnabled", this.UpdateCheckEnabled);
    }

    public void onUpdateChecked() {
        this._lastUpdateCheck = System.currentTimeMillis();
        this.save();
    }
}

