/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.iogame;

import com.iosoft.helpers.Log;
import com.iosoft.helpers.Pair;
import com.iosoft.helpers.async.Task;
import com.iosoft.helpers.io.MiscIO;
import com.iosoft.iogame.ISettingsProvider;
import com.iosoft.iogame.saveload.IKVNode;
import java.io.File;
import java.io.IOException;

public abstract class AbstractSettingsProvider<T>
implements ISettingsProvider {
    private final File _fileSettings;
    private T _container;
    private IKVNode _node;

    public AbstractSettingsProvider(File settingsFolder) throws IOException {
        MiscIO.mkdirs(settingsFolder);
        this._fileSettings = new File(settingsFolder, "settings." + this.getFileExtension());
    }

    @Override
    public File getSettingsFile() {
        return this._fileSettings;
    }

    @Override
    public IKVNode load() throws IOException {
        boolean fresh;
        boolean bl = fresh = !this._fileSettings.exists();
        if (fresh) {
            Log.App.info("Settings file '" + this._fileSettings + "' not found");
        }
        Pair<T, IKVNode> pair = this.load(this._fileSettings, fresh);
        this._container = pair.V1;
        this._node = (IKVNode)pair.V2;
        return this._node;
    }

    protected abstract Pair<T, IKVNode> load(File var1, boolean var2) throws IOException;

    @Override
    public void saveBlocking() throws IOException {
        this.saveBlocking(this._container, this._node, this._fileSettings);
    }

    protected abstract void saveBlocking(T var1, IKVNode var2, File var3) throws IOException;

    @Override
    public Task<IOException> saveAsync() {
        return this.saveAsync(this._container, this._node, this._fileSettings);
    }

    protected abstract Task<IOException> saveAsync(T var1, IKVNode var2, File var3);

    protected abstract String getFileExtension();
}

