/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.ioengine.serverbrowser.server;

import com.iosoft.helpers.Blocker;
import com.iosoft.helpers.IDisposable;
import com.iosoft.helpers.Log;
import com.iosoft.helpers.Misc;
import com.iosoft.helpers.Mutable;
import com.iosoft.helpers.Pair;
import com.iosoft.helpers.Stopwatch;
import com.iosoft.helpers.VWaiter;
import com.iosoft.helpers.Waiter;
import com.iosoft.helpers.WrapException;
import com.iosoft.helpers.async.dispatcher.Dispatcher;
import com.iosoft.helpers.network.MiscNet;
import com.iosoft.helpers.network.util.IpVersion;
import com.iosoft.ioengine.game.IpAddressPair;
import com.iosoft.ioengine.serverbrowser.BaseServerInfo;
import com.iosoft.ioengine.serverbrowser.server.MasterServerHeartbeat;
import com.iosoft.ioengine.serverbrowser.server.RequestReceiver;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class ServerBrowserServer
implements IDisposable {
    public static final Log.Category Log = new Log.Category("ServerBrowserServer");
    private static final double SecServerInfoBestBefore = 1.0;
    private static final double SecServerInfoMustRefresh = 2.0;
    public boolean EnableInternet = true;
    public boolean EnableMulticast = true;
    public boolean EnableBroadcastFallback = true;
    private RequestReceiver _multicastReceiver;
    private final Map<Character, RequestReceiver> _plainReceivers = new HashMap<Character, RequestReceiver>();
    private MasterServerHeartbeat _masterServerHeartbeat;
    private boolean _isRunning = true;
    private final String _clientIdentify;
    private final Supplier<BaseServerInfo> _serverInfoCreator;
    private final Dispatcher _dispatcher = Dispatcher.getForCurrentThread();
    private final Object _lockServerInfo = new Object();
    private final List<VWaiter> _closingBlockers;
    private ServerInfoWrap _currentServerInfo;
    private Waiter<ServerInfoWrap> _currentServerInfoBlocker;

    public ServerBrowserServer(String clientIdentify, Supplier<BaseServerInfo> serverInfoCreator, List<VWaiter> closingBlockers) {
        this._clientIdentify = clientIdentify;
        this._serverInfoCreator = serverInfoCreator;
        this._closingBlockers = closingBlockers;
    }

    public boolean tryStartPlainUdp(char port, InetAddress udpForceIP, Consumer<IOException> OnError) throws SocketException {
        Misc.notNull(OnError);
        if (this._plainReceivers.containsKey(Character.valueOf(port))) {
            return false;
        }
        DatagramSocket inetSocket = udpForceIP == null ? new DatagramSocket(port) : new DatagramSocket(port, udpForceIP);
        Log.info("Broadcast/Internet server browser server started on " + inetSocket.getLocalSocketAddress());
        RequestReceiver rr = new RequestReceiver(inetSocket, "Broadcast/Internet", this._clientIdentify, this::getServerInfo, OnError, null);
        this._closingBlockers.add(rr.getClosingBlocker());
        this._plainReceivers.put(Character.valueOf(port), rr);
        return true;
    }

    public void startMasterServerHeartbeat(String masterServerUrl, char port) {
        Misc.notNull(masterServerUrl);
        if (this._masterServerHeartbeat != null) {
            throw new IllegalStateException("Already started");
        }
        this._masterServerHeartbeat = new MasterServerHeartbeat(masterServerUrl, port);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Character tryStartMulticast(char[] lanPorts, IpAddressPair multicastAddresses, IpVersion preferredIpVersion, InetAddress forceAddress, Consumer<IOException> OnError) {
        if (!this.EnableMulticast) {
            return null;
        }
        char[] cArray = lanPorts;
        int n = lanPorts.length;
        int n2 = 0;
        while (n2 < n) {
            char port = cArray[n2];
            if (this._plainReceivers.containsKey(Character.valueOf(port))) {
                Log.info("LAN - Skipping port " + port);
            } else {
                try {
                    MulticastSocket multicastSocket = new MulticastSocket(port);
                    boolean success = false;
                    try {
                        try {
                            multicastSocket.setBroadcast(true);
                        }
                        catch (SocketException e) {
                            Log.warning("LAN - Could not set to broadcast: " + e);
                        }
                        ArrayList<Pair<InetSocketAddress, NetworkInterface>> registeredOn = new ArrayList<Pair<InetSocketAddress, NetworkInterface>>();
                        for (NetworkInterface networkInterface : MiscNet.getProbableNetworkInterfaces(true)) {
                            for (InetAddress multicastAddress : multicastAddresses.list(preferredIpVersion)) {
                                String name = "LAN - Multicast IPv" + (multicastAddress instanceof Inet4Address ? "4" : "6") + " '" + networkInterface.getDisplayName() + "' (" + networkInterface.getName() + ")";
                                InetSocketAddress address = new InetSocketAddress(multicastAddress, (int)port);
                                try {
                                    multicastSocket.joinGroup(address, networkInterface);
                                    Log.info(String.valueOf(name) + " registered on '" + address + "'");
                                    registeredOn.add(new Pair<InetSocketAddress, NetworkInterface>(address, networkInterface));
                                }
                                catch (IOException e) {
                                    Log.warning(String.valueOf(name) + " address '" + address + "' unavailable (" + e + ")");
                                }
                            }
                        }
                        if (!registeredOn.isEmpty()) {
                            Log.info("LAN Server browser server started on " + registeredOn.size() + " addresses");
                            this._multicastReceiver = new RequestReceiver(multicastSocket, "Multicast (LAN)", this._clientIdentify, this::getServerInfo, OnError, () -> {
                                for (Pair entry : registeredOn) {
                                    try {
                                        multicastSocket.leaveGroup((SocketAddress)entry.V1, (NetworkInterface)entry.V2);
                                    }
                                    catch (IOException | IllegalArgumentException e) {
                                        Log.errorShort("leaveGroup", e);
                                    }
                                }
                            });
                            this._closingBlockers.add(this._multicastReceiver.getClosingBlocker());
                            success = true;
                            Character c = Character.valueOf(port);
                            return c;
                        }
                    }
                    finally {
                        if (!success) {
                            Misc.forceClose(multicastSocket);
                        }
                    }
                }
                catch (IOException e) {
                    Log.warning("LAN - Port " + port + " is unavailable for multicast: " + e);
                }
            }
            ++n2;
        }
        Log.error("LAN Multicast could not be started on any port");
        return null;
    }

    public void startLAN(char[] lanPorts, IpAddressPair multicastAddresses, IpVersion preferredIpVersion, InetAddress forceAddress, Consumer<IOException> OnError) {
        Misc.notNull(lanPorts);
        Misc.notNull(multicastAddresses);
        if (lanPorts.length == 0) {
            throw new IllegalArgumentException("lanPorts may not be empty");
        }
        Misc.notNull(OnError);
        if (this._multicastReceiver != null) {
            throw new IllegalStateException("Already started");
        }
        Character multicastPort = this.tryStartMulticast(lanPorts, multicastAddresses, preferredIpVersion, forceAddress, OnError);
        boolean startedFallbackPort = false;
        if (this.EnableBroadcastFallback) {
            Set<Character> usedPlainPorts = this._plainReceivers.keySet();
            char[] cArray = lanPorts;
            int n = lanPorts.length;
            int n2 = 0;
            while (n2 < n) {
                char lanPort = cArray[n2];
                if (usedPlainPorts.contains(Character.valueOf(lanPort))) {
                    Log.info("LAN - Using Internet port " + lanPort + " as broadcast fallback");
                    return;
                }
                ++n2;
            }
            cArray = lanPorts;
            n = lanPorts.length;
            n2 = 0;
            while (n2 < n) {
                char port = cArray[n2];
                if (multicastPort != null && multicastPort.charValue() == port || this._plainReceivers.containsKey(Character.valueOf(port))) {
                    Log.info("LAN - Skipping port " + port);
                } else {
                    try {
                        if (this.tryStartPlainUdp(port, forceAddress == null ? MiscNet.BroadcastReceiveAddress : forceAddress, error -> Log.errorShort("LAN - Broadcast fallback failed", (Throwable)error))) {
                            Log.info("LAN - Using port " + port + " as broadcast fallback");
                            startedFallbackPort = true;
                            break;
                        }
                    }
                    catch (SocketException e) {
                        Log.warning("LAN - Port " + port + " is unavailable for broadcast fallback: " + e);
                    }
                }
                ++n2;
            }
            if (!startedFallbackPort) {
                Log.info("LAN - No broadcast fallback port available");
            }
        }
        if (multicastPort == null && startedFallbackPort) {
            OnError.accept(new IOException("No multicast and no broadcast addresses available"));
        }
    }

    @Override
    public void dispose() {
        this._isRunning = false;
        if (this._masterServerHeartbeat != null) {
            this._masterServerHeartbeat.dispose();
            this._masterServerHeartbeat = null;
        }
        if (this._multicastReceiver != null) {
            this._multicastReceiver.end();
            this._multicastReceiver = null;
        }
        RequestReceiver[] plainReceivers = this._plainReceivers.values().toArray(new RequestReceiver[this._plainReceivers.size()]);
        this._plainReceivers.clear();
        RequestReceiver[] requestReceiverArray = plainReceivers;
        int n = plainReceivers.length;
        int n2 = 0;
        while (n2 < n) {
            RequestReceiver plainReceiver = requestReceiverArray[n2];
            plainReceiver.end();
            ++n2;
        }
    }

    private byte[] getServerInfo(int requestId) {
        try {
            ServerInfoWrap serverInfo = this.getServerInfoWrap();
            return serverInfo.getServerInfoMessage(requestId);
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerInfoWrap getServerInfoWrap() throws InterruptedException {
        Waiter<ServerInfoWrap> waiter;
        ServerInfoWrap earlyReturn = null;
        Blocker blocker = null;
        Mutable newServerInfo = null;
        Object object = this._lockServerInfo;
        synchronized (object) {
            if (this._currentServerInfo != null) {
                double secPassed = Stopwatch.getSeconds(this._currentServerInfo.Timestamp);
                if (secPassed < 2.0) {
                    if (secPassed < 1.0 || this._currentServerInfoBlocker != null) {
                        return this._currentServerInfo;
                    }
                    earlyReturn = this._currentServerInfo;
                } else {
                    this._currentServerInfo = null;
                }
            }
            if (this._currentServerInfoBlocker == null) {
                blocker = new Blocker(this._lockServerInfo);
                newServerInfo = new Mutable();
                this._currentServerInfoBlocker = blocker.withResult(newServerInfo);
            }
            waiter = this._currentServerInfoBlocker;
        }
        if (blocker != null) {
            Mutable newServerInfo2 = newServerInfo;
            Blocker blocker2 = blocker;
            this._dispatcher.dispatch(() -> {
                ServerInfoWrap info = new ServerInfoWrap(this._isRunning ? this._serverInfoCreator.get() : null);
                Object object = this._lockServerInfo;
                synchronized (object) {
                    this._currentServerInfoBlocker = null;
                    this._currentServerInfo = info;
                    mutable.Value = this._currentServerInfo;
                    blocker2.fulfill();
                }
            });
        }
        if (earlyReturn != null) {
            return earlyReturn;
        }
        return waiter.waitBlockingInterruptible();
    }

    private static final class ServerInfoWrap {
        public final long Timestamp = Stopwatch.start();
        private final BaseServerInfo _serverInfo;
        private byte[] _message;
        private int _offset;

        ServerInfoWrap(BaseServerInfo serverInfo) {
            this._serverInfo = serverInfo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public byte[] getServerInfoMessage(int requestId) {
            ServerInfoWrap serverInfoWrap = this;
            synchronized (serverInfoWrap) {
                block22: {
                    if (this._serverInfo != null) break block22;
                    return null;
                }
                if (this._message == null) {
                    try {
                        Throwable throwable = null;
                        Object var4_6 = null;
                        try {
                            byte[] byArray;
                            DataOutputStream out;
                            ByteArrayOutputStream baos;
                            block24: {
                                block23: {
                                    baos = new ByteArrayOutputStream();
                                    out = new DataOutputStream(baos);
                                    this._serverInfo.RequestID = requestId;
                                    this._serverInfo.write1(out);
                                    this._offset = baos.size();
                                    this._serverInfo.write2(out);
                                    byArray = this._message = baos.toByteArray();
                                    if (out == null) break block23;
                                    out.close();
                                }
                                if (baos == null) break block24;
                                baos.close();
                            }
                            return byArray;
                            {
                                catch (Throwable throwable2) {
                                    try {
                                        if (out != null) {
                                            out.close();
                                        }
                                        throw throwable2;
                                    }
                                    catch (Throwable throwable3) {
                                        if (throwable == null) {
                                            throwable = throwable3;
                                        } else if (throwable != throwable3) {
                                            throwable.addSuppressed(throwable3);
                                        }
                                        if (baos != null) {
                                            baos.close();
                                        }
                                        throw throwable;
                                    }
                                }
                            }
                        }
                        catch (Throwable throwable4) {
                            if (throwable == null) {
                                throwable = throwable4;
                            } else if (throwable != throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        throw new WrapException(e);
                    }
                }
            }
            byte[] copy = Arrays.copyOf(this._message, this._message.length);
            Misc.insertInt(copy, this._offset, requestId);
            return copy;
        }
    }
}

