/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.ioengine.serverbrowser.server;

import com.iosoft.helpers.Blocker;
import com.iosoft.helpers.Misc;
import com.iosoft.helpers.VWaiter;
import com.iosoft.helpers.async.SubProcess;
import com.iosoft.ioengine.serverbrowser.BaseRequestInfo;
import com.iosoft.ioengine.serverbrowser.server.ServerBrowserServer;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketAddress;
import java.util.function.Consumer;
import java.util.function.IntFunction;

public class RequestReceiver
extends SubProcess {
    private final DatagramSocket _socket;
    private final Runnable _onDispose;
    private final Object _closingLock = new Object();
    private final Blocker _closingBlocker = new Blocker(this._closingLock);
    private boolean _closed;

    public RequestReceiver(DatagramSocket socket, String target, String clientIdentify, IntFunction<byte[]> serverInfoCreator, Consumer<IOException> onSocketError, Runnable onDispose) {
        this._socket = Misc.notNull(socket);
        this._onDispose = onDispose;
        Misc.notNull(target);
        Misc.notNull(serverInfoCreator);
        this.start("ServerBrowser " + target + " Receiver (" + socket.getLocalSocketAddress() + ")", () -> {
            try {
                byte[] buffer = new byte[1024];
                DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
                while (!Thread.interrupted()) {
                    socket.receive(packet);
                    if (Thread.interrupted()) {
                        return;
                    }
                    SocketAddress clientAddress = packet.getSocketAddress();
                    BaseRequestInfo requestInfo = new BaseRequestInfo();
                    requestInfo.ClientIdentify = clientIdentify;
                    try {
                        Throwable throwable = null;
                        Object var9_12 = null;
                        try (DataInputStream in = new DataInputStream(new ByteArrayInputStream(packet.getData(), packet.getOffset(), packet.getLength()));){
                            requestInfo.read(in);
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        ServerBrowserServer.Log.warning("Invalid metadata request from " + clientAddress + ": " + e);
                        continue;
                    }
                    if (!requestInfo.Valid) {
                        ServerBrowserServer.Log.warning("Invalid metadata request from " + clientAddress);
                        continue;
                    }
                    byte[] message = (byte[])serverInfoCreator.apply(requestInfo.RequestID);
                    if (message == null) {
                        return;
                    }
                    try {
                        socket.send(new DatagramPacket(message, message.length, clientAddress));
                        continue;
                    }
                    catch (IOException e) {
                        this.post(() -> {
                            this.onEnd();
                            onSocketError.accept(e);
                        });
                    }
                    break;
                }
            }
            finally {
                this.closeSocket();
            }
        });
    }

    public VWaiter getClosingBlocker() {
        return this._closingBlocker;
    }

    @Override
    public void end() {
        Misc.startDaemonThread("RequestReceiver Closer Thread", this::closeSocket);
        super.end();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSocket() {
        Object object = this._closingLock;
        synchronized (object) {
            if (this._closed) {
                return;
            }
            this._closed = true;
            try {
                try {
                    ServerBrowserServer.Log.info("Closing " + this._socket.getLocalSocketAddress());
                    if (this._onDispose != null) {
                        this._onDispose.run();
                    }
                }
                finally {
                    Misc.forceClose(this._socket);
                }
            }
            finally {
                this._closingBlocker.fulfill();
            }
        }
    }
}

