/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.ioengine.serverbrowser.server;

import com.iosoft.helpers.IDisposable;
import com.iosoft.helpers.Misc;
import com.iosoft.helpers.async.Async;
import com.iosoft.helpers.async.VTask;
import com.iosoft.helpers.web.MiscWeb;
import java.util.function.Consumer;

public class MasterServerHeartbeat
implements IDisposable {
    private static final double HEARTBEAT_EVERY_SEC = 90.0;
    private static final double HEARTBEAT_UPDATE_TIMEOUT_SEC = 10.0;
    private static final double HEARTBEAT_KILL_TIMEOUT_SEC = 1.0;
    private final String _masterServerUrl;
    private VTask _taskCurrent;
    private String _hash;
    private boolean _pause = false;

    public MasterServerHeartbeat(String masterServerUrl, char port) {
        this._masterServerUrl = Misc.notNull(masterServerUrl, "masterServerUrl");
        this._taskCurrent = Async.whileDo(() -> {
            if (this._pause) {
                this._pause = false;
                return VTask.delay(90.0);
            }
            if (this._hash != null) {
                return this.requestAsync("update&hash=" + this._hash, x -> {
                    if (x == null || !x.equals("1")) {
                        this._hash = null;
                    } else {
                        this._pause = true;
                    }
                });
            }
            return this.requestAsync("add&port=" + port, x -> {
                this._pause = true;
                if (!(x == null || x.equals("-1") || x.equals("-2") || x.equals("-3") || x.equals("0"))) {
                    this._hash = x;
                }
            });
        });
    }

    private VTask requestAsync(String parameter, Consumer<String> continuer) {
        return this.requestAsync(parameter, 10.0, continuer);
    }

    private VTask requestAsync(String parameter, double sec_timeout, Consumer<String> continuer) {
        return MiscWeb.getFirstLineAsync(String.valueOf(this._masterServerUrl) + "?job=" + parameter, sec_timeout, 100).awaitAndContinue(x -> continuer.accept(x.tryGetFirstLine()));
    }

    @Override
    public void dispose() {
        if (this._taskCurrent != null) {
            this._taskCurrent.cancel();
            this._taskCurrent = null;
        }
        if (this._hash != null) {
            this._taskCurrent = this.requestAsync("remove&hash=" + this._hash, 1.0, x -> {
                VTask vTask = this._taskCurrent = null;
            });
            this._hash = null;
        }
    }
}

