/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.ioengine.serverbrowser.client.ui.awt;

import com.iosoft.helpers.HtmlEscape;
import com.iosoft.helpers.Misc;
import com.iosoft.helpers.MiscLINQ;
import com.iosoft.helpers.Pair;
import com.iosoft.helpers.binding.Disposables;
import com.iosoft.helpers.localizer.Localizer;
import com.iosoft.helpers.network.IpPortOptional;
import com.iosoft.helpers.ui.awt.MiscAWT;
import com.iosoft.ioengine.game.NetworkGame;
import com.iosoft.ioengine.serverbrowser.BaseServerInfo;
import com.iosoft.ioengine.serverbrowser.client.ServerDataDto;
import com.iosoft.ioengine.serverbrowser.client.ServerEntry;
import com.iosoft.ioengine.serverbrowser.client.ServerListModel;
import com.iosoft.ioengine.serverbrowser.client.ui.Column;
import com.iosoft.ioengine.serverbrowser.client.ui.HeadingModel;
import com.iosoft.ioengine.serverbrowser.client.ui.IServerBrowserMiscProvider;
import com.iosoft.ioengine.serverbrowser.client.ui.IServerListView;
import com.iosoft.ioengine.serverbrowser.client.ui.ServerBrowserManager;
import com.iosoft.ioengine.serverbrowser.client.ui.ServerListLayouter;
import com.iosoft.ioengine.serverbrowser.client.ui.ServerListViewSurrogate;
import com.iosoft.ioengine.serverbrowser.client.ui.SortedServerList;
import com.iosoft.ioengine.serverbrowser.client.ui.awt.JLabelHeading;
import com.iosoft.ioengine.serverbrowser.client.ui.awt.SwingColumn;
import com.iosoft.ioengine.serverbrowser.client.ui.awt.SwingComponent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;

public class ServerListView<T extends BaseServerInfo>
extends JPanel
implements IServerListView<T> {
    private static final long serialVersionUID = 1L;
    protected float WORST_PING = 300.0f;
    protected Color ColorServerSelected = new Color(40, 40, 40);
    protected Column<SwingComponent, T> columnStatus;
    protected Column<SwingComponent, T> columnName;
    protected Column<SwingComponent, T> columnPlayers;
    protected Column<SwingComponent, T> columnOpen;
    protected Column<SwingComponent, T> columnInProgress;
    protected Column<SwingComponent, T> columnPing;
    protected Column<SwingComponent, T> columnClear;
    protected List<Column<SwingComponent, T>> columns = new ArrayList<Column<SwingComponent, T>>();
    private Column<SwingComponent, T> currentSortedColumn;
    protected final Disposables disposables = new Disposables();
    private ServerListLayouter layouter;
    private SortedServerList<T> serverListSorted;
    private JList<ServerEntry<T>> listView;
    private IServerBrowserMiscProvider _miscProvider;
    private JPanel panelDialog;
    private JLabel labelDialog;
    private JTextField inputDialog;
    private JComponent buttonDialog;
    private int addIndex;
    private ServerListViewSurrogate _surrogate;

    public static <T extends BaseServerInfo> Pair<ServerBrowserManager<T>, ServerListView<T>> createServerBrowserManager(NetworkGame<?, ?, ?, ?> game, Supplier<T> serverInfoCreator) {
        ServerListView<T> serverListView = new ServerListView<T>();
        return new Pair<ServerBrowserManager<T>, ServerListView<T>>(new ServerBrowserManager<T>(game, serverInfoCreator, serverListView), serverListView);
    }

    public ServerListView() {
        super(new BorderLayout());
        this.setForeground(Color.WHITE);
        this.setBackground(Color.BLACK);
    }

    @Override
    public void initialize(ServerListViewSurrogate surrogate, ServerListModel<T> serverList, IServerBrowserMiscProvider miscProvider) {
        this._surrogate = surrogate;
        this._miscProvider = miscProvider;
        this.disposables.addDisposable(serverList.OnInfoReceived.registerHandler((ServerEntry<Consumer<ServerEntry>>)((Object)((Consumer<ServerEntry>)this::onInfoUpdated))));
        this.setupColumns();
        this.currentSortedColumn = this.columnClear;
        this.currentSortedColumn.HeadingModel.setOrdering(true);
        Collections.sort(this.columns);
        this.serverListSorted = new SortedServerList<T>(serverList, () -> this.currentSortedColumn);
        this.layouter = new ServerListLayouter(this.columns);
        JPanel topRowPanel = new JPanel(null);
        topRowPanel.setOpaque(false);
        this.add((Component)topRowPanel, "North");
        JPanel serverEntryPanel = new JPanel(null);
        serverEntryPanel.setAlignmentX(0.0f);
        serverEntryPanel.setBackground(this.ColorServerSelected);
        for (Column<SwingComponent, T> column : this.columns) {
            topRowPanel.add(((SwingComponent)column.HeadingModel.getComponent()).UI);
            if (column.Component == null) continue;
            serverEntryPanel.add(((SwingComponent)column.Component).UI);
        }
        this.setHeight(topRowPanel, this.getHeadingHeight());
        this.setHeight(serverEntryPanel, this.getServerEntryHeight());
        this.listView = new JList<T>(this.serverListSorted);
        this.listView.setOpaque(false);
        this.listView.setSelectionMode(0);
        this.listView.setCellRenderer((list, value, index, isSelected, cellHasFocus) -> {
            for (Column<SwingComponent, T> column : this.columns) {
                column.fireValueSetter((ServerEntry<T>)value);
            }
            serverEntryPanel.setOpaque(isSelected);
            serverEntryPanel.setToolTipText(this.buildToolTip((ServerEntry<T>)value));
            return serverEntryPanel;
        });
        this.listView.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ServerListView.this.onClick();
                if (e.getClickCount() == 2) {
                    ServerListView.this.doConnect();
                }
            }
        });
        AbstractAction pressedOK = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ServerListView.this.onClick();
                ServerListView.this.doConnect();
            }
        };
        this.listView.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "ok");
        this.listView.getActionMap().put("ok", pressedOK);
        JScrollPane scrollPane = new JScrollPane(this.listView);
        scrollPane.setBorder(null);
        scrollPane.getViewport().setOpaque(false);
        scrollPane.setOpaque(false);
        this.add((Component)scrollPane, "Center");
        this.listView.addListSelectionListener(evt -> this.checkCanConnect());
        this.panelDialog = this.createDialog();
        this.labelDialog = this.createDialogLabel();
        this.panelDialog.add((Component)this.labelDialog, "North");
        this.inputDialog = this.createDialogInput();
        this.inputDialog.addActionListener(evt -> this.onConfirmFavoriteDialog());
        this.inputDialog.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    ServerListView.this.closeDialog();
                }
            }
        });
        this.panelDialog.add((Component)this.inputDialog, "Center");
        this.buttonDialog = this.createDialogButton(miscProvider.getLocalizer().translate("_UI_ServerBrowser_OK"), this::onConfirmFavoriteDialog);
        this.panelDialog.add((Component)this.buttonDialog, "South");
        this.checkCanConnect();
    }

    @Override
    public void dispose() {
        this.disposables.dispose();
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.columns != null) {
            for (Column<SwingComponent, T> column : this.columns) {
                if (column.Component == null || ((SwingComponent)column.Component).UI == null) continue;
                ((SwingComponent)column.Component).UI.setForeground(fg);
            }
        }
    }

    protected void onInfoUpdated(ServerEntry<T> server) {
    }

    private void checkCanConnect() {
        this.closeDialog();
        this._surrogate.setSelectedServer(this.listView.getSelectedValue());
    }

    @Override
    public void doConnect() {
        this.connectTo(this.listView.getSelectedValue());
    }

    private void connectTo(ServerEntry<T> server) {
        if (server == null) {
            return;
        }
        List<SocketAddress> addresses = server.getTcpAddresses();
        if (addresses.isEmpty()) {
            ServerDataDto dto = server.getServerData();
            this._miscProvider.tryConnectTo(new IpPortOptional(dto.IP, dto.Port));
        } else {
            this._miscProvider.tryConnectTo(addresses);
        }
    }

    private void setHeight(JComponent component, int height) {
        component.setMinimumSize(new Dimension(0, height));
        component.setMaximumSize(new Dimension(this.getWidth(), height));
        component.setPreferredSize(new Dimension(this.getWidth(), height));
    }

    @Override
    public void doLayout() {
        super.doLayout();
        this.layouter.calculateLayout(this.getWidth(), this.getHeadingHeight(), this.getServerEntryHeight());
        this.panelDialog.setBounds((this.getWidth() - 500) / 2, (this.getHeight() - 130) / 2, 500, 130);
    }

    protected void setupColumns() {
        this.columnStatus = this.addColumn("Status", 35.0f, 0.0f, Comparator.comparing(ServerEntry::getState), (ServerEntry<T> server, JLabel label) -> label.setIcon(this._miscProvider.getServerBrowserIcon(server.getState().IconIndex)), true, true);
        this.columnStatus.setOrderingIndex(-2000);
        this.columnName = this.addColumn("Name", 200.0f, 0.2f, ServerEntry::getName, false);
        this.columnName.setOrderingIndex(-1000);
        this.columnPlayers = this.addColumn("Players", 80.0f, 0.1f, this::comparePlayers, (ServerEntry<T> x) -> {
            Object info = x.getInfo();
            String text = String.valueOf(((BaseServerInfo)info).NumHumanPlayers) + " / " + ((BaseServerInfo)info).MaxHumanPlayers;
            if (((BaseServerInfo)info).NumBots > 0) {
                text = String.valueOf(text) + " (+" + ((BaseServerInfo)info).NumBots + ")";
            }
            return text;
        });
        this.columnOpen = this.addColumn("OpenGame", x -> ((BaseServerInfo)x.getInfo()).Open);
        this.columnInProgress = this.addColumn("InProgress", x -> ((BaseServerInfo)x.getInfo()).InProgress);
        this.columnPing = this.addColumn("Ping", 70.0f, 0.05f, this::comparePing, this::setPing, false);
        this.columnPing.setOrderingIndex(1000);
        this.columnClear = this.addColumn("Clear", this.getHeadingHeight(), 0.0f);
        this.columnClear.setOrderingIndex(2000);
    }

    protected int comparePlayers(ServerEntry<T> server1, ServerEntry<T> server2) {
        T info1 = server1.getInfo();
        T info2 = server2.getInfo();
        int players1 = ((BaseServerInfo)info1).NumHumanPlayers;
        int players2 = ((BaseServerInfo)info2).NumHumanPlayers;
        if (players1 == players2) {
            players1 = ((BaseServerInfo)info1).MaxHumanPlayers;
            players2 = ((BaseServerInfo)info2).MaxHumanPlayers;
        }
        if (players1 == players2) {
            players1 = ((BaseServerInfo)info1).NumBots;
            players2 = ((BaseServerInfo)info2).NumBots;
        }
        return Integer.compare(players1, players2);
    }

    protected int comparePing(ServerEntry<T> server1, ServerEntry<T> server2) {
        int result = Boolean.compare(server1.hasAnswered(), server2.hasAnswered());
        if (result != 0) {
            return -result;
        }
        int ping1 = server1.getPing() == null ? Integer.MAX_VALUE : server1.getPing();
        int ping2 = server2.getPing() == null ? Integer.MAX_VALUE : server2.getPing();
        return Integer.compare(ping1, ping2);
    }

    protected int getHeadingHeight() {
        return 30;
    }

    protected int getServerEntryHeight() {
        return 30;
    }

    private Color getPingColor(Integer ping) {
        if (ping == null) {
            return Color.GRAY;
        }
        float percentage = Misc.clamp((float)ping.intValue() / this.WORST_PING, 0.0f, 1.0f);
        int red = Math.min((int)(510.0f * percentage), 255);
        int green = Math.min((int)(510.0f * (1.0f - percentage)), 255);
        return new Color(red, green, 0);
    }

    private void setPing(ServerEntry<T> server, JLabel label) {
        Integer ping = server.getPing();
        label.setForeground(this.getPingColor(ping));
        label.setText(ping == null ? "?" : server.getPing().toString());
    }

    protected SwingColumn<T> addColumn(String name, float minimumSize, float fractionSize) {
        return this.addColumn(name, minimumSize, fractionSize, (Comparator<ServerEntry<T>>)null, (BiConsumer<ServerEntry<T>, JLabel>)null);
    }

    protected <S extends Comparable<S>> SwingColumn<T> addColumn(String name, float minimumSize, float fractionSize, Function<ServerEntry<T>, S> valueGetter) {
        return this.addColumn(name, minimumSize, fractionSize, Comparator.comparing(valueGetter), (ServerEntry<T> server, JLabel label) -> label.setText(((Comparable)valueGetter.apply((ServerEntry)server)).toString()));
    }

    protected <S extends Comparable<S>> SwingColumn<T> addColumn(String name, float minimumSize, float fractionSize, Function<ServerEntry<T>, S> valueGetter, boolean defaultSortDescending) {
        return this.addColumn(name, minimumSize, fractionSize, Comparator.comparing(valueGetter), (server, label) -> label.setText(((Comparable)valueGetter.apply((ServerEntry)server)).toString()), defaultSortDescending);
    }

    protected SwingColumn<T> addColumn(String name, Predicate<ServerEntry<T>> boolGetter) {
        return this.addColumn(name, 45.0f, 0.0f, Comparator.comparing(x -> boolGetter.test((ServerEntry)x)), (ServerEntry<T> server, JLabel label) -> label.setIcon(boolGetter.test((ServerEntry<T>)server) ? this._miscProvider.getServerBrowserIcon(6) : null), true, true);
    }

    protected SwingColumn<T> addColumn(String name, float minimumSize, float fractionSize, Comparator<ServerEntry<T>> comparator, Function<ServerEntry<T>, String> valueGetter) {
        return this.addColumn(name, minimumSize, fractionSize, comparator, (ServerEntry<T> server, JLabel label) -> label.setText(((BaseServerInfo)server.getInfo()).Completeness == BaseServerInfo.CompletenessQuality.Complete ? (String)valueGetter.apply((ServerEntry)server) : ""));
    }

    protected SwingColumn<T> addColumn(String name, float minimumSize, float fractionSize, Comparator<ServerEntry<T>> comparator, BiConsumer<ServerEntry<T>, JLabel> valueSetter) {
        return this.addColumn(name, minimumSize, fractionSize, comparator, valueSetter, true);
    }

    protected SwingColumn<T> addColumn(String name, float minimumSize, float fractionSize, Comparator<ServerEntry<T>> comparator, BiConsumer<ServerEntry<T>, JLabel> valueSetter, boolean defaultSortDescending) {
        return this.addColumn(name, minimumSize, fractionSize, comparator, valueSetter, false, defaultSortDescending);
    }

    protected SwingColumn<T> addColumn(String name, float minimumSize, float fractionSize, Comparator<ServerEntry<T>> comparator, BiConsumer<ServerEntry<T>, JLabel> valueSetter, boolean horizontal, boolean defaultSortDescending) {
        JLabel label;
        HeadingModel<SwingComponent> headingModel = this.createHeadingLabel(name);
        JLabel jLabel = label = valueSetter == null ? null : this.createLabel(name);
        if (label != null && horizontal) {
            label.setHorizontalAlignment(0);
        }
        return this.addColumn(headingModel, minimumSize, fractionSize, comparator, label, valueSetter == null ? null : x -> valueSetter.accept((ServerEntry)x, label), defaultSortDescending);
    }

    protected SwingColumn<T> addColumn(HeadingModel<SwingComponent> headingModel, float minimumSize, float fractionSize, Comparator<ServerEntry<T>> comparator, JComponent component, Consumer<ServerEntry<T>> valueSetter, boolean defaultSortDescending) {
        SwingColumn<T> column = new SwingColumn<T>(headingModel, minimumSize, fractionSize, comparator, component, valueSetter, this.addIndex++, defaultSortDescending);
        this.columns.add(column);
        headingModel.Clicked.register(() -> this.onHeadingClick(column));
        return column;
    }

    protected void removeColumn(Column<SwingComponent, ?> column) {
        this.columns.remove(column);
    }

    protected HeadingModel<SwingComponent> createHeadingLabel(String name) {
        return new JLabelHeading(name, this._miscProvider.getLocalizer(), this._miscProvider.getServerBrowserIcon(0), this._miscProvider.getServerBrowserIcon(1));
    }

    protected JLabel createLabel(String name) {
        JLabel label = new JLabel();
        this.setupLabel(label);
        return label;
    }

    protected void setupLabel(JLabel label) {
        MiscAWT.disableHTML(label);
        label.setForeground(this.getForeground());
    }

    protected void onClick() {
    }

    protected void onHeadingClick(Column<SwingComponent, T> column) {
        this.onClick();
        if (this.currentSortedColumn == column) {
            column.HeadingModel.setOrdering(column.HeadingModel.SortDescending.get() == false);
        } else {
            this.currentSortedColumn.HeadingModel.setOrdering(null);
            this.currentSortedColumn = column;
            column.HeadingModel.setOrdering(column.DefaultSortDescending);
        }
        this.serverListSorted.update();
    }

    protected String buildToolTip(ServerEntry<T> server) {
        List<SocketAddress> addresses;
        T info = server.getInfo();
        Localizer localizer = this._miscProvider.getLocalizer();
        boolean needsBr = false;
        StringBuilder s = new StringBuilder();
        s.append("<html><body>");
        if (!((BaseServerInfo)info).Name.isEmpty()) {
            s.append("<u><b>");
            s.append(HtmlEscape.sanitizeForLabel(server.getName()));
            s.append("</b></u>");
            needsBr = true;
        }
        if (((BaseServerInfo)info).HasPassword) {
            if (needsBr) {
                s.append("<br>");
            }
            s.append(localizer.translate("_UI_ServerBrowser_Server_PasswordRequired"));
        }
        if ((addresses = server.getUdpAddresses()).isEmpty()) {
            if (needsBr) {
                s.append("<br>");
            }
            s.append("<i><font color=\"#FF0000\">");
            s.append(localizer.translate("_UI_ServerBrowser_Server_Error"));
            s.append("</font></i>");
            needsBr = true;
        } else {
            for (SocketAddress address : addresses) {
                if (needsBr) {
                    s.append("<br>");
                } else {
                    needsBr = true;
                }
                s.append("&rarr; ");
                if (address instanceof InetSocketAddress) {
                    String addressText;
                    InetSocketAddress inetAddress = (InetSocketAddress)address;
                    if (((BaseServerInfo)info).hasValidTcpPort()) {
                        addressText = new InetSocketAddress(inetAddress.getAddress(), ((BaseServerInfo)info).TcpPort).toString();
                        s.append(HtmlEscape.sanitizeForLabel(addressText.startsWith("/") ? addressText.substring(1) : addressText));
                        int udpPort = inetAddress.getPort();
                        if (udpPort == ((BaseServerInfo)info).TcpPort) continue;
                        s.append(" ");
                        s.append(localizer.translate("_UI_ServerBrowser_Server_Port", inetAddress.getPort()));
                        continue;
                    }
                    addressText = address.toString();
                    s.append(addressText.startsWith("/") ? addressText.substring(1) : addressText);
                    continue;
                }
                s.append(address);
                if (!((BaseServerInfo)info).hasValidTcpPort()) continue;
                s.append(" (TCP ");
                s.append(((BaseServerInfo)info).TcpPort);
                s.append(")");
            }
        }
        if (((BaseServerInfo)info).Completeness.HasBasicInfo) {
            s.append("<br><i>");
            s.append(localizer.translate("_UI_ServerBrowser_Server_Version", HtmlEscape.sanitizeForLabel(((BaseServerInfo)info).VersionSanitized)));
            if (!server.isCompatible()) {
                s.append(" <b>");
                s.append(localizer.translate("_UI_ServerBrowser_Server_Incompatible"));
                s.append("</b>");
            }
            s.append("</i>");
        }
        if (!server.WasDiscoveredByBroadcast) {
            s.append("<br>");
            s.append(localizer.translate("_UI_ServerBrowser_Server_Contacted", server.getRetries()));
            if (server.isRefreshed() && !server.hasAnswered()) {
                s.append("<br>");
                s.append(localizer.translate("_UI_ServerBrowser_Server_Unreachable"));
            }
        }
        s.append("</body></html>");
        return s.toString();
    }

    @Override
    public void closeDialog() {
        this.remove(this.panelDialog);
        MiscAWT.repaintWindow(this);
    }

    public void showDialog(String text, boolean useInput) {
        this.labelDialog.setText(text);
        this.inputDialog.setText("");
        this.inputDialog.setVisible(useInput);
        this.add((Component)this.panelDialog, 0);
        this.revalidate();
        if (useInput) {
            this.inputDialog.requestFocusInWindow();
        }
    }

    protected void onConfirmFavoriteDialog() {
        String text;
        this.closeDialog();
        if (this.inputDialog.isVisible() && !(text = this.inputDialog.getText().trim()).isEmpty()) {
            IpPortOptional ipPort = IpPortOptional.tryParse(text);
            if (ipPort == null) {
                this.showDialog(this._miscProvider.getLocalizer().translate("_UI_ServerBrowser_Invalid"), false);
            } else {
                ServerDataDto dto = MiscLINQ.firstOrDefault(this._miscProvider.getFavoritesServers(), x -> x.has(ipPortOptional.IpAddress, ipPortOptional.Port));
                if (dto == null) {
                    dto = new ServerDataDto(ipPort.IpAddress, ipPort.Port);
                }
                this.doAddFav(dto);
            }
        }
        MiscAWT.repaintWindow(this);
    }

    private ServerDataDto getFavData() {
        return this.listView.getSelectedValue().getServerData();
    }

    @Override
    public void addFav() {
        if (this._surrogate.isFavoriteMode()) {
            this.showDialog(this._miscProvider.getLocalizer().translate("_UI_ServerBrowser_NewFav"), true);
        } else if (this.listView.getSelectedValue() != null) {
            this.doAddFav(this.getFavData());
        }
    }

    private void doAddFav(ServerDataDto fav) {
        List<ServerDataDto> favs = this._miscProvider.getFavoritesServers();
        if (MiscLINQ.firstOrDefault(favs, x -> x.has(serverDataDto.IP, serverDataDto.Port)) != null) {
            this.showDialog(this._miscProvider.getLocalizer().translate("_UI_ServerBrowser_AlreadyFaved"), false);
            return;
        }
        favs.add(fav);
        this._miscProvider.setFavoritesServers(favs);
        this.showDialog(this._miscProvider.getLocalizer().translate("_UI_ServerBrowser_Faved"), false);
        this.refreshFavorites();
    }

    @Override
    public void removeFav() {
        ServerDataDto fav = this.getFavData();
        List<ServerDataDto> favs = this._miscProvider.getFavoritesServers();
        if (MiscLINQ.tryGetAndRemove(favs, x -> x.has(serverDataDto.IP, serverDataDto.Port)) != null) {
            this._miscProvider.setFavoritesServers(favs);
            this.showDialog(this._miscProvider.getLocalizer().translate("_UI_ServerBrowser_Unfaved"), false);
            this.refreshFavorites();
        } else {
            this.showDialog("fix your code", false);
        }
    }

    private void refreshFavorites() {
        if (this._surrogate.isFavoriteMode()) {
            this._surrogate.refreshFavorites();
        }
    }

    protected JPanel createDialog() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK, 2), new EmptyBorder(10, 10, 10, 10)));
        panel.setBackground(Color.GRAY);
        panel.setFocusCycleRoot(true);
        return panel;
    }

    protected JLabel createDialogLabel() {
        return new JLabel();
    }

    protected JTextField createDialogInput() {
        JTextField tf = new JTextField();
        return tf;
    }

    protected JComponent createDialogButton(String text, Runnable onClick) {
        JButton btn = new JButton(text);
        btn.addActionListener(evt -> onClick.run());
        return btn;
    }
}

