/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.ioengine.serverbrowser.client.ui.awt;

import com.iosoft.helpers.localizer.ILocalizer;
import com.iosoft.helpers.ui.awt.MiscAWT;
import com.iosoft.ioengine.serverbrowser.client.ui.HeadingModel;
import com.iosoft.ioengine.serverbrowser.client.ui.awt.SwingComponent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class JLabelHeading
extends HeadingModel<SwingComponent> {
    private static final Border STANDARD_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(new Color(70, 70, 70), new Color(30, 30, 30)), BorderFactory.createEmptyBorder(4, 4, 4, 4));
    private final SwingComponent component;
    private final JLabel label;
    private final Icon iconSortAscending;
    private final Icon iconSortDescending;

    public JLabelHeading(String name, ILocalizer translator, Icon iconSortAscending, Icon iconSortDescending) {
        super(name, translator);
        JComponent jComponent;
        this.iconSortAscending = iconSortAscending;
        this.iconSortDescending = iconSortDescending;
        this.label = new JLabel();
        this.label.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                JLabelHeading.this.fireClicked();
            }
        });
        this.label.setForeground(Color.WHITE);
        this.label.setBackground(Color.GRAY);
        this.addDisposable(translator.bind("_UI_ServerBrowser_Label_" + name, this.label::setText));
        this.addDisposable(translator.bind("_UI_ServerBrowser_Label_" + name + "_TT", this.label::setToolTipText));
        this.addDisposable(this.SortDescending.bind(this::setSortOrder));
        if ("Clear".equals(name)) {
            this.label.setHorizontalAlignment(0);
            this.label.setBorder(BorderFactory.createRaisedBevelBorder());
            JPanel panel = new JPanel(new BorderLayout());
            panel.setOpaque(false);
            panel.setBorder(new EmptyBorder(5, 5, 5, 5));
            panel.add((Component)this.label, "Center");
            jComponent = panel;
        } else {
            this.label.setBorder(STANDARD_BORDER);
            jComponent = this.label;
        }
        this.component = new SwingComponent(jComponent);
    }

    protected void setSortOrder(Boolean sortDescending) {
        if ("Clear".equals(this.Name)) {
            this.label.setVisible(sortDescending == null);
        } else if (sortDescending == null) {
            this.label.setOpaque(false);
            this.label.setIcon(null);
        } else {
            this.label.setOpaque(true);
            this.label.setIcon(sortDescending != false ? this.iconSortDescending : this.iconSortAscending);
        }
        MiscAWT.repaintWindow(this.label);
    }

    @Override
    public SwingComponent getComponent() {
        return this.component;
    }
}

