/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.ioengine.serverbrowser.client.ui;

import com.iosoft.helpers.IDisposable;
import com.iosoft.helpers.binding.Disposables;
import com.iosoft.helpers.ui.awt.MiscAWT;
import com.iosoft.ioengine.serverbrowser.BaseServerInfo;
import com.iosoft.ioengine.serverbrowser.client.ServerEntry;
import com.iosoft.ioengine.serverbrowser.client.ServerListModel;
import com.iosoft.ioengine.serverbrowser.client.ui.Column;
import com.iosoft.ioengine.serverbrowser.client.ui.awt.SwingComponent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.AbstractListModel;
import javax.swing.event.ListDataListener;

public class SortedServerList<T extends BaseServerInfo>
extends AbstractListModel<ServerEntry<T>>
implements IDisposable {
    private static final long serialVersionUID = 1L;
    private final List<ServerEntry<T>> internalList = new ArrayList<ServerEntry<T>>();
    private final ServerListModel<T> serverList;
    private final Disposables disposables = new Disposables();
    private final Supplier<Column<SwingComponent, T>> getCurrentColumn;

    public SortedServerList(ServerListModel<T> serverList, Supplier<Column<SwingComponent, T>> getCurrentColumn) {
        this.serverList = serverList;
        this.getCurrentColumn = getCurrentColumn;
        ListDataListener listDataListener = MiscAWT.createSimpleListDataListener(this::update);
        serverList.addListDataListener(listDataListener);
        this.disposables.addDisposable(() -> serverList.removeListDataListener(listDataListener));
    }

    public void update() {
        ArrayList<ServerEntry<T>> oldList = new ArrayList<ServerEntry<T>>(this.internalList);
        this.internalList.clear();
        this.internalList.addAll(this.serverList.getList());
        Column<SwingComponent, T> currentColumn = this.getCurrentColumn.get();
        if (currentColumn.Sorter != null) {
            Comparator sorter = currentColumn.Sorter;
            if (currentColumn.HeadingModel.SortDescending.get().booleanValue()) {
                sorter = Collections.reverseOrder(sorter);
            }
            this.internalList.sort(sorter);
        }
        int sizeOld = oldList.size();
        int sizeNew = this.internalList.size();
        if (sizeOld > 0 && sizeNew > 0) {
            this.fireContentsChanged(this, 0, Math.min(sizeOld, sizeNew));
        }
        if (sizeOld < sizeNew) {
            this.fireIntervalAdded(this, sizeOld, sizeNew);
        } else if (sizeOld > sizeNew) {
            this.fireIntervalRemoved(this, sizeNew, sizeOld);
        }
    }

    @Override
    public ServerEntry<T> getElementAt(int index) {
        return this.internalList.get(index);
    }

    @Override
    public int getSize() {
        return this.internalList.size();
    }

    @Override
    public void dispose() {
        this.disposables.dispose();
    }
}

