/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.ioengine.serverbrowser.client.ui;

import com.iosoft.helpers.DisposableWrapper;
import com.iosoft.helpers.binding.BoolObservable;
import com.iosoft.helpers.binding.Command;
import com.iosoft.helpers.binding.MyBoolObservable;
import com.iosoft.helpers.binding.Observable;
import com.iosoft.helpers.localizer.ILocalizer;
import com.iosoft.helpers.localizer.LocalizedString;
import com.iosoft.helpers.localizer.TextWithArguments;
import com.iosoft.ioengine.game.GameProtocol;
import com.iosoft.ioengine.serverbrowser.BaseServerInfo;
import com.iosoft.ioengine.serverbrowser.client.ServerBrowserClient;
import com.iosoft.ioengine.serverbrowser.client.ServerBrowserClientModel;
import com.iosoft.ioengine.serverbrowser.client.ServerEntry;
import com.iosoft.ioengine.serverbrowser.client.ui.IServerBrowserMiscProvider;
import com.iosoft.ioengine.serverbrowser.client.ui.IServerListView;
import com.iosoft.ioengine.serverbrowser.client.ui.ServerListViewSurrogate;
import java.util.function.Supplier;

public class ServerBrowserManager<T extends BaseServerInfo> {
    public static final String LOCALIZER_PREFIX = "_UI_ServerBrowser_";
    private final IServerListView<T> serverListView;
    private final ServerBrowserClient<T> serverBrowserClient;
    private final GameProtocol protocol;
    private final IServerBrowserMiscProvider miscProvider;
    private final DisposableWrapper _shutdownCallback = new DisposableWrapper();
    private final MyBoolObservable canRefresh = new MyBoolObservable(false);
    private final MyBoolObservable canFullRefresh = new MyBoolObservable(false);
    private final MyBoolObservable canAbortRefresh = new MyBoolObservable(false);
    private final MyBoolObservable canJoin = new MyBoolObservable(false);
    private final MyBoolObservable isLoading = new MyBoolObservable(false);
    private final MyBoolObservable canAddFavorite = new MyBoolObservable(false);
    private final MyBoolObservable canRemoveFavorite = new MyBoolObservable(false);
    private final LocalizedString status;
    private final LocalizedString modeName;
    private ServerEntry<?> selectedServer;
    public final Command Refresh;
    public final Command FullRefresh;
    public final Command AbortRefresh;
    public final Command Join;
    public final Command AddFavorite;
    public final Command RemoveFavorite;
    public final BoolObservable IsLoading;
    public final Observable<String> Status;
    public final Observable<String> ModeName;

    public ServerBrowserManager(IServerBrowserMiscProvider game, Supplier<T> serverInfoCreator, IServerListView<T> serverListView) {
        this.Refresh = new Command(this.canRefresh.Getter, this::refresh);
        this.FullRefresh = new Command(this.canFullRefresh.Getter, this::fullRefresh);
        this.AbortRefresh = new Command(this.canAbortRefresh.Getter, this::abortRefresh);
        this.Join = new Command(this.canJoin.Getter, this::connect);
        this.IsLoading = this.isLoading.Getter;
        this.protocol = game.getProtocol();
        this.miscProvider = game;
        this.AddFavorite = new Command(this.canAddFavorite.Getter, serverListView::addFav);
        this.RemoveFavorite = new Command(this.canRemoveFavorite.Getter, serverListView::removeFav);
        this.modeName = new LocalizedString((ILocalizer)this.miscProvider.getLocalizer(), "", new Object[0]);
        this.ModeName = this.modeName.Text;
        this.status = new LocalizedString(this.miscProvider.getLocalizer());
        this.Status = this.status.Text;
        this.serverBrowserClient = ServerBrowserClient.create(game, this::isCompatible, serverInfoCreator);
        this.serverListView = serverListView;
        serverListView.initialize(new ServerListViewSurrogate(){

            @Override
            public void setSelectedServer(ServerEntry<?> entry) {
                ServerBrowserManager.this.selectedServer = entry;
                ServerBrowserManager.this.checkStuff();
            }

            @Override
            public void refreshFavorites() {
                if (this.isFavoriteMode()) {
                    ServerBrowserManager.this.setFavoritesMode();
                    ServerBrowserManager.this.FullRefresh.tryPerform();
                }
            }

            @Override
            public boolean isFavoriteMode() {
                return ServerBrowserManager.this.isInFavoriteMode();
            }
        }, this.serverBrowserClient.getServerList(), this.miscProvider);
        this.serverBrowserClient.StateChanged.register(this::updateState);
        this.updateState();
        game.registerOnShutdown(this::stop);
    }

    protected boolean isCompatible(T serverInfo) {
        return this.miscProvider.isCompatible(((BaseServerInfo)serverInfo).VersionRaw);
    }

    private boolean isInFavoriteMode() {
        return this.serverBrowserClient.getModeName().equals("Favorites");
    }

    private void checkStuff() {
        this.canAddFavorite.set(this.isInFavoriteMode() || this.selectedServer != null);
        this.canRemoveFavorite.set(this.isInFavoriteMode() && this.selectedServer != null);
        this.canJoin.set(this.selectedServer != null);
    }

    private void updateState() {
        ServerBrowserClientModel model = this.serverBrowserClient.getModel();
        this.modeName.setText("_UI_ServerBrowser_Mode_" + this.serverBrowserClient.getModeName());
        this.canRefresh.set(model.canRefresh());
        this.canFullRefresh.set(model.canFullRefresh());
        this.canAbortRefresh.set(model.canAbortRefresh());
        this.isLoading.set(model.isLoading());
        TextWithArguments statusText = model.getStatus();
        if (statusText == null) {
            this.status.set(" ", new Object[0]);
        } else {
            this.status.set("_UI_ServerBrowser_Status_" + statusText.Text, statusText.Args);
        }
        this.checkStuff();
    }

    public void refresh() {
        this.serverBrowserClient.refresh();
    }

    public void fullRefresh() {
        this.serverBrowserClient.fullRefresh();
    }

    public void abortRefresh() {
        this.serverBrowserClient.abortRefresh();
    }

    public void setLANMode() {
        this.serverBrowserClient.setLANMode(this.protocol.getLANMulticastAddresses(), this.miscProvider.getPreferredIpVersion(), this.protocol.getLANPorts());
        this.fullRefresh();
    }

    public void setInternetMode() {
        this.serverBrowserClient.setInternetMode(this.protocol.getDefaultPort(), this.protocol.getMasterServerURL(), this.miscProvider.isDevmode());
        this.fullRefresh();
    }

    public void setFavoritesMode() {
        this.serverBrowserClient.setFavouritesMode(this.protocol.getDefaultPort(), this.miscProvider.getFavoritesServers());
        this.fullRefresh();
    }

    public void stop() {
        this.serverBrowserClient.stop();
        this.serverListView.closeDialog();
    }

    public void connect() {
        this.serverListView.doConnect();
    }
}

