/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.ioengine.serverbrowser.client.ui;

import com.iosoft.ioengine.serverbrowser.BaseServerInfo;
import com.iosoft.ioengine.serverbrowser.client.ServerEntry;
import com.iosoft.ioengine.serverbrowser.client.ui.HeadingModel;
import com.iosoft.ioengine.serverbrowser.client.ui.IComponent;
import java.util.Comparator;
import java.util.function.Consumer;

public class Column<C extends IComponent, T extends BaseServerInfo>
implements Comparable<Column<C, T>> {
    private float minimumSize;
    private float fractionSize;
    private final Consumer<ServerEntry<T>> valueSetter;
    private final int addIndex;
    private int orderingIndex;
    public final HeadingModel<C> HeadingModel;
    public final Comparator<ServerEntry<T>> Sorter;
    public final C Component;
    public final boolean DefaultSortDescending;

    public Column(HeadingModel<C> headingModel, float minimumSize, float fractionSize, Comparator<ServerEntry<T>> sorter, C component, Consumer<ServerEntry<T>> valueSetter, int addIndex, boolean defaultSortDescending) {
        this.setMinimumSize(minimumSize);
        this.setFractionSize(fractionSize);
        this.valueSetter = valueSetter;
        this.addIndex = addIndex;
        this.HeadingModel = headingModel;
        this.Sorter = sorter;
        this.Component = component;
        this.DefaultSortDescending = defaultSortDescending;
    }

    public void setMinimumSize(float minimumSize) {
        this.minimumSize = minimumSize;
    }

    public void setFractionSize(float fractionSize) {
        this.fractionSize = fractionSize;
    }

    public int getOrderingIndex() {
        return this.orderingIndex;
    }

    public void setOrderingIndex(int index) {
        this.orderingIndex = index;
    }

    public float getMinimumSize() {
        return this.minimumSize;
    }

    public float getFractionSize() {
        return this.fractionSize;
    }

    public void fireValueSetter(ServerEntry<T> info) {
        if (this.valueSetter != null) {
            this.valueSetter.accept(info);
        }
    }

    public void setSize(int posX, int width, int heightHeader, int heightComponent) {
        C heading = this.HeadingModel.getComponent();
        heading.setBounds(posX, heading.getY(), width, heightHeader);
        if (this.Component != null) {
            this.Component.setBounds(posX, this.Component.getY(), width, heightComponent);
        }
    }

    @Override
    public int compareTo(Column<C, T> o) {
        return o.orderingIndex == this.orderingIndex ? this.addIndex - o.addIndex : this.orderingIndex - o.orderingIndex;
    }
}

