/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.ioengine.serverbrowser.client.servermanagers.knownservers;

import com.iosoft.helpers.Misc;
import com.iosoft.helpers.localizer.TextWithArguments;
import com.iosoft.ioengine.serverbrowser.BaseServerInfo;
import com.iosoft.ioengine.serverbrowser.client.ServerBrowserClient;
import com.iosoft.ioengine.serverbrowser.client.ServerDataDto;
import com.iosoft.ioengine.serverbrowser.client.ServerEntry;
import com.iosoft.ioengine.serverbrowser.client.servermanagers.AbstractServerManager;
import com.iosoft.ioengine.serverbrowser.client.servermanagers.ServiceStartResult;
import com.iosoft.ioengine.serverbrowser.client.servermanagers.knownservers.AddressResolver;
import com.iosoft.ioengine.serverbrowser.client.servermanagers.knownservers.KnownServer;
import com.iosoft.ioengine.serverbrowser.client.servermanagers.knownservers.ResolvedServer;
import java.net.DatagramSocket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class KnownServerManager<T extends BaseServerInfo>
extends AbstractServerManager<T> {
    private final int maxAttempts;
    private final char defaultPort;
    private LinkedList<KnownServer> pendingServers = new LinkedList();
    private Map<SocketAddress, KnownServer> serverLookup = new HashMap<SocketAddress, KnownServer>();
    private Map<ServerDataDto, ServerEntry<T>> unresolvedServers = new HashMap<ServerDataDto, ServerEntry<T>>();
    private AddressResolver addressResolver;
    private Set<SocketAddress> knownPeers;
    private int numParsed;
    private int _numToParse;

    public KnownServerManager(int maxAttempts, char defaultPort) {
        this.maxAttempts = maxAttempts;
        this.defaultPort = defaultPort;
    }

    @Override
    protected ServiceStartResult openSocket() {
        try {
            DatagramSocket socket = new DatagramSocket();
            this.knownPeers = new HashSet<SocketAddress>();
            ServerBrowserClient.Log.info("Refreshing on UDP port " + socket.getLocalPort());
            return new ServiceStartResult(socket, this.knownPeers);
        }
        catch (SocketException ex) {
            this.onError(ex.toString(), Misc.printExceptionShort(ex));
            return null;
        }
    }

    protected void addUnresolved(List<ServerDataDto> foundServers) {
        if (foundServers.isEmpty()) {
            return;
        }
        ArrayList<ServerDataDto> resolved = new ArrayList<ServerDataDto>();
        ArrayList<ServerDataDto> unresolved = new ArrayList<ServerDataDto>();
        for (ServerDataDto foundServer : foundServers) {
            ServerEntry server = this._serverBrowser.createServer(foundServer);
            if (foundServer.Address == null) {
                this.unresolvedServers.put(foundServer, server);
                unresolved.add(foundServer);
            } else {
                resolved.add(foundServer);
                server.onAddressResolved(foundServer.Address);
            }
            server.onRefreshStart();
            server.setReady();
        }
        if (!resolved.isEmpty()) {
            this.onResolved(resolved.stream().map(x -> new ResolvedServer((ServerDataDto)x, x.Address)).collect(Collectors.toList()));
        }
        if (!unresolved.isEmpty()) {
            this.queueUnresolved(unresolved);
        }
    }

    private void queueUnresolved(Collection<ServerDataDto> unresolved) {
        this._numToParse += unresolved.size();
        this.addressResolver.add(unresolved);
    }

    protected abstract boolean isDiscoveryDone();

    protected void unresolvedFinished() {
        this.addressResolver.signalEnd();
        this.updateStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onResolved(List<ResolvedServer> results) {
        ArrayList<SocketAddress> addresses = new ArrayList<SocketAddress>();
        this.numParsed += results.size();
        for (ResolvedServer result : results) {
            ServerEntry<T> server = this.unresolvedServers.remove(result.ServerData);
            if (server == null) {
                throw new RuntimeException("Server has disappeared?");
            }
            server.onAddressResolved(result.Address);
            if (result.Address == null) continue;
            this.addServer(server);
            addresses.add(result.Address);
        }
        Set<SocketAddress> set = this.knownPeers;
        synchronized (set) {
            this.knownPeers.addAll(addresses);
        }
        this.updateStatus();
        this.onTargetAvailable();
    }

    private void addServer(ServerEntry<T> serverEntry) {
        if (this.addressResolver == null) {
            throw new IllegalStateException("Added a server too late");
        }
        KnownServer server = new KnownServer(serverEntry);
        this.pendingServers.add(server);
        this.serverLookup.put(serverEntry.getUDPAddress(), server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void clearServers() {
        super.clearServers();
        Set<SocketAddress> set = this.knownPeers;
        synchronized (set) {
            this.knownPeers.clear();
        }
        this.serverLookup.clear();
    }

    @Override
    protected void startRefresh(boolean full) {
        this.pendingServers.clear();
        this.pendingServers.addAll(this.serverLookup.values());
        for (KnownServer server : this.pendingServers) {
            server.onRefresh();
        }
        this.onTargetAvailable();
        if (full || !this.unresolvedServers.isEmpty()) {
            this.numParsed = 0;
            this._numToParse = 0;
            this.addressResolver = new AddressResolver(this.defaultPort, this::onServerDiscoveryDone, this::onResolved);
            if (full) {
                this.addCachedServers();
            } else {
                this.queueUnresolved(this.unresolvedServers.keySet());
            }
            if (this.isDiscoveryDone()) {
                this.addressResolver.signalEnd();
            }
        } else {
            this.checkDone();
        }
        this.updateStatus();
    }

    protected void addCachedServers() {
    }

    @Override
    protected void abortRefreshImpl() {
        if (this.addressResolver != null) {
            this.addressResolver.stop();
            this.addressResolver = null;
        }
    }

    private void onServerDiscoveryDone() {
        if (this.addressResolver == null) {
            throw new IllegalStateException("Already done?");
        }
        this.addressResolver = null;
        this.updateStatus();
        this.checkDone();
    }

    private void checkDone() {
        if (this.addressResolver == null && this.pendingServers.isEmpty()) {
            this.onRefreshDone();
        }
    }

    @Override
    protected float getRefreshProgress() {
        int numServers = this._serverBrowser.getNumServers();
        if (numServers == 0) {
            return 0.0f;
        }
        return (float)(numServers - this.pendingServers.size()) / (float)numServers;
    }

    protected TextWithArguments getLoadingStatus() {
        float numToParse = this._numToParse;
        if (numToParse == 0.0f) {
            numToParse = 1.0f;
        }
        return new TextWithArguments("ParsingAddresses", Math.round(100.0f * (float)this.numParsed / numToParse));
    }

    @Override
    protected TextWithArguments getStatusText() {
        if (this.addressResolver != null) {
            return this.getLoadingStatus();
        }
        return super.getStatusText();
    }

    @Override
    public void onInfoReceived(SocketAddress address, T info) {
        KnownServer knownServer = this.serverLookup.get(address);
        if (knownServer != null) {
            boolean wasRemoved = this.pendingServers.remove(knownServer);
            boolean firstTime = knownServer.onReceived(address, info);
            if (wasRemoved || firstTime) {
                this.updateStatus();
                this.checkDone();
            }
        }
    }

    @Override
    protected AbstractServerManager.Target getNextTarget() {
        int serversAvailable = this.pendingServers.size();
        if (serversAvailable == 0) {
            return null;
        }
        KnownServer server = this.pendingServers.removeFirst();
        AbstractServerManager.Target target = new AbstractServerManager.Target(server.createNewPing(), server.getServer().getUDPAddress());
        if (server.getServer().getRetries() < this.maxAttempts) {
            this.pendingServers.addLast(server);
        } else {
            server.getServer().onNotReached();
            this.checkDone();
        }
        return target;
    }

    @Override
    public boolean canRefresh() {
        return super.canRefresh() && this._serverBrowser.getNumServers() > 0;
    }
}

