/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.ioengine.serverbrowser.client.servermanagers.knownservers;

import com.iosoft.ioengine.serverbrowser.BaseServerInfo;
import com.iosoft.ioengine.serverbrowser.client.ServerEntry;
import com.iosoft.ioengine.serverbrowser.client.servermanagers.PingInfos;
import java.net.SocketAddress;

class KnownServer {
    private ServerEntry<?> serverEntry;
    private PingInfos pingInfos;
    private boolean reached;

    KnownServer(ServerEntry<?> serverEntry) {
        this.serverEntry = serverEntry;
        this.onRefresh();
    }

    public void onRefresh() {
        this.pingInfos = new PingInfos();
        this.reached = false;
    }

    public ServerEntry<?> getServer() {
        return this.serverEntry;
    }

    public int createNewPing() {
        this.serverEntry.onSendAttempt();
        return this.pingInfos.startPing();
    }

    public <T extends BaseServerInfo> boolean onReceived(SocketAddress address, T info) {
        boolean firstTime;
        Integer nextPing = info.Completeness.HasBasicInfo ? this.pingInfos.calculatePing(info.RequestID) : null;
        Integer oldPing = this.serverEntry.getPing();
        boolean bl = firstTime = !this.reached;
        if (nextPing == null) {
            nextPing = oldPing;
        }
        if (!this.reached) {
            this.reached = true;
        } else if (oldPing != null && oldPing < nextPing) {
            nextPing = oldPing;
        }
        this.serverEntry.onResponse(address, info, nextPing);
        return firstTime;
    }
}

