/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.ioengine.serverbrowser.client.servermanagers.knownservers;

import com.iosoft.helpers.Misc;
import com.iosoft.helpers.async.AsyncWorkerWithInterimResults;
import com.iosoft.ioengine.serverbrowser.client.ServerBrowserClient;
import com.iosoft.ioengine.serverbrowser.client.ServerDataDto;
import com.iosoft.ioengine.serverbrowser.client.servermanagers.knownservers.ResolvedServer;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Consumer;

class AddressResolver {
    private static final ServerDataDto POISON = new ServerDataDto(null, null);
    private char defaultPort;
    private Runnable onDone;
    private Consumer<List<ResolvedServer>> resolvedConsumer;
    private Worker worker;
    private boolean ending;
    private boolean stopped;

    AddressResolver(char defaultPort, Runnable onDone, Consumer<List<ResolvedServer>> resolvedConsumer) {
        this.defaultPort = defaultPort;
        this.onDone = Misc.notNull(onDone);
        this.resolvedConsumer = Misc.notNull(resolvedConsumer);
    }

    void add(Collection<ServerDataDto> dtos) {
        if (dtos.stream().anyMatch(Objects::isNull)) {
            throw new IllegalArgumentException("May not contain null");
        }
        this.checkStopped();
        this.checkEnded();
        if (this.worker == null) {
            this.worker = new Worker(dtos);
            this.worker.execute();
        } else {
            this.worker.addServers(dtos);
        }
    }

    void signalEnd() {
        this.checkStopped();
        this.checkEnded();
        this.ending = true;
        if (this.worker != null) {
            this.worker.signalEnd();
        } else {
            this.onDone.run();
        }
    }

    void stop() {
        this.checkStopped();
        this.stopped = true;
        if (this.worker != null) {
            this.worker.abort();
            this.worker = null;
        }
    }

    private void checkStopped() {
        if (this.stopped) {
            throw new IllegalStateException("Already stopped");
        }
    }

    private void checkEnded() {
        if (this.ending) {
            throw new IllegalStateException("Already ending");
        }
    }

    private class Worker
    extends AsyncWorkerWithInterimResults<Void, ResolvedServer> {
        private final BlockingQueue<ServerDataDto> pending;
        private boolean alreadyEnded;

        Worker(Collection<ServerDataDto> startServers) {
            super("Address Resolver");
            this.pending = new LinkedBlockingQueue<ServerDataDto>();
            this.pending.addAll(startServers);
        }

        public void addServers(Collection<ServerDataDto> startServers) {
            this.pending.addAll(startServers);
        }

        public void signalEnd() {
            this.pending.add(POISON);
        }

        @Override
        protected Void doWork() {
            try {
                while (!Thread.interrupted()) {
                    ServerDataDto dto = this.pending.take();
                    if (dto != POISON) {
                        this.publish(new ResolvedServer(dto, this.tryResolveAddress(dto.IP, dto.Port)));
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return null;
        }

        private SocketAddress tryResolveAddress(String ip, Character port) {
            try {
                return new InetSocketAddress(InetAddress.getByName(ip), (int)(port == null ? AddressResolver.this.defaultPort : port.charValue()));
            }
            catch (UnknownHostException e) {
                ServerBrowserClient.Log.error("[ " + ip + " ]: " + e);
                return null;
            }
        }

        @Override
        protected void process(List<ResolvedServer> chunk) {
            AddressResolver.this.resolvedConsumer.accept(chunk);
        }

        @Override
        protected void onDone(Void result) {
            if (!this.alreadyEnded) {
                this.alreadyEnded = true;
                AddressResolver.this.stopped = true;
                AddressResolver.this.worker = null;
                AddressResolver.this.onDone.run();
            }
        }
    }
}

