/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.ioengine.serverbrowser.client.servermanagers.internet;

import com.iosoft.helpers.Misc;
import com.iosoft.helpers.async.Task;
import com.iosoft.helpers.async.VTask;
import com.iosoft.helpers.web.MiscWeb;
import com.iosoft.helpers.web.StringResponse;
import com.iosoft.ioengine.serverbrowser.client.ServerDataDto;
import java.util.ArrayList;
import java.util.List;

final class MasterServerDataGetter {
    private static final String FIRST_LINE_PREFIX = "OK ";

    private MasterServerDataGetter() {
    }

    static Result parseLines(StringResponse.StringContent content) {
        Result result = new Result();
        if (content == null) {
            result.Error = ErrorCode.Communication;
            return result;
        }
        ArrayList<String> lines = content.Lines;
        int iC = lines.size();
        if (iC == 0 || iC == 1 && ((String)lines.get(0)).isEmpty()) {
            result.Error = ErrorCode.Protocol;
            result.ProtocolErrorText = "Empty response";
            return result;
        }
        String firstLine = (String)lines.get(0);
        if (!firstLine.startsWith(FIRST_LINE_PREFIX) || firstLine.length() < FIRST_LINE_PREFIX.length() + 1) {
            String text = String.join((CharSequence)"\n", lines);
            result.Error = ErrorCode.Protocol;
            result.ProtocolErrorText = "Returned text is '" + (text.length() > 255 ? String.valueOf(text.substring(0, 255)) + "..." : text) + "'";
            return result;
        }
        int numServers = Misc.getAsInt(firstLine.substring(FIRST_LINE_PREFIX.length()), -1);
        result.Servers = new ArrayList<ServerDataDto>();
        for (String line : lines.subList(1, lines.size())) {
            String ip;
            Character port = null;
            int index = line.lastIndexOf(32);
            if (index == -1) {
                ip = line;
            } else {
                ip = line.substring(0, index);
                port = Misc.tryGetAsUShort(line.substring(index + 1));
            }
            result.Servers.add(new ServerDataDto(ip, port));
        }
        result.ProtocolWarning = numServers != result.Servers.size();
        return result;
    }

    static Task<Result> getDataAsync(String masterServerUrl, boolean fakeSleep) {
        return (fakeSleep ? VTask.delay(0.5) : VTask.COMPLETED_TASK).awaitAndContinueTask(() -> MiscWeb.getTextAsync(masterServerUrl, 10.0, 524288)).awaitAndTranslate(x -> MasterServerDataGetter.parseLines((StringResponse.StringContent)x.Content));
    }

    static enum ErrorCode {
        Communication,
        Protocol;

    }

    static class Result {
        public List<ServerDataDto> Servers;
        public ErrorCode Error;
        public String ProtocolErrorText;
        public boolean ProtocolWarning;

        Result() {
        }
    }
}

