/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.ioengine.serverbrowser.client.servermanagers.internet;

import com.iosoft.helpers.Misc;
import com.iosoft.helpers.async.Task;
import com.iosoft.helpers.localizer.TextWithArguments;
import com.iosoft.ioengine.serverbrowser.BaseServerInfo;
import com.iosoft.ioengine.serverbrowser.client.ServerBrowserClient;
import com.iosoft.ioengine.serverbrowser.client.servermanagers.internet.MasterServerDataGetter;
import com.iosoft.ioengine.serverbrowser.client.servermanagers.knownservers.KnownServerManager;
import java.util.function.Consumer;

public class InternetServerManager<T extends BaseServerInfo>
extends KnownServerManager<T> {
    private final boolean devmode;
    private String masterServerUrl;
    private Task<MasterServerDataGetter.Result> masterServerTask;
    private MasterServerDataGetter.Result masterServerResult;

    public InternetServerManager(String masterServerUrl, int maxAttempts, char defaultPort, boolean devmode) {
        super(maxAttempts, defaultPort);
        this.devmode = devmode;
        this.masterServerUrl = String.valueOf(Misc.notNull(masterServerUrl)) + "?job=list";
    }

    @Override
    public String getName() {
        return "Internet";
    }

    @Override
    protected void clearServers() {
        this.masterServerResult = null;
        super.clearServers();
    }

    @Override
    protected void startRefresh(boolean full) {
        if (full) {
            this.masterServerTask = MasterServerDataGetter.getDataAsync(this.masterServerUrl, !this.devmode);
            this.masterServerTask.await((MasterServerDataGetter.Result)((Object)((Consumer<MasterServerDataGetter.Result>)this::onMasterServerDone)));
        }
        super.startRefresh(full);
    }

    @Override
    protected void abortRefreshImpl() {
        if (this.masterServerTask != null) {
            this.masterServerTask.cancel();
            this.masterServerTask = null;
        }
        super.abortRefreshImpl();
    }

    @Override
    protected TextWithArguments getLoadingStatus() {
        if (this.masterServerTask != null) {
            return new TextWithArguments("Master_Contacting", new Object[0]);
        }
        return super.getLoadingStatus();
    }

    @Override
    protected TextWithArguments getStatusText() {
        if (this.masterServerResult != null && this.masterServerResult.Error != null) {
            return new TextWithArguments("Master_Error_" + (Object)((Object)this.masterServerResult.Error), this.masterServerResult.ProtocolErrorText);
        }
        return super.getStatusText();
    }

    private void onMasterServerDone(MasterServerDataGetter.Result result) {
        this.masterServerTask = null;
        this.masterServerResult = result;
        if (result.Error != null) {
            if (result.Error == MasterServerDataGetter.ErrorCode.Protocol) {
                ServerBrowserClient.Log.error("Master Server Protocol error: " + result.ProtocolErrorText);
            } else {
                ServerBrowserClient.Log.error("Master Server error: " + (Object)((Object)result.Error));
            }
        } else {
            this.addUnresolved(result.Servers);
            this.masterServerResult.Servers = null;
        }
        this.unresolvedFinished();
    }

    @Override
    protected boolean isDiscoveryDone() {
        return this.masterServerTask == null;
    }

    @Override
    public boolean isLoading() {
        if (this.masterServerTask != null) {
            return true;
        }
        return super.isLoading();
    }
}

