/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.ioengine.serverbrowser.client.servermanagers;

import com.iosoft.helpers.Misc;
import com.iosoft.helpers.network.MiscNet;
import com.iosoft.helpers.network.util.IpVersion;
import com.iosoft.ioengine.game.IpAddressPair;
import com.iosoft.ioengine.serverbrowser.BaseServerInfo;
import com.iosoft.ioengine.serverbrowser.client.ServerBrowserClient;
import com.iosoft.ioengine.serverbrowser.client.ServerDataDto;
import com.iosoft.ioengine.serverbrowser.client.ServerEntry;
import com.iosoft.ioengine.serverbrowser.client.servermanagers.AbstractServerManager;
import com.iosoft.ioengine.serverbrowser.client.servermanagers.PingInfos;
import com.iosoft.ioengine.serverbrowser.client.servermanagers.ServiceStartResult;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class LANServerManager<T extends BaseServerInfo>
extends AbstractServerManager<T> {
    private static final int NumRepeats = 3;
    private static final int MaxServers = 1000;
    public boolean EnableMulticast = true;
    public boolean EnableBroadcast = true;
    private final IpAddressPair _multicastAddresses;
    private final IpVersion _preferredIpVersion;
    private final char[] _ports;
    private PingInfos _pings;
    private Map<SocketAddress, ServerEntry<T>> _serverLookupUdp = new HashMap<SocketAddress, ServerEntry<T>>();
    private Map<Integer, ServerEntry<T>> _serverLookupId = new HashMap<Integer, ServerEntry<T>>();
    private int _nextTargetIndex;
    private final ArrayList<InetSocketAddress> _sendAddresses = new ArrayList();

    public LANServerManager(IpAddressPair multicastAddresses, IpVersion preferredIpVersion, char[] ports) {
        this._multicastAddresses = multicastAddresses;
        this._preferredIpVersion = preferredIpVersion;
        this._ports = ports;
    }

    @Override
    public String getName() {
        return "LAN";
    }

    @Override
    protected ServiceStartResult openSocket() {
        this._sendAddresses.clear();
        char[] cArray = this._ports;
        int n = this._ports.length;
        int n2 = 0;
        while (n2 < n) {
            char port = cArray[n2];
            if (this.EnableBroadcast) {
                this._sendAddresses.add(new InetSocketAddress(MiscNet.BroadcastSendAddress, (int)port));
            }
            if (this.EnableMulticast) {
                for (InetAddress address : this._multicastAddresses.list(this._preferredIpVersion)) {
                    this._sendAddresses.add(new InetSocketAddress(address, (int)port));
                }
            }
            ++n2;
        }
        this._sendAddresses.trimToSize();
        MulticastSocket multicastSocket = null;
        try {
            multicastSocket = new MulticastSocket();
            try {
                multicastSocket.setBroadcast(true);
            }
            catch (SocketException e) {
                ServerBrowserClient.Log.warning("LAN - Could not set to broadcast: " + e);
            }
            ServerBrowserClient.Log.info("LAN - Querying " + this._sendAddresses.size() + " addresses on UDP port " + multicastSocket.getLocalPort());
            return new ServiceStartResult(multicastSocket, null);
        }
        catch (IOException e) {
            this.onError("LAN error: " + e.toString(), Misc.printExceptionShort(e));
            Misc.forceClose(multicastSocket);
            return null;
        }
    }

    @Override
    public void onInfoReceived(SocketAddress address, T info) {
        boolean added;
        Integer ping = ((BaseServerInfo)info).Completeness.HasBasicInfo ? this._pings.calculatePing(((BaseServerInfo)info).RequestID) : null;
        ServerEntry<T> server = null;
        server = ((BaseServerInfo)info).ServerId != 0 ? this._serverLookupId.get(((BaseServerInfo)info).ServerId) : this._serverLookupUdp.get(address);
        boolean bl = added = server == null;
        if (!added && ping == null) {
            ping = server.getPing();
        }
        if (added) {
            if (this._serverLookupUdp.size() >= 1000 || this._serverLookupId.size() >= 1000) {
                return;
            }
            InetSocketAddress inetAddress = address instanceof InetSocketAddress ? (InetSocketAddress)address : null;
            server = this._serverBrowser.createServer(new ServerDataDto(inetAddress == null ? "?" : inetAddress.getAddress().getHostAddress(), Character.valueOf(inetAddress == null ? (char)'\u0000' : (char)inetAddress.getPort()), address));
            server.onAddressResolved(address);
            this._serverLookupUdp.put(address, server);
        }
        if (((BaseServerInfo)info).ServerId != 0) {
            this._serverLookupId.putIfAbsent(((BaseServerInfo)info).ServerId, server);
        }
        server.onResponse(address, info, ping);
        if (added) {
            server.setReady();
            this.updateStatus();
        }
    }

    @Override
    protected float getRefreshProgress() {
        int numSends = this.getNumSends();
        if (numSends == 0) {
            return 1.0f;
        }
        return (float)this._nextTargetIndex / (float)numSends;
    }

    private int getNumSends() {
        return 3 * this._sendAddresses.size();
    }

    @Override
    protected AbstractServerManager.Target getNextTarget() {
        int numEntries = this.getNumSends();
        if (this._nextTargetIndex >= numEntries) {
            if (this._nextTargetIndex == numEntries) {
                ++this._nextTargetIndex;
                this.onRefreshDone();
            }
            return null;
        }
        SocketAddress address = this._sendAddresses.get(this._nextTargetIndex % this._sendAddresses.size());
        ServerBrowserClient.Log.info("LAN - Sending to " + address);
        AbstractServerManager.Target target = new AbstractServerManager.Target(this._pings.startPing(), address);
        ++this._nextTargetIndex;
        this.updateStatus();
        return target;
    }

    @Override
    protected void clearServers() {
        super.clearServers();
        this._serverLookupUdp.clear();
        this._serverLookupId.clear();
    }

    @Override
    protected void startRefresh(boolean full) {
        this._pings = new PingInfos();
        this._nextTargetIndex = 0;
        this.onTargetAvailable();
        this.updateStatus();
    }

    @Override
    protected void abortRefreshImpl() {
    }
}

