/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.ioengine.serverbrowser.client.servermanagers;

import com.iosoft.helpers.Misc;
import com.iosoft.helpers.async.SubProcess;
import com.iosoft.ioengine.serverbrowser.BaseServerInfo;
import com.iosoft.ioengine.serverbrowser.client.ServerBrowserClient;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketAddress;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;

public class InfoReceiver<T extends BaseServerInfo>
extends SubProcess {
    public InfoReceiver(DatagramSocket socket, Set<SocketAddress> knownPeers, BiConsumer<SocketAddress, T> onInfoReceived, Function<SocketAddress, T> serverInfoCreator, Consumer<IOException> onSocketError) {
        Misc.notNull(socket, "socket");
        Misc.notNull(serverInfoCreator, "serverInfoCreator");
        Misc.notNull(onInfoReceived, "onInfoReceived");
        Misc.notNull(onSocketError, "onSocketError");
        this.start("ServerBrowserClient " + socket.getLocalSocketAddress() + " Receiver", () -> {
            DatagramPacket packet = new DatagramPacket(new byte[1024], 1024);
            while (!Thread.interrupted()) {
                try {
                    socket.receive(packet);
                }
                catch (IOException e) {
                    this.post(() -> {
                        this.onEnd();
                        onSocketError.accept(e);
                    });
                    return;
                }
                if (Thread.interrupted()) {
                    return;
                }
                SocketAddress address = packet.getSocketAddress();
                if (knownPeers != null) {
                    Set set2 = knownPeers;
                    synchronized (set2) {
                        if (!knownPeers.contains(address)) {
                            continue;
                        }
                    }
                }
                BaseServerInfo info = (BaseServerInfo)serverInfoCreator.apply(address);
                try {
                    Throwable throwable = null;
                    Object var10_13 = null;
                    try (DataInputStream dis = new DataInputStream(new ByteArrayInputStream(packet.getData(), packet.getOffset(), packet.getLength()));){
                        if (info.read(dis)) {
                            info.Completeness = BaseServerInfo.CompletenessQuality.Complete;
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException ex) {
                    ServerBrowserClient.Log.error("Invalid/incomplete metadata info from " + address + ": " + ex);
                }
                if (!info.Completeness.IsIntended) continue;
                this.post(() -> onInfoReceived.accept(address, info));
            }
        });
    }
}

