/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.ioengine.serverbrowser.client.servermanagers;

import com.iosoft.helpers.localizer.TextWithArguments;
import com.iosoft.ioengine.serverbrowser.BaseServerInfo;
import com.iosoft.ioengine.serverbrowser.client.ServerDataDto;
import com.iosoft.ioengine.serverbrowser.client.servermanagers.knownservers.KnownServerManager;
import java.util.ArrayList;
import java.util.List;

public class FavouritesServerManager<T extends BaseServerInfo>
extends KnownServerManager<T> {
    private boolean favouritesLoaded;
    private List<ServerDataDto> cachedFavourites = new ArrayList<ServerDataDto>();

    public FavouritesServerManager(int maxAttempts, char defaultPort) {
        super(maxAttempts, defaultPort);
    }

    @Override
    public String getName() {
        return "Favorites";
    }

    public void addFavourites(List<ServerDataDto> newFavs) {
        if (this.favouritesLoaded) {
            throw new IllegalStateException("Cannot add favourites after favourites have been loaded (" + newFavs + ")");
        }
        if (newFavs == null) {
            this.favouritesLoaded = true;
            if (this.canAbortRefresh()) {
                this.unresolvedFinished();
            }
            this.updateStatus();
            this._serverBrowser.onStateChanged();
        } else {
            this.cachedFavourites.addAll(newFavs);
            if (this.canAbortRefresh()) {
                this.addUnresolved(newFavs);
            }
        }
    }

    @Override
    protected TextWithArguments getLoadingStatus() {
        if (!this.favouritesLoaded) {
            return new TextWithArguments("Favs_Loading", new Object[0]);
        }
        return super.getLoadingStatus();
    }

    @Override
    protected void addCachedServers() {
        super.addCachedServers();
        this.addUnresolved(this.cachedFavourites);
    }

    @Override
    protected boolean isDiscoveryDone() {
        return this.favouritesLoaded;
    }

    @Override
    public boolean isLoading() {
        if (!this.favouritesLoaded) {
            return true;
        }
        return super.isLoading();
    }
}

