/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.ioengine.serverbrowser.client.servermanagers;

import com.iosoft.helpers.Misc;
import com.iosoft.helpers.async.Task;
import com.iosoft.helpers.async.TaskSource;
import com.iosoft.helpers.localizer.TextWithArguments;
import com.iosoft.ioengine.serverbrowser.BaseServerInfo;
import com.iosoft.ioengine.serverbrowser.client.IServerBrowserManagerView;
import com.iosoft.ioengine.serverbrowser.client.ServerBrowserClient;
import com.iosoft.ioengine.serverbrowser.client.ServerEntry;
import com.iosoft.ioengine.serverbrowser.client.servermanagers.InfoReceiver;
import com.iosoft.ioengine.serverbrowser.client.servermanagers.RequestSender;
import com.iosoft.ioengine.serverbrowser.client.servermanagers.SendTarget;
import com.iosoft.ioengine.serverbrowser.client.servermanagers.ServerManager;
import com.iosoft.ioengine.serverbrowser.client.servermanagers.ServiceStartResult;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.SocketAddress;

public abstract class AbstractServerManager<T extends BaseServerInfo>
implements ServerManager<T> {
    protected IServerBrowserManagerView<T> _serverBrowser;
    private boolean running;
    private InfoReceiver<T> infoReceiver;
    private RequestSender requestSender;
    private DatagramSocket _socket;
    private TaskSource<SendTarget> targetTaskSource;
    private boolean errorOccured;
    private boolean aborted;
    private boolean refreshing;
    private TextWithArguments cachedStatusText;

    @Override
    public void refresh(boolean full) {
        if (!this.running) {
            return;
        }
        if (full && !this.canFullRefresh() || !full && !this.canRefresh()) {
            throw new IllegalStateException("Cannot refresh");
        }
        this.aborted = false;
        this.refreshing = true;
        if (full) {
            this.clearServers();
        } else {
            for (ServerEntry<T> entry : this._serverBrowser.getServers()) {
                entry.onRefreshStart();
            }
        }
        this.startRefresh(full);
        this.updateStatus();
    }

    protected void clearServers() {
        this._serverBrowser.clearServers();
    }

    protected abstract void startRefresh(boolean var1);

    protected abstract ServiceStartResult openSocket();

    protected void closeSocket() {
        if (this._socket != null) {
            Misc.forceCloseAsync(this._socket, true);
            this._socket = null;
        }
    }

    @Override
    public void abortRefresh() {
        if (!this.canAbortRefresh()) {
            throw new IllegalStateException("Cannot abort refresh");
        }
        this.aborted = true;
        this.refreshing = false;
        for (ServerEntry<T> entry : this._serverBrowser.getServers()) {
            entry.onRefreshDone(true);
        }
        this.abortRefreshImpl();
        this.updateStatus();
    }

    protected abstract void abortRefreshImpl();

    @Override
    public void start(IServerBrowserManagerView<T> serverBrowser) {
        if (this.running) {
            throw new IllegalStateException("already started");
        }
        this.running = true;
        this._serverBrowser = serverBrowser;
        ServiceStartResult result = this.openSocket();
        if (result == null) {
            this.running = false;
        } else {
            this._socket = result.Socket;
            this.infoReceiver = new InfoReceiver<BaseServerInfo>(this._socket, result.KnownPeers, this::onInfoReceived, x -> serverBrowser.createServerInfo(), x -> {
                this.infoReceiver = null;
                this.onError((IOException)x);
            });
            this.requestSender = new RequestSender(this._socket, this::getTargetAsync, x -> {
                this.requestSender = null;
                if (x != null) {
                    this.onError((IOException)x);
                }
            });
        }
    }

    protected void onRefreshDone() {
        this.refreshing = false;
        for (ServerEntry<T> server : this._serverBrowser.getServers()) {
            server.onRefreshDone(false);
        }
        this.updateStatus();
    }

    @Override
    public void end() {
        if (!this.running) {
            return;
        }
        this.running = false;
        if (this.infoReceiver != null) {
            this.infoReceiver.end();
            this.infoReceiver = null;
        }
        if (this.requestSender != null) {
            this.requestSender.end();
            this.requestSender = null;
        }
        this.abortRefreshImpl();
        this.closeSocket();
        this.onTargetAvailable();
    }

    private void onError(IOException ex) {
        this.onError(ex.toString(), Misc.printException(ex));
    }

    protected void onError(String message, String longText) {
        this.cachedStatusText = new TextWithArguments("Error", message);
        this.errorOccured = true;
        ServerBrowserClient.Log.error(String.valueOf(message) + ": " + longText);
        this._serverBrowser.onStateChanged();
    }

    protected abstract float getRefreshProgress();

    @Override
    public final TextWithArguments getStatus() {
        return this.cachedStatusText;
    }

    protected TextWithArguments getStatusText() {
        if (this.refreshing) {
            return new TextWithArguments("Refreshing", Math.round(this.getRefreshProgress() * 100.0f));
        }
        if (this.aborted) {
            return new TextWithArguments("Aborted", new Object[0]);
        }
        int numServers = this._serverBrowser.getNumServers();
        if (numServers == 0) {
            return new TextWithArguments("NoServers", new Object[0]);
        }
        if (numServers == 1) {
            return new TextWithArguments("OneServer", new Object[0]);
        }
        return new TextWithArguments("NumServers", numServers);
    }

    protected final void updateStatus() {
        if (!this.errorOccured) {
            this.cachedStatusText = this.getStatusText();
            this._serverBrowser.onStateChanged();
        }
    }

    protected void onTargetAvailable() {
        SendTarget target;
        if (this.targetTaskSource != null && this.isValidTargetResponse(target = this.getNextSendTarget())) {
            this.targetTaskSource.setResult(target);
            this.targetTaskSource = null;
        }
    }

    private boolean isValidTargetResponse(SendTarget target) {
        return target != null || !this.running;
    }

    protected Task<SendTarget> getTargetAsync() {
        SendTarget target = this.getNextSendTarget();
        if (this.isValidTargetResponse(target)) {
            return new Task<SendTarget>(target);
        }
        if (this.targetTaskSource != null) {
            throw new IllegalStateException("Previous call not awaited");
        }
        this.targetTaskSource = new TaskSource(() -> {
            TaskSource<SendTarget> taskSource = this.targetTaskSource = null;
        });
        return (Task)this.targetTaskSource.getTask();
    }

    private SendTarget getNextSendTarget() {
        if (!this.refreshing || !this.running) {
            return null;
        }
        Target target = this.getNextTarget();
        if (target == null) {
            return null;
        }
        return new SendTarget(target.Address, this._serverBrowser.createRequestInfo(target.RequestID));
    }

    protected abstract Target getNextTarget();

    protected abstract void onInfoReceived(SocketAddress var1, T var2);

    @Override
    public boolean canAbortRefresh() {
        return !this.errorOccured && this.refreshing;
    }

    @Override
    public boolean canRefresh() {
        return !this.errorOccured && !this.refreshing;
    }

    @Override
    public boolean canFullRefresh() {
        return !this.errorOccured && !this.refreshing;
    }

    @Override
    public boolean isLoading() {
        return false;
    }

    protected static final class Target {
        public final int RequestID;
        public final SocketAddress Address;

        public Target(int requestID, SocketAddress address) {
            this.RequestID = requestID;
            this.Address = address;
        }
    }
}

