/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.ioengine.serverbrowser.client;

import com.iosoft.helpers.event.ArgEvent;
import com.iosoft.helpers.event.ArgEventSource;
import com.iosoft.ioengine.serverbrowser.BaseServerInfo;
import com.iosoft.ioengine.serverbrowser.client.ServerEntry;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;

public class ServerListModel<T extends BaseServerInfo>
extends AbstractListModel<ServerEntry<T>> {
    private static final long serialVersionUID = 1L;
    private List<ServerEntry<T>> entries = new ArrayList<ServerEntry<T>>();
    private final ArgEventSource<ServerEntry<T>> onInfoReceived = new ArgEventSource();
    public final ArgEvent<ServerEntry<T>> OnInfoReceived;

    public ServerListModel() {
        this.OnInfoReceived = (ArgEvent)this.onInfoReceived.Event;
    }

    int add(ServerEntry<T> entry) {
        this.entries.add(entry);
        int index = this.entries.size() - 1;
        this.onInfoReceived.fire(entry);
        this.fireIntervalAdded(this, index, index);
        return index;
    }

    void clear() {
        int size = this.entries.size();
        if (size > 0) {
            this.entries.clear();
            this.fireIntervalRemoved(this, 0, size - 1);
        }
    }

    void onChanged(int index, ServerEntry<T> who, boolean newInfo) {
        if (newInfo) {
            this.onInfoReceived.fire(who);
        }
        this.fireContentsChanged(this, index, index);
    }

    @Override
    public ServerEntry<T> getElementAt(int index) {
        return this.entries.get(index);
    }

    @Override
    public int getSize() {
        return this.entries.size();
    }

    public List<ServerEntry<T>> getList() {
        return this.entries;
    }
}

