/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.ioengine.serverbrowser.client;

import com.iosoft.ioengine.serverbrowser.BaseServerInfo;
import com.iosoft.ioengine.serverbrowser.client.ServerBrowserEntryView;
import com.iosoft.ioengine.serverbrowser.client.ServerDataDto;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class ServerEntry<T extends BaseServerInfo> {
    private final ServerDataDto serverData;
    private final ServerBrowserEntryView<T> serverBrowser;
    private final List<SocketAddress> _addresses = new ArrayList<SocketAddress>();
    private boolean refreshed;
    private boolean _hasAnswered;
    private boolean aborted;
    private boolean compatible = true;
    private boolean addressResolved;
    public boolean WasDiscoveredByBroadcast;
    private Integer ping;
    private int retries;
    private T info;
    private int myListIndex = -1;

    public ServerEntry(ServerBrowserEntryView<T> serverBrowser, ServerDataDto serverData, T startInfo, boolean byBroadcast) {
        this.serverData = serverData;
        this.info = startInfo;
        this.serverBrowser = serverBrowser;
        this.WasDiscoveredByBroadcast = byBroadcast;
    }

    public String getName() {
        if (!((BaseServerInfo)this.info).Name.isEmpty()) {
            return ((BaseServerInfo)this.info).Name;
        }
        if (!this._addresses.isEmpty()) {
            if (this._addresses.size() == 1) {
                return this._addresses.get(0).toString();
            }
            return this._addresses.stream().map(Object::toString).collect(Collectors.joining("\n"));
        }
        if (this.serverData != null && this.serverData.IP != null) {
            return String.valueOf(this.serverData.IP) + (this.serverData.Port == null ? "" : ":" + this.serverData.Port.charValue());
        }
        return "(null)";
    }

    public T getInfo() {
        return this.info;
    }

    public List<SocketAddress> getUdpAddresses() {
        return new ArrayList<SocketAddress>(this._addresses);
    }

    public SocketAddress getUDPAddress() {
        if (this._addresses.isEmpty()) {
            throw new IllegalStateException("ServerEntry has no UDP address (how??)");
        }
        return this._addresses.get(0);
    }

    public List<SocketAddress> getTcpAddresses() {
        if (!((BaseServerInfo)this.info).hasValidTcpPort()) {
            return this.getUdpAddresses();
        }
        return this._addresses.stream().map(x -> {
            if (x instanceof InetSocketAddress) {
                InetSocketAddress inetAddress = (InetSocketAddress)x;
                return new InetSocketAddress(inetAddress.getAddress(), ((BaseServerInfo)this.info).TcpPort);
            }
            return x;
        }).distinct().collect(Collectors.toList());
    }

    public ServerDataDto getServerData() {
        return this.serverData;
    }

    public boolean isCompatible() {
        return this.compatible;
    }

    public State getState() {
        if (this._hasAnswered) {
            return !this.compatible ? State.INCOMPATIBLE : (((BaseServerInfo)this.info).HasPassword ? State.PASSWORD_REQUIRED : State.OK);
        }
        if (this.refreshed) {
            return this.aborted ? State.UNKNOWN : State.ERROR;
        }
        return State.REFRESHING;
    }

    public boolean isRefreshed() {
        return this.refreshed;
    }

    public boolean hasAnswered() {
        return this._hasAnswered;
    }

    public Integer getPing() {
        return this.ping;
    }

    public int getRetries() {
        return this.retries;
    }

    public boolean isAddressResolved() {
        return this.addressResolved;
    }

    public void onRefreshStart() {
        this.aborted = false;
        this._hasAnswered = false;
        this.refreshed = false;
        this.retries = 0;
        this.ping = null;
        if (this.addressResolved && this._addresses.isEmpty()) {
            this.onNotReached();
        } else {
            this.onChanged(false);
        }
    }

    public void onRefreshDone(boolean wasAborted) {
        if (!this.refreshed) {
            this.refreshed = true;
            this.aborted = wasAborted;
            if (!this._hasAnswered) {
                this.onNotReached();
            } else {
                this.onChanged(false);
            }
        }
    }

    public void onResponse(SocketAddress address, T newInfo, Integer newPing) {
        this.addUdpAddress(address);
        if (((BaseServerInfo)newInfo).Completeness.compareTo(((BaseServerInfo)this.info).Completeness) >= 0) {
            this.info = newInfo;
        }
        this.ping = newPing;
        this._hasAnswered = true;
        this.refreshed = true;
        this.compatible = ((BaseServerInfo)newInfo).Completeness.HasBasicInfo && this.serverBrowser.isCompatible(newInfo);
        this.onChanged(true);
    }

    public void onSendAttempt() {
        ++this.retries;
        this.onChanged(false);
    }

    public void onNotReached() {
        this.refreshed = true;
        this.onChanged(false);
    }

    public void onAddressResolved(SocketAddress address) {
        if (this.addressResolved) {
            throw new IllegalStateException("Address already resolved");
        }
        this.addressResolved = true;
        if (address == null) {
            this.onNotReached();
        } else {
            this.addUdpAddress(address);
            this.onChanged(false);
        }
    }

    private void addUdpAddress(SocketAddress address) {
        if (!this._addresses.contains(address)) {
            this._addresses.add(address);
        }
    }

    public void setReady() {
        if (this.myListIndex != -1) {
            throw new IllegalStateException("Already ready");
        }
        this.myListIndex = this.serverBrowser.add(this);
    }

    private void onChanged(boolean newInfo) {
        if (this.myListIndex != -1) {
            this.serverBrowser.onChanged(this.myListIndex, this, newInfo);
        }
    }

    public static enum State {
        ERROR(2),
        UNKNOWN(4),
        REFRESHING(3),
        INCOMPATIBLE(5),
        PASSWORD_REQUIRED(7),
        OK(6);

        public final int IconIndex;

        private State(int iconIndex) {
            this.IconIndex = iconIndex;
        }
    }
}

