/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.ioengine.serverbrowser.client;

import com.iosoft.helpers.Log;
import com.iosoft.helpers.Misc;
import com.iosoft.helpers.event.Event;
import com.iosoft.helpers.event.EventSource;
import com.iosoft.helpers.network.util.IpVersion;
import com.iosoft.ioengine.game.GameProtocol;
import com.iosoft.ioengine.game.IpAddressPair;
import com.iosoft.ioengine.serverbrowser.BaseRequestInfo;
import com.iosoft.ioengine.serverbrowser.BaseServerInfo;
import com.iosoft.ioengine.serverbrowser.client.EmptyServerManager;
import com.iosoft.ioengine.serverbrowser.client.IServerBrowserClientDataProvider;
import com.iosoft.ioengine.serverbrowser.client.IServerBrowserManagerView;
import com.iosoft.ioengine.serverbrowser.client.ServerBrowserClientModel;
import com.iosoft.ioengine.serverbrowser.client.ServerBrowserEntryView;
import com.iosoft.ioengine.serverbrowser.client.ServerDataDto;
import com.iosoft.ioengine.serverbrowser.client.ServerEntry;
import com.iosoft.ioengine.serverbrowser.client.ServerListModel;
import com.iosoft.ioengine.serverbrowser.client.servermanagers.FavouritesServerManager;
import com.iosoft.ioengine.serverbrowser.client.servermanagers.LANServerManager;
import com.iosoft.ioengine.serverbrowser.client.servermanagers.ServerManager;
import com.iosoft.ioengine.serverbrowser.client.servermanagers.internet.InternetServerManager;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class ServerBrowserClient<T extends BaseServerInfo> {
    public static final Log.Category Log = new Log.Category("ServerBrowserClient");
    private static final int MAX_CONTACT_ATTEMPTS = 3;
    private final String serverIdentify;
    private final String clientIdentify;
    private final String version;
    private final Supplier<T> serverInfoCreator;
    private final ServerBrowserEntryView<T> serverBrowserEntryView;
    private final ServerListModel<T> serverList = new ServerListModel();
    private final EventSource stateChangedSource = new EventSource();
    public final Event StateChanged;
    private MyServerBrowserManagerView serverBrowserManagerView;
    private ServerManager<T> serverManager;

    public static <T extends BaseServerInfo> ServerBrowserClient<T> create(IServerBrowserClientDataProvider game, Predicate<T> isCompatible, Supplier<T> serverInfoCreator) {
        GameProtocol protocol = game.getProtocol();
        return new ServerBrowserClient<T>(protocol.getSBServerIdentify(), protocol.getSBClientIdentify(), game.getVersion(), isCompatible, serverInfoCreator);
    }

    public ServerBrowserClient(String serverIdentify, String clientIdentify, String version, final Predicate<T> isCompatible, Supplier<T> serverInfoCreator) {
        this.StateChanged = (Event)this.stateChangedSource.Event;
        this.serverIdentify = Misc.notNull(serverIdentify);
        this.clientIdentify = Misc.notNull(clientIdentify);
        this.version = Misc.notNull(version);
        this.serverInfoCreator = Misc.notNull(serverInfoCreator);
        this.serverBrowserEntryView = new ServerBrowserEntryView<T>(){

            @Override
            public void onChanged(int index, ServerEntry<T> who, boolean newInfo) {
                ServerBrowserClient.this.serverList.onChanged(index, who, newInfo);
            }

            @Override
            public boolean isCompatible(T serverInfo) {
                return isCompatible.test(serverInfo);
            }

            @Override
            public int add(ServerEntry<T> who) {
                return ServerBrowserClient.this.serverList.add(who);
            }
        };
        this.setServerManager(null);
    }

    public void setLANMode(IpAddressPair multicastAddresses, IpVersion preferredIpVersion, char[] ports) {
        this.setServerManager(new LANServerManager(Misc.notNull(multicastAddresses), Misc.notNull(preferredIpVersion), Misc.notNull(ports)));
    }

    public void setInternetMode(char defaultPort, String masterServerUrl, boolean devmode) {
        this.setServerManager(new InternetServerManager(Misc.notNull(masterServerUrl), 3, defaultPort, devmode));
    }

    public void setFavouritesMode(char defaultPort, List<ServerDataDto> favs) {
        Consumer<List<ServerDataDto>> consumer = this.setFavouritesMode(defaultPort);
        consumer.accept(favs);
        consumer.accept(null);
    }

    public Consumer<List<ServerDataDto>> setFavouritesMode(char defaultPort) {
        FavouritesServerManager favouritesServerManager = new FavouritesServerManager(3, defaultPort);
        this.setServerManager(favouritesServerManager);
        this.serverManager = favouritesServerManager;
        return favouritesServerManager::addFavourites;
    }

    private void setServerManager(ServerManager<T> newServerManager) {
        if (this.serverManager instanceof EmptyServerManager && newServerManager == null) {
            return;
        }
        if (this.serverManager != null) {
            this.serverManager.end();
        }
        if (this.serverBrowserManagerView != null) {
            this.serverBrowserManagerView.disposed = true;
            this.serverList.clear();
        }
        if (newServerManager == null) {
            this.serverManager = new EmptyServerManager();
            this.serverBrowserManagerView = null;
        } else {
            this.serverManager = newServerManager;
            this.serverBrowserManagerView = new MyServerBrowserManagerView();
        }
        this.serverManager.start(this.serverBrowserManagerView);
        this.stateChangedSource.fire();
    }

    public void stop() {
        this.setServerManager(null);
    }

    public void refresh() {
        this.serverManager.refresh(false);
    }

    public void fullRefresh() {
        this.serverManager.refresh(true);
    }

    public void abortRefresh() {
        this.serverManager.abortRefresh();
    }

    public ServerBrowserClientModel getModel() {
        return this.serverManager;
    }

    public ServerListModel<T> getServerList() {
        return this.serverList;
    }

    public String getModeName() {
        return this.serverManager.getName();
    }

    private final class MyServerBrowserManagerView
    implements IServerBrowserManagerView<T> {
        private boolean disposed = false;
        private Iterable<ServerEntry<T>> serverListIterable = () -> new Iterator<ServerEntry<T>>(){
            Iterator<ServerEntry<T>> iterator;
            {
                this.iterator = ServerBrowserClient.this.serverList.getList().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public ServerEntry<T> next() {
                return this.iterator.next();
            }
        };

        private MyServerBrowserManagerView() {
        }

        @Override
        public void clearServers() {
            this.checkDisposed();
            ServerBrowserClient.this.serverList.clear();
        }

        @Override
        public T createServerInfo() {
            this.checkDisposed();
            BaseServerInfo info = (BaseServerInfo)ServerBrowserClient.this.serverInfoCreator.get();
            info.ServerIdentify = ServerBrowserClient.this.serverIdentify;
            return info;
        }

        @Override
        public BaseRequestInfo createRequestInfo(int requestID) {
            this.checkDisposed();
            BaseRequestInfo request = new BaseRequestInfo();
            request.ClientIdentify = ServerBrowserClient.this.clientIdentify;
            request.RequestID = requestID;
            request.Version = ServerBrowserClient.this.version;
            return request;
        }

        @Override
        public ServerEntry<T> createServer(ServerDataDto serverData) {
            this.checkDisposed();
            return new ServerEntry(ServerBrowserClient.this.serverBrowserEntryView, serverData, this.createServerInfo(), ServerBrowserClient.this.serverManager instanceof LANServerManager);
        }

        @Override
        public void onStateChanged() {
            this.checkDisposed();
            ServerBrowserClient.this.stateChangedSource.fire();
        }

        @Override
        public Iterable<ServerEntry<T>> getServers() {
            this.checkDisposed();
            return this.serverListIterable;
        }

        @Override
        public int getNumServers() {
            this.checkDisposed();
            return ServerBrowserClient.this.serverList.getSize();
        }

        private void checkDisposed() {
            if (this.disposed) {
                throw new IllegalStateException("Not usable anymore");
            }
        }
    }
}

