/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.ioengine.serverbrowser;

import com.iosoft.helpers.Misc;
import com.iosoft.helpers.io.MiscIO;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class BaseServerInfo {
    public static final int PACKET_SIZE = 1024;
    public CompletenessQuality Completeness = CompletenessQuality.Noise;
    public String ServerIdentify;
    public int RequestID;
    public int Protocol = -1;
    public int ServerId;
    public String Name = "";
    public String VersionRaw = "";
    public String VersionSanitized = "";
    public int TcpPort = -1;
    public int NumHumanPlayers;
    public int MaxHumanPlayers;
    public int NumBots;
    public boolean InProgress;
    public boolean Open;
    public boolean HasPassword;

    public boolean read(DataInputStream in) throws IOException {
        String identify = MiscIO.readCString(in, this.ServerIdentify.length());
        if (!this.ServerIdentify.equals(identify)) {
            return false;
        }
        this.Completeness = CompletenessQuality.Intended;
        this.Protocol = in.readUnsignedShort();
        this.VersionRaw = MiscIO.readUTFString(in);
        this.VersionSanitized = Misc.sanitizeVersion(this.VersionRaw);
        this.RequestID = in.readInt();
        this.TcpPort = in.readUnsignedShort();
        this.ServerId = in.readInt();
        this.Completeness = CompletenessQuality.BasicInfo;
        this.Name = Misc.sanitizeName(MiscIO.readUTFString(in));
        this.NumHumanPlayers = in.readUnsignedByte();
        this.MaxHumanPlayers = in.readUnsignedByte();
        this.NumBots = in.readUnsignedByte();
        int flags = in.readUnsignedByte();
        this.InProgress = Misc.getBit(flags, 0);
        this.Open = Misc.getBit(flags, 1);
        this.HasPassword = Misc.getBit(flags, 2);
        return true;
    }

    public void write1(DataOutputStream out) throws IOException {
        MiscIO.writeCString(out, this.ServerIdentify);
        out.writeShort(1);
        MiscIO.writeUTFString(out, this.VersionRaw);
    }

    public void write2(DataOutputStream out) throws IOException {
        out.writeInt(this.RequestID);
        out.writeShort(this.TcpPort);
        out.writeInt(this.ServerId);
        MiscIO.writeUTFString(out, this.Name);
        out.write(this.NumHumanPlayers);
        out.write(this.MaxHumanPlayers);
        out.write(this.NumBots);
        out.write(Misc.bit(0, this.InProgress) | Misc.bit(1, this.Open) | Misc.bit(2, this.HasPassword));
    }

    public boolean hasValidTcpPort() {
        return this.TcpPort > 0;
    }

    public static enum CompletenessQuality {
        Noise,
        Intended(false),
        BasicInfo(true),
        Complete(true);

        public final boolean IsIntended;
        public final boolean HasBasicInfo;

        private CompletenessQuality() {
            this.IsIntended = false;
            this.HasBasicInfo = false;
        }

        private CompletenessQuality(boolean hasBasicInfo) {
            this.IsIntended = true;
            this.HasBasicInfo = hasBasicInfo;
        }
    }
}

