/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.ioengine.game.ui;

import com.iosoft.helpers.Log;
import com.iosoft.helpers.Misc;
import com.iosoft.helpers.binding.Observable;
import com.iosoft.helpers.game.ITickable;
import com.iosoft.helpers.game.ITicking;
import com.iosoft.helpers.localizer.LocalizedString;
import com.iosoft.helpers.localizer.Localizer;
import com.iosoft.helpers.localizer.TextWithArguments;
import com.iosoft.ioengine.app.client.AppState;
import com.iosoft.ioengine.game.NetworkGame;
import com.iosoft.ioengine.game.client.ClientPlayerSlot;
import com.iosoft.ioengine.game.client.GameClientApp;
import com.iosoft.ioengine.game.client.GameState;
import com.iosoft.ioengine.game.client.LocalPlayer;
import java.util.ArrayList;
import java.util.List;

public abstract class GameUI<C extends GameClientApp<G, S, ? extends LocalPlayer<C, ? extends ClientPlayerSlot<S>>>, S extends GameState<C, ? extends ClientPlayerSlot<S>, ? extends GameUI<C, S, G>, G>, G extends NetworkGame<C, ?, ?, ?>>
implements ITicking {
    protected final List<ITickable> tickables = new ArrayList<ITickable>();
    protected C client;
    protected S gs;
    protected G game;
    protected Localizer localizer;
    private LocalizedString connectionStepTranslated;

    public Observable<String> connectionStepTranslated() {
        return this.connectionStepTranslated.Text;
    }

    public G getGame() {
        return this.game;
    }

    public S getGameState() {
        return this.gs;
    }

    public C getClient() {
        return this.client;
    }

    public Localizer getLocalizer() {
        return this.localizer;
    }

    public void onInit(S state) {
        this.gs = state;
        this.client = (GameClientApp)((AppState)this.gs).getClientApp();
        this.game = ((GameClientApp)this.client).getGame();
        this.localizer = ((NetworkGame)this.game).getLocalizer();
        this.connectionStepTranslated = new LocalizedString(this.localizer);
        ((GameState)this.gs).ConnectionStep.bind(x -> this.onConnectionStep((String)x));
        this.initialize();
    }

    protected abstract void initialize();

    public abstract void onImportantLoaded();

    public abstract void onLoaded();

    @Override
    public boolean addTickable(ITickable t) {
        if (!this.tickables.contains(t)) {
            this.tickables.add(t);
            return true;
        }
        return false;
    }

    public void listTickables() {
        int iC = this.tickables.size();
        Log.UI.info(iC + " tickables");
        int i = 0;
        while (i < iC) {
            Log.UI.info(" > " + Misc.getClassName(this.tickables.get(i)));
            ++i;
        }
    }

    public void setConnectTarget(String target) {
        this.setConnectTargetTranslated(target == null ? this.localizer.translate("_UI_Connect_LocalServer") : target);
    }

    protected abstract void setConnectTargetTranslated(String var1);

    public abstract void onConnecting();

    protected void onConnectionStep(String step) {
        if ("Starting".equals(step)) {
            this.connectionStepTranslated.setTexts("", "");
        } else {
            this.connectionStepTranslated.setTexts("_UI_Connect_" + step, null);
        }
    }

    public void onDisconnected(TextWithArguments reason) {
        this.onDisconnectedTranslated(reason, ((NetworkGame)this.game).translateDisconnectReason(reason));
    }

    public abstract void onDisconnectedTranslated(TextWithArguments var1, String var2);

    public void tick() {
        int iC = this.tickables.size();
        int i = 0;
        while (i < iC) {
            ITickable t = this.tickables.get(i);
            if (!t.tick()) {
                this.tickables.remove(i);
                --i;
                --iC;
            }
            ++i;
        }
    }

    public abstract void onUpdateFound(String var1, String var2);

    public abstract void onError(Throwable var1);

    public void addDediChat(String str) {
        throw new IllegalStateException("Non-headless dedi chat not implemented");
    }
}

