/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.ioengine.game.server;

import com.iosoft.ioengine.game.server.GameData;
import com.iosoft.ioengine.game.server.Player;
import java.io.DataOutputStream;
import java.io.IOException;

public class PlayerSlot {
    protected GameData _data;
    protected int _nr;
    protected Player _player;
    protected int _state;

    public void init(int nr, GameData data) {
        this._nr = nr;
        this._data = data;
    }

    public <T extends Player> T getPlayer() {
        return (T)this._player;
    }

    public void setPlayer(Player p) {
        this._player = p;
    }

    public void onConnected() {
        this._state = 2;
        this._data.onPlayerAdded(this);
        this._data.checkSlots();
    }

    public void onConnecting() {
        this._state = 1;
        this._data.onPlayerConnecting(this);
        this._data.checkSlots();
    }

    public void onRemoved(Object reason) {
        this.setPlayer(null);
        this._state = 0;
    }

    public int getNr() {
        return this._nr;
    }

    public void setNr(int nr) {
        this._nr = nr;
    }

    public int getState() {
        return this._state;
    }

    public boolean isPlaying() {
        return this._state == 2;
    }

    public boolean isOpen() {
        return this._state == 0;
    }

    public boolean isClosed() {
        return this._state == 3;
    }

    public boolean isConnecting() {
        return this._state == 1;
    }

    public boolean isOccupied() {
        return this._player != null;
    }

    public void writeStartInfo(DataOutputStream dos) throws IOException {
        dos.write(this._state);
        if (this._state == 2) {
            this._player.writeStartInfo(dos);
        }
    }
}

