/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.ioengine.game.server;

import com.iosoft.helpers.Misc;
import com.iosoft.helpers.game.Handleable;
import com.iosoft.helpers.localizer.TextWithArguments;
import com.iosoft.ioengine.AppProtocolException;
import com.iosoft.ioengine.base.NetworkActor;
import com.iosoft.ioengine.base.server.BaseClient;
import com.iosoft.ioengine.base.server.BaseServerApp;
import com.iosoft.ioengine.game.server.BaseAI;
import com.iosoft.ioengine.game.server.GameClient;
import com.iosoft.ioengine.game.server.GameData;
import com.iosoft.ioengine.game.server.GameServerApp;
import com.iosoft.ioengine.game.server.PlayerSlot;
import com.iosoft.iogame.Game;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class Player<D extends GameData<? extends Player<D, S, C, A>, S, C>, S extends GameServerApp<?, D, ? extends Player<D, S, C, A>, C>, C extends GameClient<S, D, ? extends Player<D, S, C, A>>, A extends BaseAI<? extends Player<D, S, C, A>, D>>
implements Handleable {
    protected int _localId;
    protected PlayerSlot _slot;
    protected String name;
    private D _data;
    protected S _server;
    protected C _client;
    protected A _ai;
    private boolean ready;
    private boolean wasConnected;
    private boolean exists = true;

    public void init(D data, S server, PlayerSlot slot, C client, int localId) {
        this._data = data;
        this._server = server;
        this._slot = slot;
        this._localId = localId;
        if (client != null) {
            this.setClient(client);
        }
        slot.setPlayer(this);
        this.wasConnected = false;
        this.name = "";
        this.init();
        if (this.getClient() == null) {
            this.onConnected();
        } else {
            slot.onConnecting();
        }
    }

    protected void init() {
        if (this._client == null) {
            this._ai = this.createAI();
        }
        this.ready = ((GameData)this._data).isSingleplayer() || this.isAI() || this.isAdmin();
        this.initPlayer();
        if (this._ai != null) {
            ((BaseAI)this._ai).init((Player)this);
        }
    }

    public void receiveChat(String message) {
        if ((message = Misc.sanitizeLine(Misc.limitLength(message, ((GameServerApp)this._server).getProtocol().getMaxChatLength()).trim(), false, 3, true)).length() > 0) {
            ((GameServerApp)this._server).onChatReceived((Player)this, message);
        }
    }

    public void sendChat(String message) {
        this.sendChat(null, message);
    }

    public void sendChat(Player sender, String message) {
        if (this._client != null) {
            ((NetworkActor)this._client).send(((GameServerApp)this._server).msgChat(sender == null ? 255 : sender.getNr(), message));
        }
        if (this._ai != null) {
            ((BaseAI)this._ai).onChatMessage((Player)sender, message);
        }
    }

    protected void onCommand(String cmd) throws AppProtocolException {
    }

    protected void initPlayer() {
    }

    protected abstract void setupPlayer();

    protected abstract void postSetupPlayer();

    protected void discardPlayer(TextWithArguments reason) {
        if (this._ai != null) {
            ((BaseAI)this._ai).onRemoved(reason);
        }
    }

    protected void tick() {
        if (this._ai != null) {
            ((BaseAI)this._ai).tick();
        }
    }

    protected abstract A createAI();

    public boolean isAI() {
        return this._ai != null;
    }

    public A getAI() {
        return this._ai;
    }

    public C getClient() {
        return this._client;
    }

    public S getServer() {
        return this._server;
    }

    protected void setClient(C client) {
        if (this._client != null) {
            throw new IllegalStateException("cannot setClient when client is already set");
        }
        this._client = client;
        ((GameClient)client).addPlayer((Player)this);
    }

    public int getLocalID() {
        return this._localId;
    }

    public void setName(String name) {
        if (!this.name.equals(name)) {
            this.name = name;
            if (this.isConnected()) {
                this.update(1);
            }
        }
    }

    public boolean isConnected() {
        return this._client == null ? true : ((NetworkActor)this._client).isFullyConnected();
    }

    public String getName() {
        return this.name;
    }

    public void setAdmin(boolean b) {
        if (this._client != null) {
            ((GameClient)this._client).setAdmin(b);
        }
    }

    public D getData() {
        return this._data;
    }

    protected int buildFlags() {
        int flags = Misc.setFlag(0, 1, this.isAdmin());
        flags = Misc.setFlag(flags, 2, this.isAI());
        flags = Misc.setFlag(flags, 4, this.isReady());
        flags = Misc.setFlag(flags, 8, this.isLagging());
        return flags;
    }

    public boolean isAdmin() {
        return this._client != null && ((GameClient)this._client).isAdmin() || this._ai != null && ((BaseAI)this._ai).isAdmin();
    }

    public PlayerSlot getSlot() {
        return this._slot;
    }

    public int getNr() {
        return this._slot.getNr();
    }

    public boolean isReady() {
        return this.ready;
    }

    public String getVersion() {
        return this._client == null ? this.getAIVersion() : ((GameClient)this._client).getVersion();
    }

    public void toggleReady() {
        this.setReady(!this.ready);
    }

    public void setReady(boolean ready) {
        if (!((GameData)this._data).isSingleplayer() && !this.isAI() && this.ready != ready) {
            this.ready = ready;
            if (this.getSlot().isPlaying()) {
                this.sendFlags();
            }
        }
    }

    public void kick(boolean banned) {
        if (this._client != null) {
            ((BaseClient)this._client).kick(banned);
        } else {
            this.remove(banned ? "Banned" : "Kicked");
        }
    }

    public void kick(String customText) {
        TextWithArguments reason = new TextWithArguments("Custom", customText);
        if (this._client != null) {
            ((NetworkActor)this._client).disconnect(reason);
        } else {
            this.remove(reason);
        }
    }

    protected void remove(String reason) {
        this.remove(new TextWithArguments(reason, new Object[0]));
    }

    protected void remove(TextWithArguments reason) {
        boolean wasConnected = this.isConnected();
        this.exists = false;
        this._slot.onRemoved(reason);
        if (!((BaseServerApp)this._server).isStopping()) {
            if (this.wasConnected()) {
                this.discardPlayer(reason);
                int iC = ((GameData)this._data).getMaxPlayers();
                int i = 0;
                while (i < iC) {
                    A ai;
                    Object p = ((GameData)this._data).tryGetPlayer(i);
                    if (p != null && p != this && (ai = ((Player)p).getAI()) != null) {
                        ((BaseAI)ai).onPlayerRemoved((Player)this);
                    }
                    ++i;
                }
            }
            if (!((BaseServerApp)this._server).isEmpty()) {
                if (!wasConnected && !((Game)((GameServerApp)this._server).Game).isDevmode() && ((BaseServerApp)this._server).isDedicated()) {
                    reason = new TextWithArguments("", new Object[0]);
                }
                ((BaseServerApp)this._server).sendToAll(((GameServerApp)this._server).msgRemovePlayer((Player)this, reason));
            }
            ((GameData)this._data).checkSlots();
        }
    }

    protected void onNewPing() {
        this.update(2);
    }

    public char getPing() {
        return this._client != null ? ((BaseClient)this._client).getPing() : (char)'\u0000';
    }

    protected String getAIVersion() {
        return ((GameServerApp)this._server).getServerVersion();
    }

    public void writeStartInfo(DataOutputStream dos) throws IOException {
        S server = this.getServer();
        ((GameServerApp)server).writePlayerUpdate(dos, (Player)this, 0, true);
        ((GameServerApp)server).writePlayerUpdate(dos, (Player)this, 1, true);
        ((GameServerApp)server).writePlayerUpdate(dos, (Player)this, 2, true);
    }

    public void onConnected() {
        this.wasConnected = true;
        this.setupPlayer();
        this._slot.onConnected();
        if (this._ai != null) {
            ((BaseAI)this._ai).onConnected();
            if (((GameData)this._data).isGameInProgress()) {
                ((BaseAI)this._ai).onGameStarted();
            }
        }
    }

    public void onPostConnected() {
        this.postSetupPlayer();
    }

    public boolean wasConnected() {
        return this.wasConnected;
    }

    public boolean isLagging() {
        return this._client != null && ((BaseClient)this._client).needsTime();
    }

    public void update(int ... params) {
        if (!((BaseServerApp)this._server).isEmpty()) {
            ((BaseServerApp)this._server).sendToAll(((GameServerApp)this._server).msgPlayerupdate((Player)this, false, params));
        }
    }

    public void sendFlags() {
        this.update(0);
    }

    @Override
    public boolean exists() {
        return this.exists;
    }

    @Override
    public int getSaveID() {
        return this.getNr();
    }

    @Override
    public void delete() {
        throw new UnsupportedOperationException("Cannot do this");
    }

    public String toString() {
        return String.valueOf(Misc.getClassName(this)) + " (\"" + this.getName() + "\" - s:" + this.getNr() + "|" + (this.isAI() ? "AI" : "l:" + this.getLocalID()) + ")";
    }
}

