/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.ioengine.game.server;

import com.iosoft.helpers.Log;
import com.iosoft.helpers.Misc;
import com.iosoft.helpers.MiscLINQ;
import com.iosoft.helpers.VWaiter;
import com.iosoft.helpers.WrapException;
import com.iosoft.helpers.async.VTask;
import com.iosoft.helpers.io.MiscIO;
import com.iosoft.helpers.localizer.TextWithArguments;
import com.iosoft.helpers.network.util.IpVersion;
import com.iosoft.ioengine.app.server.DedicatedInfo;
import com.iosoft.ioengine.app.server.ServerApp;
import com.iosoft.ioengine.game.GameProtocol;
import com.iosoft.ioengine.game.NetworkGame;
import com.iosoft.ioengine.game.server.BaseAI;
import com.iosoft.ioengine.game.server.GameClient;
import com.iosoft.ioengine.game.server.GameData;
import com.iosoft.ioengine.game.server.GameDedicatedInfo;
import com.iosoft.ioengine.game.server.Player;
import com.iosoft.ioengine.game.server.PlayerSlot;
import com.iosoft.ioengine.serverbrowser.BaseServerInfo;
import com.iosoft.ioengine.serverbrowser.server.ServerBrowserServer;
import com.iosoft.iogame.Game;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;

public abstract class GameServerApp<G extends NetworkGame<?, ? extends GameServerApp<G, D, P, C>, ?, ?>, D extends GameData<P, ? extends GameServerApp<G, D, P, C>, C>, P extends Player<D, ? extends GameServerApp<G, D, P, C>, C, ? extends BaseAI<P, D>>, C extends GameClient<? extends GameServerApp<G, D, P, C>, D, P>>
extends ServerApp<D, C> {
    public static final byte[] MSG_START_BLOCK = new byte[]{23};
    public static final byte[] MSG_END_BLOCK = new byte[]{24};
    protected static final byte[] MSG_PINGREQUEST = new byte[]{11};
    private final Map<Object, Integer> removeReasonProtocolMapping = new HashMap<Object, Integer>();
    public final G Game;
    private String[] startArgs;
    private final int _lanServerId;
    protected Character _specialInternetServerBrowserPort;
    protected boolean _announceLAN;
    protected boolean _announceInternet;
    private ServerBrowserServer _serverBrowser;
    private final ArrayList<VWaiter> _previousServerBrowserClosingBlockers = new ArrayList();
    private VTask _taskServerBrowserRestarter;
    protected boolean bufferBetweenTicks = true;
    protected byte[] _passwordBytes;

    public GameServerApp(G game) {
        this.Game = game;
        int lanServerId = 0;
        while (lanServerId == 0) {
            lanServerId = ThreadLocalRandom.current().nextInt();
        }
        this._lanServerId = lanServerId;
        this.fillRemoveReasonProtocolMapping(this.removeReasonProtocolMapping);
    }

    @Override
    protected void fillClientDisconnectByReasonMapping(Map<String, Integer> mapping) {
        super.fillClientDisconnectByReasonMapping(mapping);
        mapping.put("Custom", 40);
        mapping.put("TooManyLocalPlayers", 42);
        mapping.put("GameInProgress", 41);
    }

    protected void fillRemoveReasonProtocolMapping(Map<Object, Integer> mapping) {
        mapping.put("Kicked", 1);
        mapping.put("Banned", 2);
        mapping.put("Protocol", 3);
        mapping.put("Not_A_Peer", 10);
        mapping.put("Timeout", 4);
        mapping.put("Quit", 5);
        mapping.put("ConnectionLost", 6);
        mapping.put("Version", 7);
        mapping.put("Overflow", 9);
        mapping.put("Custom", 8);
    }

    public int tryGetRemoveReason(Object reasonID) {
        Integer reason = this.removeReasonProtocolMapping.get(reasonID);
        return reason == null ? 0 : reason;
    }

    protected BaseServerInfo createNewServerBrowserInfo() {
        BaseServerInfo info = this.createServerBrowserInfo();
        this.fillServerBrowserInfo(info);
        return info;
    }

    protected BaseServerInfo createServerBrowserInfo() {
        return new BaseServerInfo();
    }

    protected void fillServerBrowserInfo(BaseServerInfo info) {
        info.ServerIdentify = this.getProtocol().getSBServerIdentify();
        info.Name = this.getName();
        info.ServerId = this._lanServerId;
        info.VersionRaw = this.getServerVersion();
        info.TcpPort = this.getPort();
        info.NumBots = ((GameData)this.data).countAIs();
        info.NumHumanPlayers = ((GameData)this.data).countUsedSlots() - info.NumBots;
        info.MaxHumanPlayers = ((GameData)this.data).getMaxPlayers() - info.NumBots;
        info.InProgress = ((GameData)this.data).isGameInProgress();
        info.Open = ((GameData)this.data).isOpenGame();
        info.HasPassword = this.getPasswordBytes() != null;
    }

    @Override
    protected void onStopping() {
        super.onStopping();
        this.restartServerBrowser();
    }

    @Override
    protected void onNetworkStarted() {
        this.restartServerBrowser();
    }

    public void setAnnounce(boolean toLAN, boolean toInternet, Character internetPort) {
        this._announceLAN = toLAN;
        this._announceInternet = toInternet;
        this._specialInternetServerBrowserPort = internetPort;
        this.restartServerBrowser();
    }

    private void showNetworkFailMessage(String prefix, Exception reason) {
        this.broadcast(((NetworkGame)this.Game).getLocalizer().translate("_Chat_Server_" + prefix, reason));
    }

    protected void restartServerBrowser() {
        if (this._taskServerBrowserRestarter != null) {
            if (this._taskServerBrowserRestarter.isRunning()) {
                this._taskServerBrowserRestarter.cancel();
            }
            this._taskServerBrowserRestarter = null;
        }
        if (this._serverBrowser != null) {
            this._serverBrowser.dispose();
            this._serverBrowser = null;
        }
        if (this.isRunning() && this.networkStarted && (this._announceInternet || this._announceLAN)) {
            for (VWaiter waiter : this._previousServerBrowserClosingBlockers) {
                waiter.waitBlocking();
            }
            this._previousServerBrowserClosingBlockers.clear();
            GameProtocol protocol = this.getProtocol();
            this._serverBrowser = new ServerBrowserServer(protocol.getSBClientIdentify(), this::createNewServerBrowserInfo, this._previousServerBrowserClosingBlockers);
            char internetHeartbeatPort = this._specialInternetServerBrowserPort == null ? this.port : this._specialInternetServerBrowserPort.charValue();
            IpVersion preferredIpVersion = ((NetworkGame)this.Game).getPreferredIpVersion();
            if (this._announceInternet && this._serverBrowser.EnableInternet) {
                try {
                    this._serverBrowser.tryStartPlainUdp(internetHeartbeatPort, this._hostAddress != null ? this._hostAddress : preferredIpVersion.AnyAddress, error -> this.showNetworkFailMessage("NoInternet", (Exception)error));
                }
                catch (SocketException e) {
                    this.showNetworkFailMessage("NoInternet", e);
                    internetHeartbeatPort = this.port;
                }
                String masterServerURL = protocol.getMasterServerURL();
                if (masterServerURL != null) {
                    this._serverBrowser.startMasterServerHeartbeat(masterServerURL, internetHeartbeatPort);
                }
            }
            if (this._announceLAN) {
                this._serverBrowser.startLAN(protocol.getLANPorts(), protocol.getLANMulticastAddresses(), preferredIpVersion, this._hostAddress, error -> this.showNetworkFailMessage("NoLAN", (Exception)error));
            }
            this._taskServerBrowserRestarter = VTask.delay(86400.0);
            this._taskServerBrowserRestarter.await(this::restartServerBrowser);
        }
    }

    public void setStartArgs(String[] args) {
        this.startArgs = args;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.update(2);
    }

    @Override
    protected void onServerStarted() {
        if (this.startArgs != null) {
            String[] stringArray = this.startArgs;
            int n = this.startArgs.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                this.doCommand(arg);
                ++n2;
            }
            this.startArgs = null;
        }
        super.onServerStarted();
        ((GameData)this.data).checkingSlots = false;
        ((GameData)this.data).checkSlots();
    }

    protected void writeServerUpdate(DataOutputStream dos, int nr) throws IOException {
        switch (nr) {
            case 0: {
                dos.writeByte(((GameData)this.data).getMaxPlayers());
                break;
            }
            case 1: {
                MiscIO.writePacked(dos, this.buildServerFlags());
                break;
            }
            case 2: {
                dos.writeUTF(this.getName());
                break;
            }
            default: {
                throw new RuntimeException("Unknown server update part (" + nr + ")");
            }
        }
    }

    protected void writeStartUpdates(DataOutputStream dos, C c) throws IOException {
        this.writeServerUpdate(dos, 1);
        this.writeServerUpdate(dos, 0);
        this.writeServerUpdate(dos, 2);
    }

    public void update(int ... updateNrs) {
        if (!this.isEmpty()) {
            this.sendToAll(this.msgServerupdate(updateNrs));
        }
    }

    public void updateFlags() {
        this.update(1);
    }

    protected int buildServerFlags() {
        int flags = Misc.setFlag(0, 1, ((GameData)this.data).isOpenGame());
        flags = Misc.setFlag(flags, 2, ((GameData)this.data).isSingleplayer());
        return flags;
    }

    protected byte[] msgServerupdate(int ... updateNrs) {
        try {
            this.Net.write(19);
            int theByte = 0;
            int[] nArray = updateNrs;
            int n = updateNrs.length;
            int n2 = 0;
            while (n2 < n) {
                int nr = nArray[n2];
                theByte |= 1 << nr;
                ++n2;
            }
            MiscIO.writePacked(this.Net, theByte);
            int validation = -1;
            int i = 0;
            while (i < updateNrs.length) {
                int nr = updateNrs[i];
                if (nr <= validation) {
                    throw new IllegalArgumentException("Elements must be passed in numerical order (doubles forbidden)! (got " + updateNrs.length + ": " + Misc.join(", ", updateNrs) + ")");
                }
                validation = nr;
                this.writeServerUpdate(this.Net, updateNrs[i]);
                ++i;
            }
        }
        catch (IOException e) {
            throw new WrapException(e);
        }
        return this.Dh.finish();
    }

    protected byte[] msgPlayerupdate(P player, boolean full, int ... updateNrs) {
        try {
            this.Net.write(18);
            this.Net.write(((Player)player).getNr());
            int theByte = 0;
            int[] nArray = updateNrs;
            int n = updateNrs.length;
            int n2 = 0;
            while (n2 < n) {
                int nr = nArray[n2];
                theByte |= 1 << nr;
                ++n2;
            }
            MiscIO.writePacked(this.Net, theByte);
            int validation = -1;
            int i = 0;
            while (i < updateNrs.length) {
                int nr = updateNrs[i];
                if (nr <= validation) {
                    throw new IllegalArgumentException("Elements must be passed in numerical order (doubles forbidden)! (got " + updateNrs.length + ": " + Misc.join(",", updateNrs) + ")");
                }
                validation = nr;
                this.writePlayerUpdate(this.Net, player, updateNrs[i], full);
                ++i;
            }
        }
        catch (IOException e) {
            throw new WrapException(e);
        }
        return this.Dh.finish();
    }

    protected void writePlayerUpdate(DataOutputStream dos, P player, int nr, boolean full) throws IOException {
        switch (nr) {
            case 0: {
                MiscIO.writePacked(dos, ((Player)player).buildFlags());
                break;
            }
            case 1: {
                dos.writeUTF(((Player)player).getName());
                break;
            }
            case 2: {
                dos.writeChar(((Player)player).getPing());
                break;
            }
            default: {
                throw new RuntimeException("Unknown player update part (" + nr + ")");
            }
        }
    }

    public byte[] msgCommand(String cmd) {
        try {
            this.Net.write(20);
            this.Net.writeUTF(cmd);
        }
        catch (IOException e) {
            throw new WrapException(e);
        }
        return this.Dh.finish();
    }

    public byte[] msgNojoin(GameClient.LocalPlayerInfo info) {
        try {
            this.Net.write(21);
            this.Net.write(info.Id);
        }
        catch (IOException e) {
            throw new WrapException(e);
        }
        return this.Dh.finish();
    }

    public byte[] msgJoin(P player) {
        try {
            this.Net.write(22);
            ((GameClient)((Player)player).getClient()).writeStartPlayerInfo(this.Net, player);
        }
        catch (IOException e) {
            throw new WrapException(e);
        }
        return this.Dh.finish();
    }

    public byte[] msgAddPlayer(PlayerSlot s) {
        try {
            this.Net.write(15);
            this.Net.write(s.getNr());
            ((Player)s.getPlayer()).writeStartInfo(this.Net);
        }
        catch (IOException e) {
            throw new WrapException(e);
        }
        return this.Dh.finish();
    }

    public byte[] msgSwapSlot(int slot1, int slot2) {
        try {
            this.Net.write(17);
            this.Net.write(slot1);
            this.Net.write(slot2);
        }
        catch (IOException e) {
            throw new WrapException(e);
        }
        return this.Dh.finish();
    }

    public byte[] msgConnecting(PlayerSlot s) {
        try {
            this.Net.write(14);
            this.Net.write(s.getNr());
        }
        catch (IOException e) {
            throw new WrapException(e);
        }
        return this.Dh.finish();
    }

    public byte[] tryMsgDisconnect(TextWithArguments reason) {
        Integer reasonID = this.getProtocolDisconnectReason(reason.Text);
        if (reasonID == null) {
            return null;
        }
        return this.msgDisconnect(reasonID, reason);
    }

    private byte[] msgDisconnect(int reason, TextWithArguments arguments) {
        try {
            this.Net.write(12);
            this.Net.write(reason);
            this.writeDisconnectParams(this.Net, reason, arguments, false);
        }
        catch (IOException e) {
            throw new WrapException(e);
        }
        return this.Dh.finish();
    }

    protected void writeDisconnectParams(DataOutputStream out, int reason, TextWithArguments arguments, boolean removeReason) throws IOException {
        switch (arguments.Text) {
            case "Version": {
                out.writeUTF(removeReason ? (String)arguments.Args[0] : ((Game)this.Game).getVersion());
                break;
            }
            case "Custom": {
                out.writeUTF((String)arguments.Args[0]);
            }
        }
    }

    public byte[] msgRemovePlayer(P p, TextWithArguments reason) {
        try {
            this.Net.write(16);
            this.Net.write(((Player)p).getNr());
            int reasonID = this.tryGetRemoveReason(reason.Text);
            this.Net.write(reasonID);
            this.writeDisconnectParams(this.Net, reasonID, reason, true);
        }
        catch (IOException e) {
            throw new WrapException(e);
        }
        return this.Dh.finish();
    }

    public byte[] msgChat(int pl, String msg) {
        try {
            this.Net.write(13);
            this.Net.write(pl);
            this.Net.writeUTF(msg);
        }
        catch (IOException e) {
            throw new WrapException(e);
        }
        return this.Dh.finish();
    }

    public byte[] msgGreeting(C me) {
        try {
            this.Net.write(10);
            this.writeGreeting(this.Net, me);
        }
        catch (IOException e) {
            throw new WrapException(e);
        }
        return this.Dh.finish();
    }

    public int getMaxPlayersForClient(C client) {
        return 1;
    }

    @Override
    protected void onNetworkFailed() {
        GameClient client = (GameClient)this.tryGetLocalClient(true);
        if (client != null) {
            client.send(this.msgDisconnect(5, new TextWithArguments("", new Object[0])));
        }
    }

    public void sendCommand(String cmd) {
        this.sendToAll(this.msgCommand(cmd));
    }

    public void processCommand(String cmd) {
        if (this.running) {
            this.doCommand(cmd);
        }
    }

    protected void doCommand(String cmd) {
        if (!this.tryCommand(null, cmd)) {
            Log.Server.error("Command '" + cmd + "' not found");
        }
    }

    protected boolean tryCommand(C client, String cmd) {
        if (cmd.startsWith("maxplayers ")) {
            int num = Misc.getAsInt(cmd.substring("maxplayers ".length()));
            if (num != -1) {
                ((GameData)this.data).setMaxPlayers(num);
            }
            return true;
        }
        if (cmd.startsWith("opengame ")) {
            String num = cmd.substring("opengame ".length());
            boolean open = num.equals("1");
            if (open || num.equals("0")) {
                ((GameData)this.data).setOpenGame(open);
            }
            return true;
        }
        if (cmd.startsWith("servername ")) {
            String name = cmd.substring("servername ".length());
            this.setName(name);
            return true;
        }
        if (cmd.startsWith("password ")) {
            String name = cmd.substring("password ".length());
            this.setPassword(cmd);
            return true;
        }
        return false;
    }

    public String getServerVersion() {
        return ((Game)this.Game).getVersion();
    }

    @Override
    protected TextWithArguments canNotConnectBecause(Socket socket) {
        if (((GameData)this.data).isMidgameJoiningAllowed() && ((GameData)this.data).isGameInProgress() && !((GameData)this.data).isOpenGame() || !((GameData)this.data).isMidgameJoiningAllowed() && (((GameData)this.data).isGameInProgress() || !((GameData)this.data).isOpenGame())) {
            return new TextWithArguments("GameInProgress", new Object[0]);
        }
        if (((GameData)this.data).tryGetFreeSlot() == null) {
            return new TextWithArguments("Full", new Object[0]);
        }
        return null;
    }

    @Override
    protected byte[] tryGetNoConnectReasonMsg(TextWithArguments disconnect) {
        return this.tryMsgDisconnect(disconnect);
    }

    @Override
    protected void onSuccessfulConnect(C c) {
        PlayerSlot slot = ((GameData)this.data).tryGetFreeSlot();
        if (slot == null) {
            throw new IllegalStateException("No slot available. Did you forget to set maxplayers?");
        }
        ((GameData)this.data).addClientPlayer(slot, c, 0);
    }

    @Override
    protected void serverTick() {
        this.setBufferMessages(true);
        this.gameServerTick();
        this.flushMessages();
        this.setBufferMessages(this.bufferBetweenTicks);
    }

    protected void gameServerTick() {
        ((GameData)this.data).tick();
    }

    public void broadcast(String text) {
        if (this.isDedicated() && !((NetworkGame)this.Game).isHeadless()) {
            this.addDediChat(text);
        } else if (this.tryGetLocalClient(true) == null) {
            Log.Server.info("Broadcast: " + text);
        }
        this.broadcast(null, text);
    }

    public void broadcast(P sender, String text) {
        if (!this.isEmpty()) {
            this.sendToAll(this.msgChat(sender == null ? 255 : ((Player)sender).getNr(), text));
        }
        ((GameData)this.data).sendToBots(sender, text);
    }

    @Override
    protected void fillDediInfo(DedicatedInfo info) {
        super.fillDediInfo(info);
        GameDedicatedInfo ginfo = (GameDedicatedInfo)info;
        ginfo.time_sessionRunning = ((GameData)this.data).getSessionTime();
        ginfo.inProgress = ((GameData)this.data).isGameInProgress();
        ginfo.open = ((GameData)this.data).isOpenGame();
        ginfo.numAIs = ((GameData)this.data).countAIs();
    }

    @Override
    protected void insertClientSlotDediInfo(DedicatedInfo info, C client, DedicatedInfo.ClientSlot slot) {
        super.insertClientSlotDediInfo(info, client, slot);
        GameDedicatedInfo.GameClientSlot cs = (GameDedicatedInfo.GameClientSlot)slot;
        cs.version = Misc.sanitizeVersion(((GameClient)client).getVersion());
        cs.admin = ((GameClient)client).isAdmin();
    }

    @Override
    protected GameDedicatedInfo createDedicatedServerInfo() {
        return new GameDedicatedInfo();
    }

    public boolean isUIDedi() {
        return this.isDedicated() && !((NetworkGame)this.Game).isHeadless();
    }

    @Override
    protected boolean wholeEngineStopped() {
        return ((Game)this.Game).isStopped();
    }

    protected void onChatReceived(P player, String msg) {
        if (this.isDedicated()) {
            this.addDediChat(String.valueOf(player == null ? "(console)" : ((Player)player).getName()) + ": " + msg);
        }
        this.processChat(player, msg);
    }

    protected void processChat(P player, String msg) {
        this.broadcast(player, msg);
    }

    public void onDedicatedInput(String text) {
        this.onChatReceived(null, text);
    }

    @Override
    public GameProtocol getProtocol() {
        return ((NetworkGame)this.Game).getProtocol();
    }

    protected void writeGreeting(DataOutputStream dos, C client) throws IOException {
        dos.writeBytes(this.getProtocol().getServerGreeting());
        this.writeGreetingMisc(dos, client);
        ((GameData)this.data).writeStartInfo(dos, client);
    }

    protected void writeGreetingMisc(DataOutputStream dos, C client) throws IOException {
        dos.writeUTF(this.getServerVersion());
    }

    public void addDediChat(String msg) {
        ((NetworkGame)this.Game).addDediChat(msg);
    }

    @Override
    protected int getMaxClients() {
        return this.getProtocol().getMaxPlayers();
    }

    public C tryGetClientByName(C butNotThisOne, String name) {
        return (C)MiscLINQ.firstOrDefault(this._clients, x -> x.isFullyConnected() && x != butNotThisOne && x.getName().equals(name));
    }

    public void setPassword(String password) {
        this._passwordBytes = Misc.isNullOrEmpty(password) ? null : this.getProtocol().getPasswordBytes(password);
    }

    public byte[] getPasswordBytes() {
        return this._passwordBytes;
    }
}

