/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.ioengine.game.server;

import com.iosoft.helpers.Log;
import com.iosoft.helpers.Misc;
import com.iosoft.helpers.MiscLINQ;
import com.iosoft.helpers.Stopwatch;
import com.iosoft.ioengine.app.server.AppData;
import com.iosoft.ioengine.base.server.BaseClient;
import com.iosoft.ioengine.game.server.BaseAI;
import com.iosoft.ioengine.game.server.GameClient;
import com.iosoft.ioengine.game.server.GameServerApp;
import com.iosoft.ioengine.game.server.Player;
import com.iosoft.ioengine.game.server.PlayerSlot;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;

public abstract class GameData<P extends Player<? extends GameData<P, S, C>, S, C, ? extends BaseAI<P, ? extends GameData<P, S, C>>>, S extends GameServerApp<?, ? extends GameData<P, S, C>, P, C>, C extends GameClient<S, ? extends GameData<P, S, C>, P>>
extends AppData<S> {
    protected final List<String> aiNames = new ArrayList<String>();
    protected PlayerSlot[] slots;
    protected int maxPlayers;
    protected boolean changingMaxPlayers;
    protected boolean gameInProgress;
    protected boolean openGame;
    protected long sw_sessionStart;
    protected long time_sessionBaseTime;
    protected boolean checkingSlots = true;
    private static final String AI_PLACEHOLDER_NAME = "ai_name";

    @Override
    protected void initialize() {
        this.slots = new PlayerSlot[((GameServerApp)this.server).getProtocol().getMaxPlayers()];
        int i = 0;
        while (i < this.slots.length) {
            this.slots[i] = this.createSlot();
            this.slots[i].init(i, this);
            ++i;
        }
        this.gameInProgress = false;
        this.aiNames.clear();
        this.fillAINames(this.aiNames);
        this.checkSlots();
    }

    public String getRandomAIName() {
        return Misc.removeRandom(this.aiNames, AI_PLACEHOLDER_NAME);
    }

    public void addAIName(String name) {
        if (!name.equals(AI_PLACEHOLDER_NAME)) {
            this.aiNames.add(name);
        }
    }

    protected void writeStartInfo(DataOutputStream dos, C c) throws IOException {
        ((GameServerApp)this.server).writeStartUpdates(dos, c);
        int i = 0;
        while (i < this.slots.length) {
            this.slots[i].writeStartInfo(dos);
            ++i;
        }
        ((GameClient)c).writeStartInfo(dos);
    }

    protected void fillAINames(List<String> names) {
    }

    protected void tick() {
        int i = 0;
        while (i < this.slots.length) {
            P p = this.tryGetPlayer(i);
            if (p != null) {
                ((Player)p).tick();
            }
            ++i;
        }
    }

    public void checkSlots() {
        if (this.checkingSlots || this.changingMaxPlayers) {
            return;
        }
        this.checkingSlots = true;
        this.doSlotCheck();
        this.checkingSlots = false;
    }

    protected void doSlotCheck() {
    }

    protected PlayerSlot createSlot() {
        return new PlayerSlot();
    }

    public void onPlayerConnecting(PlayerSlot s) {
        if (!((GameServerApp)this.server).isEmpty()) {
            ((GameServerApp)this.server).sendToAll(((GameServerApp)this.server).msgConnecting(s));
        }
    }

    public void onPlayerAdded(PlayerSlot s) {
        if (!((GameServerApp)this.server).isEmpty()) {
            ((GameServerApp)this.server).sendToAll(((GameServerApp)this.server).msgAddPlayer(s));
        }
        if (this.isGameInProgress()) {
            Object pl = s.getPlayer();
            int i = 0;
            while (i < this.slots.length) {
                Object ai;
                P p = this.tryGetPlayer(i);
                if (p != null && p != pl && (ai = ((Player)p).getAI()) != null) {
                    ((BaseAI)ai).onPlayerAdded(pl);
                }
                ++i;
            }
        }
    }

    protected void onStartGame(boolean restartTime) {
        this.sw_sessionStart = Stopwatch.start();
        this.setGameInProgress(true, restartTime);
        int i = 0;
        while (i < this.slots.length) {
            Object ai;
            P p = this.tryGetPlayer(i);
            if (p != null && (ai = ((Player)p).getAI()) != null) {
                ((BaseAI)ai).onGameStarted();
            }
            ++i;
        }
    }

    protected void setGameInProgress(boolean inProgress, boolean restartTime) {
        if (inProgress != this.gameInProgress) {
            if (!inProgress) {
                this.time_sessionBaseTime = restartTime ? 0L : this.time_sessionBaseTime + Stopwatch.getNanos(this.sw_sessionStart);
            } else if (restartTime) {
                this.time_sessionBaseTime = 0L;
            }
            this.gameInProgress = inProgress;
        }
    }

    public abstract P createPlayer();

    public P addPlayer(PlayerSlot slot) {
        return this.addPlayer(slot, null);
    }

    public P addPlayer(PlayerSlot slot, C client) {
        return this.addClientPlayer(slot, client, 0);
    }

    public P addClientPlayer(PlayerSlot slot, C client, int localId) {
        P player = this.createPlayer();
        ((Player)player).init((GameData)this, (GameServerApp)((GameServerApp)this.server), slot, client, localId);
        return player;
    }

    public PlayerSlot tryGetSlot(int nr) {
        if (nr >= 0 && nr < this.slots.length) {
            return this.slots[nr];
        }
        return null;
    }

    public PlayerSlot[] getSlots() {
        return this.slots;
    }

    public PlayerSlot tryGetFreeSlot() {
        return this.tryGetFreeSlotImpl(null);
    }

    protected PlayerSlot getFreeSlot(PlayerSlot orThisSlot) {
        return this.tryGetFreeSlotImpl(orThisSlot);
    }

    protected PlayerSlot tryGetFreeSlotImpl(PlayerSlot orThisSlot) {
        int i = 0;
        while (i < this.maxPlayers) {
            if (this.slots[i].isOpen() || this.slots[i] == orThisSlot) {
                return this.slots[i];
            }
            ++i;
        }
        return null;
    }

    public int getMaxPlayers() {
        return this.maxPlayers;
    }

    protected void onSwapped(PlayerSlot player1, PlayerSlot player2) {
    }

    public void setMaxPlayers(int newMax) {
        PlayerSlot s;
        int i;
        this.changingMaxPlayers = true;
        if (this.maxPlayers > (newMax = Misc.clamp(newMax, 1, ((GameServerApp)this.server).getProtocol().getMaxPlayers()))) {
            i = newMax;
            while (i < this.slots.length) {
                int oldSlot;
                int newSlot;
                s = this.slots[i];
                if (!s.isOpen() && !s.isClosed() && (newSlot = this.getFreeSlot(s).getNr()) != (oldSlot = s.getNr())) {
                    Log.Server.info("Moved " + ((Player)s.getPlayer()).getName() + " from slot " + oldSlot + " to slot " + newSlot);
                    PlayerSlot sOld = this.slots[newSlot];
                    this.slots[newSlot] = s;
                    this.slots[oldSlot] = sOld;
                    sOld.setNr(oldSlot);
                    s.setNr(newSlot);
                    this.onSwapped(s, sOld);
                    if (!((GameServerApp)this.server).isEmpty()) {
                        ((GameServerApp)this.server).sendToAll(((GameServerApp)this.server).msgSwapSlot(oldSlot, newSlot));
                    }
                }
                ++i;
            }
        }
        i = newMax;
        while (i < this.slots.length) {
            s = this.slots[i];
            if (!s.isOpen()) {
                ((Player)s.getPlayer()).kick(false);
            }
            ++i;
        }
        this.maxPlayers = newMax;
        ((GameServerApp)this.server).update(0);
        this.checkSlots();
        this.changingMaxPlayers = false;
    }

    public boolean tryKick(int nr, boolean ban) {
        InetAddress addr;
        P p = this.tryGetPlayerSlotMayBeBad(nr);
        if (p == null) {
            return false;
        }
        Object client = ((Player)p).getClient();
        if (ban && client != null && (addr = ((BaseClient)client).tryGetIPAddr()) != null) {
            ((GameServerApp)this.server).addBan(addr);
        }
        ((Player)p).kick(ban);
        return true;
    }

    public boolean hasAdmin() {
        return Arrays.stream(this.slots).anyMatch(x -> {
            Object player = x.getPlayer();
            return player != null && ((Player)player).isAdmin();
        });
    }

    public Iterable<P> enumerateConnectedPlayers(Predicate<P> predicate) {
        return MiscLINQ.iter(this.streamConnectedPlayers(predicate));
    }

    public Iterable<P> enumerateConnectedPlayers() {
        return MiscLINQ.iter(this.streamConnectedPlayers());
    }

    public Stream<P> streamConnectedPlayers(Predicate<P> predicate) {
        return Arrays.stream(this.slots).map(x -> x.getPlayer()).filter(x -> x != null && x.isConnected() && predicate.test(x));
    }

    public Stream<P> streamConnectedPlayers() {
        return Arrays.stream(this.slots).map(x -> x.getPlayer()).filter(x -> x != null && x.isConnected());
    }

    public Stream<P> streamAllPlayers() {
        return Arrays.stream(this.slots).map(x -> x.getPlayer()).filter(x -> x != null);
    }

    public Stream<P> streamAllPlayers(Predicate<P> predicate) {
        return Arrays.stream(this.slots).map(x -> x.getPlayer()).filter(x -> x != null && predicate.test(x));
    }

    public Iterable<P> enumerateAllPlayers() {
        return MiscLINQ.iter(this.streamAllPlayers());
    }

    public Iterable<P> enumerateAllPlayers(Predicate<P> predicate) {
        return MiscLINQ.iter(this.streamAllPlayers(predicate));
    }

    public int countUsedSlots() {
        return (int)Arrays.stream(this.slots).filter(PlayerSlot::isOccupied).count();
    }

    public int countFreeSlots() {
        return (int)Arrays.stream(this.slots).filter(PlayerSlot::isOpen).count();
    }

    public int countConnectedPlayers() {
        return (int)Arrays.stream(this.slots).filter(PlayerSlot::isPlaying).count();
    }

    public int countAIs() {
        return (int)Arrays.stream(this.slots).filter(x -> {
            Object player = x.getPlayer();
            return player != null && ((Player)player).isAI();
        }).count();
    }

    public boolean isSingleplayer() {
        return !((GameServerApp)this.server).isNetwork();
    }

    public boolean isMidgameJoiningAllowed() {
        return true;
    }

    public boolean isOpenGame() {
        return this.openGame;
    }

    public void setOpenGame(boolean val) {
        this.openGame = val;
        ((GameServerApp)this.server).updateFlags();
    }

    public P getPlayerByName(String name, P notThisOne, boolean caseSensitive) {
        if (!caseSensitive) {
            name = Misc.toUpper(name);
        }
        PlayerSlot[] playerSlotArray = this.slots;
        int n = this.slots.length;
        int n2 = 0;
        while (n2 < n) {
            PlayerSlot slot = playerSlotArray[n2];
            Object p = slot.getPlayer();
            if (p != null && p != notThisOne && ((Player)p).isConnected() && (caseSensitive ? ((Player)p).getName() : Misc.toUpper(((Player)p).getName())).equals(name)) {
                return (P)p;
            }
            ++n2;
        }
        return null;
    }

    public String makeNameValid(String name, P notThis) {
        String tn;
        if ((name = Misc.sanitizeName(name)).isEmpty()) {
            name = "Player " + (((Player)notThis).getSlot().getNr() + 1);
        }
        if (this.getPlayerByName(name, notThis, false) == null) {
            return name;
        }
        int i = 0;
        int maxLength = ((GameServerApp)this.server).getProtocol().getMaxPlayerNameLength();
        while (this.getPlayerByName(tn = Misc.limitLength("(" + ++i + ")" + name, maxLength), notThis, false) != null) {
        }
        return tn;
    }

    public boolean isGameInProgress() {
        return this.gameInProgress;
    }

    public Duration getSessionTime() {
        return Duration.ofNanos(this.time_sessionBaseTime + (this.isGameInProgress() ? Stopwatch.getNanos(this.sw_sessionStart) : 0L));
    }

    protected boolean canAddAI() {
        return !this.isGameInProgress() || this.isMidgameJoiningAllowed();
    }

    public P tryAddAI() {
        PlayerSlot s;
        if (this.canAddAI() && (s = this.tryGetFreeSlot()) != null) {
            return this.addPlayer(s);
        }
        return null;
    }

    public P tryGetPlayerSlotMayBeBad(int slotNr) {
        return slotNr < 0 || slotNr >= this.slots.length ? null : (P)this.tryGetPlayer(slotNr);
    }

    public P tryGetPlayer(int slotNr) {
        return (P)this.slots[slotNr].getPlayer();
    }

    public P tryGetPlayer(PlayerSlot slot) {
        return (P)slot.getPlayer();
    }

    public P getPlayer(int slotNr) {
        P player = this.tryGetPlayer(slotNr);
        if (player == null) {
            throw new IllegalStateException("Player '" + slotNr + "' is null");
        }
        return player;
    }

    public void sendToBots(P sender, String sMsg) {
        int i = 0;
        while (i < this.slots.length) {
            Object ai;
            P p = this.tryGetPlayer(i);
            if (p != null && (ai = ((Player)p).getAI()) != null) {
                ((BaseAI)ai).onChatMessage(sender, sMsg);
            }
            ++i;
        }
    }
}

