/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.ioengine.game.server;

import com.iosoft.helpers.Log;
import com.iosoft.helpers.Misc;
import com.iosoft.helpers.UnexpectedIOException;
import com.iosoft.helpers.io.MiscIO;
import com.iosoft.helpers.localizer.TextWithArguments;
import com.iosoft.helpers.network.ReceiverHelper;
import com.iosoft.ioengine.AppProtocolException;
import com.iosoft.ioengine.app.server.Client;
import com.iosoft.ioengine.base.IMessage;
import com.iosoft.ioengine.game.GameProtocol;
import com.iosoft.ioengine.game.NetworkGame;
import com.iosoft.ioengine.game.server.BaseAI;
import com.iosoft.ioengine.game.server.GameData;
import com.iosoft.ioengine.game.server.GameServerApp;
import com.iosoft.ioengine.game.server.Player;
import com.iosoft.ioengine.game.server.PlayerSlot;
import com.iosoft.ioengine.game.shared.dtos.C_ChatMessage;
import com.iosoft.ioengine.game.shared.dtos.C_PasswordResponse;
import com.iosoft.ioengine.game.shared.dtos.C_PingResponse;
import com.iosoft.ioengine.game.shared.dtos.C_Quit;
import com.iosoft.ioengine.game.shared.dtos.S_PasswordRequest;
import com.iosoft.iogame.Game;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public abstract class GameClient<S extends GameServerApp<?, D, P, ? extends GameClient<S, D, P>>, D extends GameData<P, S, ? extends GameClient<S, D, P>>, P extends Player<D, S, ? extends GameClient<S, D, P>, ? extends BaseAI<P, D>>>
extends Client<S, D> {
    private static final float FLOOD_QUOTA_THRESHOLD = 10.0f;
    private static final float FLOOD_QUOTA_ADD_SPAM = 3.0f;
    private static final float FLOOD_QUOTA_ADD_CHAT = 5.0f;
    private static final float FLOOD_QUOTA_MAX = 30.0f;
    private static final float FLOOD_QUOTA_REMOVE_SECOND = 5.0f;
    private final Map<Integer, P> players = new HashMap<Integer, P>();
    private boolean admin;
    private boolean _isVerified;
    private String version;
    private float floodQuota;
    private byte[] _clientSalt;
    private byte[] _serverSalt;
    private GreetingInfo _greetingInfo;

    public GameClient(S server) {
        super(server);
    }

    public <P extends GameProtocol> P getProtocol() {
        return (P)((GameServerApp)this.Server).getProtocol();
    }

    public <G extends NetworkGame<?, S, ?, ?>> G getGame() {
        return ((GameServerApp)this.Server).Game;
    }

    @Override
    protected void init() {
        this.version = "?";
        if (this.isLocal()) {
            this.setAdmin(true);
        }
    }

    @Override
    protected void onNewPing() {
        for (Player player : this.players.values()) {
            player.onNewPing();
        }
    }

    @Override
    protected void clientTick(long swNow) {
        if (this.floodQuota > 0.0f) {
            this.floodQuota = Math.max(0.0f, this.floodQuota - 5.0f / (float)((GameServerApp)this.Server).getTicksPerSecond());
        }
        super.clientTick(swNow);
    }

    public void addPlayer(P player) {
        if (this.players.containsValue(player)) {
            throw new RuntimeException("Client already contains player!? (" + ((Player)player).getNr() + ")");
        }
        if (this.players.containsKey(((Player)player).getLocalID())) {
            throw new RuntimeException("Client already contains player for id " + ((Player)player).getLocalID());
        }
        this.players.put(((Player)player).getLocalID(), player);
    }

    protected void writeStartInfo(DataOutputStream out) throws IOException {
        out.write(this.players.size());
        for (Player player : this.players.values()) {
            this.writeStartPlayerInfo(out, player);
        }
    }

    protected void writeStartPlayerInfo(DataOutputStream out, P player) throws IOException {
        out.write(((Player)player).getLocalID());
        out.write(((Player)player).getNr());
    }

    protected void quit(int playerNr) {
        if (playerNr == 0) {
            this.disconnect("Quit");
        } else {
            Player player = (Player)this.players.get(playerNr);
            if (player != null) {
                player.remove("Quit");
                this.onLocalPlayerRemove(player);
            }
        }
    }

    protected void onLocalPlayerRemove(P player) {
        this.players.remove(((Player)player).getLocalID());
    }

    public void sendCommand(String command) {
        if (!this.isFullyConnected()) {
            throw new IllegalStateException("Tried sending a command to a client that is not fully connected yet");
        }
        this.send(((GameServerApp)this.Server).msgCommand(command));
    }

    @Override
    protected byte[] tryGetDisconnectedMessage(TextWithArguments reason) {
        return ((GameServerApp)this.Server).tryMsgDisconnect(reason);
    }

    @Override
    protected byte[] msgPingRequest() {
        return GameServerApp.MSG_PINGREQUEST;
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public void setAdmin(boolean admin) {
        if (this.admin == admin) {
            return;
        }
        this.admin = admin;
        for (Player player : this.players.values()) {
            if (!player.getSlot().isPlaying()) continue;
            player.sendFlags();
        }
    }

    public void kick(String reason) {
        this.disconnect(new TextWithArguments("Custom", reason));
    }

    public String getVersion() {
        return this.version;
    }

    @Override
    public String getName() {
        P player = this.getPrimaryPlayer();
        if (player == null) {
            return super.getName();
        }
        return ((Player)player).getName();
    }

    public P getPrimaryPlayer() {
        return (P)((Player)this.players.get(0));
    }

    public P getPlayer(int localID) {
        return (P)((Player)this.players.get(localID));
    }

    public Iterable<P> enumeratePlayers() {
        return this.players.values();
    }

    @Override
    protected void handleDisconnecting(TextWithArguments reason) {
        ArrayList<P> playersSave = new ArrayList<P>(this.players.values());
        this.players.clear();
        for (Player player : playersSave) {
            player.remove(reason);
        }
        super.handleDisconnecting(reason);
    }

    protected void onGreetingDone() {
        for (Player player : this.players.values()) {
            player.onConnected();
        }
        this.send(((GameServerApp)this.Server).msgGreeting(this));
        this.onGreetingReceived();
        if (this.isLocal()) {
            ((GameServerApp)this.Server).networkMayNowStart();
        }
        Log.Server.info(String.valueOf(this.getNetworkName()) + " has connected!");
        for (Player player : this.players.values()) {
            player.onPostConnected();
        }
    }

    protected LocalPlayerInfo readLocalPlayer(DataInputStream in, LocalPlayerInfo info) throws IOException {
        if (info == null) {
            info = new LocalPlayerInfo();
        }
        info.Id = in.readUnsignedByte();
        info.Name = MiscIO.readChars(in, ((GameProtocol)this.getProtocol()).getMaxPlayerNameLength());
        return info;
    }

    protected void setupPlayer(P player, LocalPlayerInfo info) {
        ((Player)player).setName(((GameData)this.getData()).makeNameValid(info.Name, player));
    }

    @Override
    protected void registerUngreetedMessages() {
        this.registerMessage((byte)10, this::readClientGreeting);
        this.registerMessage(() -> {
            C_PasswordResponse msg = new C_PasswordResponse();
            msg.PasswordHash = new byte[((GameProtocol)this.getProtocol()).getPasswordHashLength()];
            return msg;
        }, this::onPasswordResponse);
    }

    @Override
    protected void registerMessages() {
        this.registerMessage(C_PingResponse::new, (T x) -> this.onPingAnswer());
        this.registerMessage((byte)115, this::readJoin);
        this.registerMessage(C_Quit::new, this::onQuit);
        this.registerMessage(C_ChatMessage::new, this::onChat);
        this.registerMessage((byte)114, this::readCommand);
    }

    private boolean checkEnoughFreeSlots(int numRequested) {
        int free = ((GameData)this.getData()).countFreeSlots() + 1;
        if (numRequested > ((GameServerApp)this.Server).getMaxPlayersForClient(this) || numRequested > free) {
            this.disconnect(new TextWithArguments("TooManyLocalPlayers", numRequested, free));
            return false;
        }
        return true;
    }

    private IMessage readClientGreeting(ReceiverHelper receiver) throws IOException {
        this.util_checkSignature(receiver.Stream, ((GameProtocol)this.getProtocol()).getClientGreeting());
        String sVersion = receiver.Stream.readUTF();
        receiver.postBlocking(() -> {
            this._isVerified = true;
            this.version = sVersion;
            if (!((NetworkGame)((GameServerApp)this.Server).Game).isCompatible(this.version)) {
                int maxLength = 20;
                String sanitizedVersion = Misc.sanitizeVersion(this.version);
                if (sanitizedVersion.length() > maxLength) {
                    sanitizedVersion = String.valueOf(Misc.limitLength(sanitizedVersion, maxLength)) + "...(" + this.version.length() + ")";
                }
                Log.Server.warning("Client " + this.getSlotId() + " has an incompatible version (" + sanitizedVersion + ")");
                this.disconnect(new TextWithArguments("Version", sanitizedVersion));
            }
        });
        byte[] clientSalt = MiscIO.readFully(receiver.Stream, ((GameProtocol)this.getProtocol()).getRandomPasswordSaltLength());
        receiver.post(() -> {
            this._clientSalt = clientSalt;
            byte[] byArray2 = this._clientSalt;
        });
        GreetingInfo dto = this.readGreeting(receiver, null);
        return () -> this.onGreetingReceived(dto);
    }

    protected GreetingInfo readGreeting(ReceiverHelper receiver, GreetingInfo info) throws IOException {
        if (info == null) {
            info = new GreetingInfo();
        }
        int numPlayers = receiver.Stream.readUnsignedByte();
        receiver.postBlocking(() -> {
            boolean bl = this.checkEnoughFreeSlots(numPlayers);
        });
        info.LocalPlayers = new LocalPlayerInfo[numPlayers];
        int i = 0;
        while (i < numPlayers) {
            info.LocalPlayers[i] = this.readLocalPlayer(receiver.Stream, null);
            ++i;
        }
        return info;
    }

    protected void onGreetingReceived(GreetingInfo info) throws AppProtocolException {
        this._greetingInfo = info;
        if (((GameServerApp)this.Server).getPasswordBytes() != null) {
            this.sendPasswordRequest();
        } else {
            this.processGreeting();
        }
    }

    private void processGreeting() throws AppProtocolException {
        GreetingInfo info = this._greetingInfo;
        this._greetingInfo = null;
        this.processGreeting(info);
    }

    protected void processGreeting(GreetingInfo info) throws AppProtocolException {
        if (!this.checkEnoughFreeSlots(info.LocalPlayers.length)) {
            return;
        }
        HashSet<Integer> ids = new HashSet<Integer>();
        LocalPlayerInfo[] localPlayerInfoArray = info.LocalPlayers;
        int n = info.LocalPlayers.length;
        int n2 = 0;
        while (n2 < n) {
            LocalPlayerInfo localPlayer = localPlayerInfoArray[n2];
            if (!ids.add(localPlayer.Id)) {
                throw new AppProtocolException("All local players must have a unique ID");
            }
            ++n2;
        }
        int i = 0;
        while (i < info.LocalPlayers.length) {
            Player player;
            LocalPlayerInfo localPlayerInfo = info.LocalPlayers[i];
            int id = localPlayerInfo.Id;
            if (i == 0) {
                player = (Player)this.players.get(0);
                if (id != player.getLocalID()) {
                    throw new AppProtocolException("Primary player must have the LocalID 0 (had " + id + ")");
                }
            } else {
                if (this.players.containsKey(id)) {
                    throw new AppProtocolException("LocalID " + id + " already taken");
                }
                PlayerSlot slot = ((GameData)this.getData()).tryGetFreeSlot();
                if (slot == null) {
                    throw new RuntimeException("Slots were supposed to be available but aren't?");
                }
                player = ((GameData)this.getData()).addClientPlayer(slot, this, id);
            }
            this.setupPlayer(player, localPlayerInfo);
            ++i;
        }
        this.onGreetingDone();
    }

    private IMessage readJoin(ReceiverHelper receiver) throws IOException {
        LocalPlayerInfo info = this.readLocalPlayer(receiver.Stream, null);
        return () -> {
            PlayerSlot slot;
            if (this.players.size() + 1 <= ((GameServerApp)this.Server).getMaxPlayersForClient(this) && (slot = ((GameData)this.getData()).tryGetFreeSlot()) != null) {
                if (this.players.containsKey(localPlayerInfo.Id)) {
                    throw new AppProtocolException("Players already contains that ID (" + localPlayerInfo.Id + ")");
                }
                Object player = ((GameData)this.getData()).addClientPlayer(slot, this, localPlayerInfo.Id);
                this.setupPlayer(player, info);
                this.send(((GameServerApp)this.Server).msgJoin(player));
                return;
            }
            this.send(((GameServerApp)this.Server).msgNojoin(info));
        };
    }

    private void onQuit(C_Quit msg) {
        this.quit(msg.Who);
    }

    private void onChat(C_ChatMessage msg) {
        if (!this.isAdmin() && this.floodQuota >= 10.0f) {
            this.floodQuota = Math.min(30.0f, this.floodQuota + 3.0f);
            return;
        }
        this.floodQuota = Math.min(30.0f, this.floodQuota + 5.0f);
        P player = this.getPlayer(msg.Who);
        if (player != null) {
            ((Player)player).receiveChat(msg.Message);
        } else {
            int cfr_ignored_0 = msg.Who;
        }
    }

    private IMessage readCommand(ReceiverHelper receiver) throws IOException {
        int who = receiver.Stream.readUnsignedByte();
        String sCmd = receiver.Stream.readUTF();
        return () -> {
            int maxlength = this.getMaxCommandLength();
            if (sCmd.length() > maxlength) {
                this.kick("Command exceeded maximum length of " + maxlength + " chars");
            } else {
                P player = this.getPlayer(who);
                if (player != null || who == 0) {
                    this.onCommand(sCmd, player);
                }
            }
        };
    }

    @Override
    protected void onLagging(boolean lagging) {
        for (Player player : this.players.values()) {
            player.sendFlags();
        }
    }

    protected int getMaxCommandLength() {
        return 1000;
    }

    protected void onCommand(String cmd, P localPlayer) throws AppProtocolException {
        if (this.isAdmin() && ((GameServerApp)this.Server).tryCommand(this, cmd)) {
            return;
        }
        if (localPlayer != null) {
            ((Player)localPlayer).onCommand(cmd);
        }
    }

    @Override
    public boolean isVerifiedPeer() {
        return this._isVerified;
    }

    @Override
    protected void onProtocolError(UnexpectedIOException ex) {
        super.onProtocolError(ex);
        if (this.isVerifiedPeer()) {
            ((Game)((GameServerApp)this.Server).Game).addToErrorLog(ex);
        }
    }

    protected void onPasswordResponse(C_PasswordResponse msg) throws AppProtocolException {
        if (this._serverSalt == null) {
            throw new AppProtocolException("Who asked?");
        }
        if (this.isPasswordCorrect(msg.PasswordHash)) {
            this.processGreeting();
        } else {
            this.sendPasswordRequest();
        }
    }

    protected boolean isPasswordCorrect(byte[] clientPassword) throws AppProtocolException {
        byte[] passwordBytes = ((GameServerApp)this.Server).getPasswordBytes();
        if (passwordBytes == null) {
            return true;
        }
        byte[] passwordHash = ((GameProtocol)this.getProtocol()).getPasswordHash(this._clientSalt, this._serverSalt, passwordBytes);
        return Arrays.equals(passwordHash, clientPassword);
    }

    protected void sendPasswordRequest() {
        this._serverSalt = ((GameProtocol)this.getProtocol()).getRandomPasswordSalt();
        S_PasswordRequest msg = new S_PasswordRequest((GameProtocol)this.getProtocol());
        msg.ServerSalt = this._serverSalt;
        this.send(msg);
    }

    protected static class GreetingInfo {
        LocalPlayerInfo[] LocalPlayers;

        protected GreetingInfo() {
        }
    }

    protected static class LocalPlayerInfo {
        public int Id;
        public String Name;

        protected LocalPlayerInfo() {
        }
    }
}

