/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.ioengine.game.server;

import com.iosoft.helpers.Misc;
import com.iosoft.ioengine.base.server.BaseServerApp;
import com.iosoft.ioengine.game.server.BaseAI;
import com.iosoft.ioengine.game.server.GameData;
import com.iosoft.ioengine.game.server.GameServerApp;
import com.iosoft.ioengine.game.server.Player;
import java.util.ArrayList;
import java.util.List;

public class ChattingAI<P extends Player<D, ?, ?, ? extends BaseAI<P, D>>, D extends GameData<P, ?, ?>>
extends BaseAI<P, D> {
    private List<AIChatMsg> chatMsgs = new ArrayList<AIChatMsg>();
    private double _talkLevel = Misc.random(1.1);
    private boolean _canSayGG = false;
    private boolean _canSayHello = true;

    @Override
    protected void onGameStarted() {
        this._canSayGG = false;
    }

    private boolean shouldRespondToThis() {
        return Misc.randomPercentage(this._talkLevel);
    }

    public void onGameOver() {
        this._canSayGG = true;
    }

    @Override
    protected void onChatMessage(P sender, String sMsg) {
        if (sender == null || sender == this._player || !this.shouldRespondToThis()) {
            return;
        }
        String msgRaw = Misc.trimAll(Misc.toUpper(sMsg));
        if (this._canSayGG && (msgRaw.startsWith("GG") || msgRaw.startsWith("GOODGAME") || msgRaw.startsWith("GOOD GAME"))) {
            String str;
            this._canSayGG = false;
            switch (Misc.getRandomInt(3)) {
                case 1: {
                    str = "gg";
                    break;
                }
                case 2: {
                    str = "Good game!";
                    break;
                }
                default: {
                    str = "GG";
                }
            }
            this.send(str);
        } else if (this._canSayHello && (msgRaw.startsWith("HELLO") || msgRaw.startsWith("GDAY") || msgRaw.startsWith("G'DAY") || msgRaw.startsWith("GOOD DAY") || msgRaw.startsWith("HI") || msgRaw.startsWith("HALLO") || msgRaw.startsWith("HEY"))) {
            String str;
            this._canSayHello = false;
            if (this._talkLevel <= 0.1) {
                str = "hi";
            } else if (this._talkLevel <= 0.2) {
                str = "hi...";
            } else {
                switch (Misc.getRandomInt(6)) {
                    case 1: {
                        str = "Hello " + ((Player)sender).getName() + ", I'm " + this._player.getName() + "!";
                        break;
                    }
                    case 2: {
                        str = "Hello everybody!";
                        break;
                    }
                    case 3: {
                        str = "G'day!";
                        break;
                    }
                    case 4: {
                        str = "good day fellas :)";
                        break;
                    }
                    case 5: {
                        str = "hi " + ((Player)sender).getName();
                        break;
                    }
                    default: {
                        str = "Hi!";
                    }
                }
            }
            this.send(str);
        }
    }

    protected void send(String chat) {
        this.chatMsgs.add(new AIChatMsg(chat));
    }

    @Override
    protected void tick() {
        super.tick();
        int iC = this.chatMsgs.size();
        int i = 0;
        while (i < iC) {
            AIChatMsg cm = this.chatMsgs.get(i);
            if (cm.tick()) {
                this.chatMsgs.remove(i);
                ((GameServerApp)this._player.getServer()).onChatReceived((Player)this._player, cm.Msg);
                --i;
                --iC;
            }
            ++i;
        }
    }

    private class AIChatMsg {
        public final String Msg;
        private int _remaining;

        AIChatMsg(String msg) {
            this.Msg = msg;
            this._remaining = ((BaseServerApp)ChattingAI.this._player.getServer()).getSecondsInTicks((float)(msg.length() + Misc.getRandomInt(10 + msg.length())) * 0.1f);
        }

        public boolean tick() {
            if (this._remaining > 0) {
                --this._remaining;
            }
            return this._remaining <= 0;
        }
    }
}

