/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.ioengine.game.client;

import com.iosoft.helpers.io.MiscIO;
import com.iosoft.ioengine.app.client.ClientApp;
import com.iosoft.ioengine.game.client.ClientPlayerSlot;
import com.iosoft.ioengine.game.client.GameClientApp;
import com.iosoft.ioengine.game.client.GameState;
import java.io.DataOutputStream;
import java.io.IOException;

public class LocalPlayer<C extends GameClientApp<?, ? extends GameState, ?>, P extends ClientPlayerSlot<? extends GameState>> {
    private C _client;
    protected P _slot;
    protected int _localID;
    protected String _name;
    protected boolean _playing;
    protected boolean _needsToBeIncludedInGreeting;

    public void sendQuit() {
        ((GameClientApp)this._client).send_msgQuit(this._localID);
    }

    public void onConnected(P slot) {
        this._slot = slot;
        ((ClientPlayerSlot)this._slot).localPlayer = this;
        this._playing = true;
        ((GameState)((ClientApp)this._client).getAppState()).onLocalPlayerConnected(this);
    }

    public void onDisconnect() {
        this.reset();
    }

    public void reset() {
        this._playing = false;
        this._slot = null;
        this.setNeedsToBeIncludedInGreeting(true);
    }

    public void setClient(C client) {
        this._client = client;
        this.initialize();
    }

    public C getClient() {
        return this._client;
    }

    protected void initialize() {
    }

    public int getLocalID() {
        return this._localID;
    }

    public void setLocalID(int localID) {
        this._localID = localID;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setNeedsToBeIncludedInGreeting(boolean needs) {
        this._needsToBeIncludedInGreeting = needs;
    }

    public P getSlot() {
        return this._slot;
    }

    public boolean needsToBeIncludedInGreeting() {
        return this._needsToBeIncludedInGreeting;
    }

    public void writeInfo(DataOutputStream dos) throws IOException {
        dos.write(this._localID);
        MiscIO.writeChars(dos, this._name.trim(), ((GameClientApp)this._client).getProtocol().getMaxPlayerNameLength());
    }

    public void onRefuse() {
        ((GameClientApp)this._client).localPlayers.remove(this._localID);
        ((GameState)((ClientApp)this._client).getAppState()).onLocalPlayerRefused(this);
    }

    public boolean isConnected() {
        return this._playing;
    }
}

