/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.ioengine.game.client;

import com.iosoft.helpers.BoolConsumer;
import com.iosoft.helpers.IDisposable;
import com.iosoft.helpers.Log;
import com.iosoft.helpers.Misc;
import com.iosoft.helpers.binding.BoolBinding;
import com.iosoft.helpers.binding.BoolObservable;
import com.iosoft.helpers.binding.MyBoolObservable;
import com.iosoft.helpers.binding.MyObservable;
import com.iosoft.helpers.binding.Observable;
import com.iosoft.helpers.event.ArgEvent;
import com.iosoft.helpers.event.ArgEventSource;
import com.iosoft.helpers.io.MiscIO;
import com.iosoft.helpers.iter.SkippingListIterator;
import com.iosoft.helpers.localizer.TextWithArguments;
import com.iosoft.helpers.network.ReceiverHelper;
import com.iosoft.ioengine.AppProtocolException;
import com.iosoft.ioengine.NetUtil;
import com.iosoft.ioengine.app.client.AppState;
import com.iosoft.ioengine.base.IMessage;
import com.iosoft.ioengine.base.ObjMessage;
import com.iosoft.ioengine.base.server.BaseServerApp;
import com.iosoft.ioengine.game.GameProtocol;
import com.iosoft.ioengine.game.NetworkGame;
import com.iosoft.ioengine.game.client.ClientPlayerSlot;
import com.iosoft.ioengine.game.client.GameClientApp;
import com.iosoft.ioengine.game.client.IBlockEndingMessage;
import com.iosoft.ioengine.game.client.LocalPlayer;
import com.iosoft.ioengine.game.ui.GameUI;
import com.iosoft.iogame.ConsoleCommand;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;

public abstract class GameState<C extends GameClientApp<G, ? extends GameState<C, P, U, G>, ? extends LocalPlayer<C, P>>, P extends ClientPlayerSlot<? extends GameState<C, P, U, G>>, U extends GameUI<C, ? extends GameState<C, P, U, G>, G>, G extends NetworkGame<C, ?, ?, ?>>
extends AppState<C> {
    protected boolean laggers;
    protected boolean singleplayer;
    protected boolean openGame;
    protected int maxPlayers;
    protected ClientPlayerSlot[] players;
    protected U ui;
    protected G game;
    protected GameProtocol protocol;
    private boolean _isBlockActive;
    private List<IMessage> _blockMsgs = new ArrayList<IMessage>();
    public boolean ListBlockMessages;
    private final MyObservable<String> connectionStep = new MyObservable<String>("");
    public final Observable<String> ConnectionStep;
    private final MyBoolObservable gameInProgress;
    public final BoolObservable GameInProgress;
    private final MyBoolObservable fullyConnected;
    public final BoolObservable FullyConnected;
    private final MyBoolObservable isAdmin;
    public final BoolObservable IsAdmin;
    private final ArgEventSource<P> playerChanged;
    public final ArgEvent<P> PlayerChanged;
    private volatile boolean causeLag;
    private List<IMessage> _blockMsgs2;

    public GameState() {
        this.ConnectionStep = this.connectionStep.Getter;
        this.gameInProgress = new MyBoolObservable(false);
        this.GameInProgress = this.gameInProgress.Getter;
        this.fullyConnected = new MyBoolObservable(false);
        this.FullyConnected = this.fullyConnected.Getter;
        this.isAdmin = new MyBoolObservable(false);
        this.IsAdmin = this.isAdmin.Getter;
        this.playerChanged = new ArgEventSource();
        this.PlayerChanged = (ArgEvent)this.playerChanged.Event;
        this.causeLag = false;
        this._blockMsgs2 = new ArrayList<IMessage>();
    }

    protected void initPreUI() {
        this.players = new ClientPlayerSlot[this.protocol.getMaxPlayers()];
        int i = 0;
        while (i < this.players.length) {
            this.players[i] = this.createSlot();
            this.players[i].setGame(this, i);
            ++i;
        }
    }

    protected void init() {
    }

    public IDisposable bindCheckInProgressWhenConnected(BoolConsumer action) {
        BoolConsumer consumer = x -> {
            if (!this.isFullyConnected()) {
                return;
            }
            action.accept(this.GameInProgress.get());
        };
        BoolBinding binding1 = this.GameInProgress.bind(consumer);
        BoolBinding binding2 = this.FullyConnected.bind(consumer);
        return () -> {
            binding1.dispose();
            binding2.dispose();
        };
    }

    protected void firePlayerChanged(P player) {
        this.playerChanged.fire(player);
    }

    protected void setGameInProgress(boolean inProgress) throws AppProtocolException {
        this.gameInProgress.set(inProgress);
    }

    public G getGame() {
        return this.game;
    }

    public U getUI() {
        return this.ui;
    }

    @Override
    protected void onConnectingStarts() {
        super.onConnectingStarts();
        ((GameUI)this.ui).onConnecting();
    }

    @Override
    protected void setConnectTarget(String target) {
        ((GameUI)this.ui).setConnectTarget(target);
    }

    @Override
    protected void onConnectionStep(String step) {
        this.connectionStep.set(step);
    }

    @Override
    protected void tick() {
        ((GameUI)this.ui).tick();
    }

    protected abstract U createUI();

    public GameProtocol getProtocol() {
        return this.protocol;
    }

    @Override
    public void onImportantLoaded() {
        ((GameUI)this.ui).onImportantLoaded();
    }

    @Override
    public void onLoaded() {
        ((GameUI)this.ui).onLoaded();
    }

    @Override
    protected void onFullyConnected() {
        if (this.serverLocal && !this.singleplayer) {
            this.serverAddress = new InetSocketAddress(Misc.getLocalInetAddress(), ((BaseServerApp)((NetworkGame)this.game).getServer()).getPort());
        }
        this.fullyConnected.set(true);
    }

    @Override
    protected void onDisconnected(TextWithArguments reason) {
        super.onDisconnected(reason);
        ((GameUI)this.ui).onDisconnected(reason);
        this.fullyConnected.set(false);
        Object server = ((NetworkGame)this.game).getServer();
        if (server != null) {
            ((BaseServerApp)server).tryStop();
        }
        this._blockMsgs.clear();
    }

    @Override
    protected void setClientApp(C clientApp) {
        super.setClientApp(clientApp);
        this.game = ((GameClientApp)this.client).getGame();
        this.protocol = ((GameClientApp)this.client).getProtocol();
        this.ui = this.createUI();
        this.initPreUI();
        ((GameUI)this.ui).onInit((GameState)this);
        this.init();
    }

    @Override
    public void reset() {
        super.reset();
        ClientPlayerSlot[] clientPlayerSlotArray = this.players;
        int n = this.players.length;
        int n2 = 0;
        while (n2 < n) {
            ClientPlayerSlot player = clientPlayerSlotArray[n2];
            player.reset();
            ++n2;
        }
        this.gameInProgress.set(false);
        this.singleplayer = false;
        this.laggers = false;
        this.isAdmin.set(false);
        this.maxPlayers = 0;
        this._isBlockActive = false;
    }

    public boolean isSingleplayer() {
        return this.singleplayer;
    }

    public boolean isOpenGame() {
        return this.openGame;
    }

    protected void checkIsAdmin() {
        Object slot = ((LocalPlayer)((GameClientApp)this.client).getPrimaryLocalPlayer()).getSlot();
        this.isAdmin.set(slot != null && ((ClientPlayerSlot)slot).isAdmin());
    }

    public Iterable<P> enumeratePlayingPlayers() {
        return this.enumeratePlayers(ClientPlayerSlot::isPlaying);
    }

    public Iterable<P> enumeratePlayingPlayers(Predicate<P> predicate) {
        return this.enumeratePlayers(x -> x.isPlaying() && predicate.test(x));
    }

    public Iterable<P> enumeratePlayers(Predicate<P> predicate) {
        return SkippingListIterator.createIterable(Arrays.asList(this.players), predicate);
    }

    public Iterable<P> enumeratePlayers() {
        return Arrays.asList(this.players);
    }

    public P tryGetPlayer(int slot) {
        if (slot >= 0 && slot < this.players.length) {
            return (P)this.players[slot];
        }
        return null;
    }

    public P getPlayerNetwork(int slot) throws AppProtocolException {
        if (slot >= 0 && slot < this.players.length) {
            return (P)this.players[slot];
        }
        throw new AppProtocolException("Cannot get player " + slot);
    }

    public int getMaxPlayers() {
        return this.maxPlayers;
    }

    protected void setMaxPlayers(int newPlayers) {
        this.maxPlayers = newPlayers;
    }

    public AppState.GreetingMessage msgx_greeting(ReceiverHelper rh) throws IOException {
        ((GameClientApp)this.client).util_checkSignature(rh.Stream, this.protocol.getServerGreeting());
        rh.post(this::onGreetingStarts);
        ArrayList<IMessage> messages = new ArrayList<IMessage>();
        this.readGreetingMisc(rh, messages);
        this.readStartInfo(rh, messages);
        return (AppState)this.new AppState.GreetingMessage(messages);
    }

    protected void readGreetingMisc(ReceiverHelper rh, List<IMessage> messages) throws IOException {
        messages.add(this.msgx_setVersion(rh.Stream.readUTF()));
    }

    protected void readSlotStartInfo(DataInputStream in, List<IMessage> messages, int nr) throws IOException {
        int iState = in.readUnsignedByte();
        switch (iState) {
            case 2: {
                messages.add(this.readMsgAddPlayer(in, nr));
                break;
            }
            case 1: {
                messages.add(this.readMsgConnecting(in, nr));
                break;
            }
            case 0: 
            case 3: {
                break;
            }
            default: {
                throw new AppProtocolException("Supplied state (" + iState + ") out of range!");
            }
        }
    }

    protected void readClientStartInfo(DataInputStream in, List<IMessage> messages) throws IOException {
        int numEntries = in.readUnsignedByte() - 1;
        while (numEntries >= 0) {
            messages.add(this.msgx_initSlot(in));
            --numEntries;
        }
        messages.add(() -> {
            for (LocalPlayer player : ((GameClientApp)this.client).localPlayers.values()) {
                if (player.isConnected() || !player.needsToBeIncludedInGreeting()) continue;
                throw new AppProtocolException("Server did not send info about the slot of LocalPlayer " + player.getLocalID());
            }
        });
    }

    protected void readStartUpdates(ReceiverHelper rh, List<IMessage> messages) throws IOException {
        messages.add(this.readServerUpdate(rh.Stream, 1));
        messages.add(this.readServerUpdate(rh.Stream, 0));
        messages.add(this.readServerUpdate(rh.Stream, 2));
    }

    protected void readStartInfo(ReceiverHelper rh, List<IMessage> messages) throws IOException {
        this.readStartUpdates(rh, messages);
        int i = 0;
        while (i < this.players.length) {
            this.readSlotStartInfo(rh.Stream, messages, i);
            ++i;
        }
        this.readClientStartInfo(rh.Stream, messages);
    }

    protected void onServerPasswordRequired(Consumer<String> input) throws AppProtocolException {
        throw new AppProtocolException("The server requires a password");
    }

    protected void setServerFlags(int flags) throws AppProtocolException {
        this.openGame = Misc.getFlag(flags, 1);
        this.singleplayer = Misc.getFlag(flags, 2);
    }

    protected IMessage readServerUpdate(DataInputStream in, int nr) throws IOException {
        switch (nr) {
            case 0: {
                return this.msgx_readMaxplayers(in);
            }
            case 1: {
                int flags = MiscIO.readPacked(in);
                return () -> this.setServerFlags(flags);
            }
            case 2: {
                String sName = in.readUTF();
                return () -> this.setServerName(sName);
            }
        }
        throw new AppProtocolException("Unknown type of server update (" + nr + ")");
    }

    protected void onLocalPlayerConnected(LocalPlayer player) {
        this.checkIsAdmin();
    }

    protected void onLocalPlayerRefused(LocalPlayer player) {
    }

    protected void doCommand(String serverCommand) throws AppProtocolException {
        int index = serverCommand.indexOf(9);
        ConsoleCommand command = index == -1 ? new ConsoleCommand(serverCommand, Misc.EMPTYSTRINGS) : new ConsoleCommand(serverCommand.substring(0, index), serverCommand.substring(index + 1).split("\t", -1));
        this.processServerCommand(command);
    }

    public void fakeServerCommand(ConsoleCommand serverCommand) {
        try {
            this.processServerCommand(serverCommand);
        }
        catch (AppProtocolException e) {
            Log.Client.errorShort("Error processing fake server command", e);
        }
    }

    protected void processServerCommand(ConsoleCommand serverCommand) throws AppProtocolException {
        throw new AppProtocolException("Unknown server command '" + serverCommand.pretty() + "'");
    }

    protected IMessage msgx_command(DataInputStream in) throws IOException {
        String msg = in.readUTF();
        return () -> this.doCommand(msg);
    }

    protected IMessage msgx_serverupdate(DataInputStream in) throws IOException {
        int updatesBits = MiscIO.readPacked(in);
        LinkedList<IMessage> messages = new LinkedList<IMessage>();
        int i = 0;
        while (i < 32) {
            if (Misc.getBit(updatesBits, i)) {
                messages.add(this.readServerUpdate(in, i));
            }
            ++i;
        }
        return (AppState)this.new AppState.MessageBlock(messages);
    }

    protected IMessage msgx_playerupdate(DataInputStream in) throws IOException {
        int slot = in.readUnsignedByte();
        int updatesBits = MiscIO.readPacked(in);
        LinkedList<ObjMessage<P>> messages = new LinkedList<ObjMessage<P>>();
        int i = 0;
        while (i < 32) {
            if (Misc.getBit(updatesBits, i)) {
                messages.add(this.readPlayerUpdate(in, i));
            }
            ++i;
        }
        return () -> {
            P player = this.getPlayerNetwork(slot);
            for (ObjMessage message : messages) {
                message.run(player);
            }
            ((ClientPlayerSlot)player).fireChanged();
        };
    }

    protected ObjMessage<P> readPlayerUpdate(DataInputStream in, int nr) throws IOException {
        switch (nr) {
            case 0: {
                int flags = MiscIO.readPacked(in);
                return p -> p.readFlags(flags);
            }
            case 1: {
                String name = in.readUTF();
                return p -> p.setName(name);
            }
            case 2: {
                char ping = in.readChar();
                return p -> p.setPing(ping);
            }
        }
        throw new AppProtocolException("Unknown type of player update (" + nr + ")");
    }

    protected void onSwapped(P slot1, P slot2) {
    }

    protected IMessage msgx_initSlot(DataInputStream in) throws IOException {
        return this.msgx_join(in);
    }

    public MaxplayersMessage msgx_readMaxplayers(DataInputStream in) throws IOException {
        return new MaxplayersMessage(NetUtil.range(in.readUnsignedByte(), 1, this.protocol.getMaxPlayers()));
    }

    public IMessage msgx_setConnecting(DataInputStream in) throws IOException {
        return this.readMsgConnecting(in, in.readUnsignedByte());
    }

    public IMessage msgx_addPlayer(DataInputStream in) throws IOException {
        return this.readMsgAddPlayer(in, in.readUnsignedByte());
    }

    public IMessage msgx_removePlayer(DataInputStream in) throws IOException {
        int slot = in.readUnsignedByte();
        int reason = in.readUnsignedByte();
        ArrayList<Object> argsRaw = new ArrayList<Object>();
        this.readRemovePlayerData(in, slot, reason, argsRaw);
        return () -> this.onRemovePlayer(this.getPlayerNetwork(slot), reason, argsRaw);
    }

    protected void onRemovePlayer(P player, int reason, List<Object> argsRaw) {
        String name = ((ClientPlayerSlot)player).isPlaying() ? ((ClientPlayerSlot)player).getName() : "Player #" + ((ClientPlayerSlot)player).getNr();
        argsRaw.add(0, name);
        String localizationCode = ((GameClientApp)this.client).tryGetRemoveReasonTextByID(reason);
        if (localizationCode == null) {
            localizationCode = "Undefined";
            argsRaw.add(1, reason);
        }
        ((ClientPlayerSlot)player).onRemoved((TextWithArguments)(reason == 0 && ((ClientPlayerSlot)player).isConnecting() ? null : new TextWithArguments("_RemoveReason_" + localizationCode, argsRaw.toArray())));
    }

    public IMessage msgx_swapSlot(DataInputStream in) throws IOException {
        int slotNr2;
        int slotNr1 = NetUtil.rangeExclusive(in.readUnsignedByte(), this.protocol.getMaxPlayers());
        if (slotNr1 == (slotNr2 = NetUtil.rangeExclusive(in.readUnsignedByte(), this.protocol.getMaxPlayers()))) {
            throw new AppProtocolException("Cannot swap slot " + slotNr1 + " with self");
        }
        return () -> {
            P slot1 = this.getPlayerNetwork(slotNr1);
            P slot2 = this.getPlayerNetwork(slotNr2);
            this.players[n] = slot2;
            this.players[n2] = slot1;
            ((ClientPlayerSlot)slot1).setNr(slotNr2);
            ((ClientPlayerSlot)slot2).setNr(slotNr1);
            this.onSwapped(slot1, slot2);
        };
    }

    public AppState.DisconnectMessage msgx_disconnect(DataInputStream in) throws IOException {
        int serverReason = in.readUnsignedByte();
        return this.readDisconnectReason(in, serverReason, ((GameClientApp)this.client).getReasonByDisconnectMessage(serverReason));
    }

    protected AppState.DisconnectMessage readDisconnectReason(DataInputStream in, int serverReason, String reasonText) throws IOException {
        if (serverReason == 3 || serverReason == 40) {
            return new AppState.DisconnectMessage(new TextWithArguments(reasonText, in.readUTF()));
        }
        if (reasonText.equals("UnknownServerReason")) {
            return new AppState.DisconnectMessage(new TextWithArguments(reasonText, serverReason));
        }
        return new AppState.DisconnectMessage(new TextWithArguments(reasonText, new Object[0]));
    }

    public IMessage msgx_chatMsg(DataInputStream in) throws IOException {
        int sender = in.readUnsignedByte();
        String msg = in.readUTF();
        return () -> this.onChatMsg(msg, sender == 255 ? null : (P)this.getPlayerNetwork(sender));
    }

    protected void onChatMsg(String msg, P sender) throws AppProtocolException {
        System.out.println(String.valueOf(sender == null ? "Server" : String.valueOf(((ClientPlayerSlot)sender).getNr()) + "/" + ((ClientPlayerSlot)sender).getName()) + ": " + msg);
    }

    public IMessage readMsgAddPlayer(DataInputStream in, int slot) throws IOException {
        ObjMessage<P> pr = this.readAddPlayerData(in, slot);
        return () -> {
            P p = this.getPlayerNetwork(slot);
            ((ClientPlayerSlot)p).reset();
            pr.run(p);
            ((ClientPlayerSlot)p).onConnected();
        };
    }

    public IMessage readMsgConnecting(DataInputStream in, int slot) throws IOException {
        return () -> ((ClientPlayerSlot)this.getPlayerNetwork(slot)).onConnecting();
    }

    public ObjMessage<P> readAddPlayerData(DataInputStream in, int slot) throws IOException {
        ArrayList messages = new ArrayList();
        this.readAddPlayerData(in, slot, messages);
        return p -> {
            for (ObjMessage runner : messages) {
                runner.run(p);
            }
        };
    }

    protected void readAddPlayerData(DataInputStream in, int slot, List<ObjMessage<P>> messages) throws IOException {
        messages.add(this.readPlayerUpdate(in, 0));
        messages.add(this.readPlayerUpdate(in, 1));
        messages.add(this.readPlayerUpdate(in, 2));
    }

    public void readRemovePlayerData(DataInputStream in, int slot, int reason, List<Object> list) throws IOException {
        if (reason == 7 || reason == 8) {
            list.add(in.readUTF());
        }
    }

    protected void setServerName(String newName) {
        this.serverName = newName;
    }

    protected abstract P createSlot();

    protected JoinMessage msgx_join(DataInputStream in) throws IOException {
        int iWho = in.readUnsignedByte();
        final int playerNr = in.readUnsignedByte();
        return new JoinMessage(this, iWho){

            @Override
            public void run() throws AppProtocolException {
                Log.Client.info("Got a slot for local player " + this.Who + " as player " + playerNr);
                LocalPlayer me = (LocalPlayer)((GameClientApp)((GameState)this).client).localPlayers.get(this.Who);
                if (me == null) {
                    return;
                }
                if (me.isConnected()) {
                    throw new AppProtocolException("Cannot accept a player that was accepted already (" + this.Who + " -> " + playerNr + ")");
                }
                Object player = this.getPlayerNetwork(playerNr);
                me.onConnected(player);
                this.checkIsAdmin();
            }
        };
    }

    protected IMessage msgx_nojoin(DataInputStream in) throws IOException {
        int who = in.readUnsignedByte();
        return () -> {
            Log.Client.info("Got a nojoin for local player " + who);
            if (who == 0) {
                throw new AppProtocolException("Cannot refuse local player " + who);
            }
            LocalPlayer player = (LocalPlayer)((GameClientApp)this.client).localPlayers.get(who);
            if (player != null) {
                if (player.isConnected()) {
                    throw new AppProtocolException("Cannot refuse a local player that has been accepted (" + who + ")");
                }
                player.onRefuse();
            }
        };
    }

    boolean tryAddBlockMessage(IMessage message) throws AppProtocolException {
        IBlockEndingMessage tem;
        if (!this._isBlockActive) {
            return false;
        }
        if (message instanceof IBlockEndingMessage && (tem = (IBlockEndingMessage)message).doImmediatelyMustStartBlock()) {
            this._blockMsgs.add(message);
            this.onBlockEnd();
            return false;
        }
        this._blockMsgs.add(message);
        return true;
    }

    public IMessage msg_startBlock(DataInputStream in) throws IOException {
        return this::startBlock;
    }

    public IBlockEndingMessage msg_endBlock(DataInputStream in) throws IOException {
        if (this.causeLag) {
            this.causeLag = false;
            Misc.sleep(500L);
        }
        return new IBlockEndingMessage(){

            @Override
            public void run() throws AppProtocolException {
            }

            @Override
            public boolean doImmediatelyMustStartBlock() throws AppProtocolException {
                GameState.this.endBlock();
                return true;
            }
        };
    }

    public void causeLag() {
        this.causeLag = true;
    }

    protected void startBlock() throws AppProtocolException {
        this._isBlockActive = true;
    }

    protected void endBlock() throws AppProtocolException {
        this._isBlockActive = false;
    }

    protected void onBlockEnd() throws AppProtocolException {
        this.processBlockMessages();
    }

    protected void processBlockMessages() throws AppProtocolException {
        if (((GameClientApp)this.client).isUnconnected()) {
            this._blockMsgs.clear();
            this._blockMsgs2.clear();
            return;
        }
        List<IMessage> temp = this._blockMsgs2;
        this._blockMsgs2 = this._blockMsgs;
        this._blockMsgs = temp;
        for (IMessage msg : this._blockMsgs2) {
            if (this.ListBlockMessages) {
                Log.Client.info(Misc.getClassName(msg));
            }
            msg.run();
            if (((GameClientApp)this.client).isUnconnected()) break;
        }
        this._blockMsgs2.clear();
        this.ListBlockMessages = false;
    }

    public boolean isBlockActive() {
        return this._isBlockActive;
    }

    public int tryGetOwnPing() {
        Object slot = ((LocalPlayer)((GameClientApp)this.getClientApp()).getPrimaryLocalPlayer()).getSlot();
        return slot == null ? -1 : ((ClientPlayerSlot)slot).getPing();
    }

    public boolean isLowLatencyNetwork() {
        if (this.isServerLocal() && !((GameClientApp)this.getClientApp()).UseLagTest) {
            return true;
        }
        int ownPing = this.tryGetOwnPing();
        return ownPing >= 0 && ownPing < 10;
    }

    protected abstract class JoinMessage
    implements IMessage {
        public final int Who;

        public JoinMessage(int who) {
            this.Who = who;
        }
    }

    protected class MaxplayersMessage
    implements IMessage {
        public int num;

        public MaxplayersMessage(int num) {
            this.num = num;
        }

        @Override
        public void run() {
            GameState.this.setMaxPlayers(this.num);
        }
    }
}

