/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.ioengine.game.client;

import com.iosoft.helpers.UnexpectedIOException;
import com.iosoft.helpers.WrapException;
import com.iosoft.helpers.io.MiscIO;
import com.iosoft.helpers.localizer.TextWithArguments;
import com.iosoft.ioengine.AppProtocolException;
import com.iosoft.ioengine.app.client.ClientApp;
import com.iosoft.ioengine.base.IMessage;
import com.iosoft.ioengine.base.NetworkActor;
import com.iosoft.ioengine.base.server.BaseServerApp;
import com.iosoft.ioengine.game.GameProtocol;
import com.iosoft.ioengine.game.NetGameSettings;
import com.iosoft.ioengine.game.NetworkGame;
import com.iosoft.ioengine.game.client.ClientPlayerSlot;
import com.iosoft.ioengine.game.client.GameState;
import com.iosoft.ioengine.game.client.LocalPlayer;
import com.iosoft.ioengine.game.shared.dtos.C_ChatMessage;
import com.iosoft.ioengine.game.shared.dtos.C_PasswordResponse;
import com.iosoft.ioengine.game.shared.dtos.C_PingResponse;
import com.iosoft.ioengine.game.shared.dtos.C_Quit;
import com.iosoft.ioengine.game.shared.dtos.S_PasswordRequest;
import com.iosoft.ioengine.game.shared.dtos.S_PingRequest;
import com.iosoft.ioengine.game.ui.GameUI;
import com.iosoft.iogame.Game;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public abstract class GameClientApp<G extends NetworkGame<? extends GameClientApp<G, S, L>, ?, ?, ?>, S extends GameState<? extends GameClientApp<G, S, L>, ? extends ClientPlayerSlot<S>, ? extends GameUI<? extends GameClientApp<G, S, L>, S, G>, G>, L extends LocalPlayer<? extends GameClientApp<G, S, L>, ? extends ClientPlayerSlot<S>>>
extends ClientApp<S> {
    public final G Game;
    protected final Map<Integer, L> localPlayers = new HashMap<Integer, L>();
    protected final Map<Integer, String> removeReasonLocalizationMapping = new HashMap<Integer, String>();
    protected L primaryLocalPlayer;
    protected int localPlayerCounter;
    private byte[] _clientPasswordSalt;
    private boolean _serverHasAskedForPassword;

    public GameClientApp(G game) {
        this.Game = game;
        this.fillReasonMappings(this.removeReasonLocalizationMapping);
    }

    protected L createLocalPlayer() {
        return (L)new LocalPlayer();
    }

    protected void initLocalPlayer(L player, String name) {
        ((LocalPlayer)player).setName(name);
    }

    protected boolean shouldSetLocalPlayerNameOnConnect() {
        return true;
    }

    @Override
    protected void onConnected() {
        if (this.shouldSetLocalPlayerNameOnConnect()) {
            this.initLocalPlayer(this.getPrimaryLocalPlayer(), this.getPrimaryPlayerName());
        }
        super.onConnected();
    }

    @Override
    protected void fillServerDisconnectReasonMapping(Map<Integer, String> mapping) {
        super.fillServerDisconnectReasonMapping(mapping);
        mapping.put(40, "Custom");
        mapping.put(41, "GameInProgress");
        mapping.put(42, "TooManyLocalPlayers");
    }

    public G getGame() {
        return this.Game;
    }

    @Override
    protected boolean wholeEngineStopped() {
        return ((Game)this.Game).isStopped();
    }

    public GameProtocol getProtocol() {
        return ((NetworkGame)this.Game).getProtocol();
    }

    @Override
    public void onLoaded() {
        this.initLocalPlayers();
        super.onLoaded();
    }

    protected void initLocalPlayers() {
        this.localPlayerCounter = -1;
        this.localPlayers.clear();
        this.primaryLocalPlayer = this.createLocalPlayer();
        this.initLocalPlayer(this.primaryLocalPlayer, this.getPrimaryPlayerName());
        if (!this.addLocalPlayer(this.primaryLocalPlayer)) {
            throw new IllegalStateException("Could not add the primary player");
        }
    }

    @Override
    protected void onDisconnecting(TextWithArguments reason) {
        this._clientPasswordSalt = null;
        this._serverHasAskedForPassword = false;
        for (LocalPlayer localPlayer : this.localPlayers.values()) {
            localPlayer.onDisconnect();
        }
        super.onDisconnecting(reason);
    }

    public L getPrimaryLocalPlayer() {
        return this.primaryLocalPlayer;
    }

    public L getLocalPlayer(int id) throws AppProtocolException {
        LocalPlayer player = (LocalPlayer)this.localPlayers.get(id);
        if (player == null || !player.isConnected()) {
            return null;
        }
        return (L)player;
    }

    public Collection<L> getLocalPlayers() {
        return this.localPlayers.values();
    }

    public String getPrimaryPlayerName() {
        return ((NetGameSettings)((NetworkGame)this.Game).Settings).PlayerName;
    }

    protected int getLocalServerPort() {
        return ((BaseServerApp)((NetworkGame)this.Game).getServer()).getPort();
    }

    @Override
    protected void send_msgGreeting() {
        this._clientPasswordSalt = this.getProtocol().getRandomPasswordSalt();
        try {
            this.Net.write(10);
            MiscIO.writeCString(this.Net, this.getProtocol().getClientGreeting());
            this.Net.writeUTF(((Game)this.Game).getVersion());
            this.Net.write(this._clientPasswordSalt);
            this.writeGreeting(this.Net);
            this.send();
        }
        catch (IOException e) {
            throw new WrapException(e);
        }
    }

    protected void writeGreeting(DataOutputStream dos) throws IOException {
        dos.write(this.localPlayers.size());
        for (LocalPlayer player : this.localPlayers.values()) {
            player.writeInfo(dos);
        }
    }

    protected void send_msgCommand(String cmd, LocalPlayer who) {
        try {
            this.Net.write(114);
            this.Net.write(who.getLocalID());
            this.Net.writeUTF(cmd);
            this.send();
        }
        catch (IOException e) {
            throw new WrapException(e);
        }
    }

    public void sendCommandIfFullyConnected(String cmd) {
        this.sendCommandIfFullyConnected(cmd, (LocalPlayer)this.getPrimaryLocalPlayer());
    }

    public void sendCommandIfFullyConnected(String cmd, LocalPlayer player) {
        if (((GameState)this.getAppState()).isFullyConnected()) {
            this.send_msgCommand(cmd, player);
        }
    }

    public void sendCommand(String cmd) {
        this.send_msgCommand(cmd, (LocalPlayer)this.getPrimaryLocalPlayer());
    }

    protected void send_msgJoin(LocalPlayer player) {
        try {
            this.Net.write(115);
            player.writeInfo(this.Net);
            this.send();
        }
        catch (IOException e) {
            throw new WrapException(e);
        }
    }

    public boolean addLocalPlayer(L player) {
        int start = this.localPlayerCounter;
        do {
            this.localPlayerCounter = (this.localPlayerCounter + 1) % 256;
            if (this.localPlayerCounter != start) continue;
            return false;
        } while (this.localPlayers.containsKey(this.localPlayerCounter));
        ((LocalPlayer)player).setClient((GameClientApp)this);
        ((LocalPlayer)player).setLocalID(this.localPlayerCounter);
        this.localPlayers.put(this.localPlayerCounter, player);
        if (this.connectionState == NetworkActor.ConnectionState.WAIT_FOR_GREETING || this.connectionState == NetworkActor.ConnectionState.READY) {
            this.send_msgJoin((LocalPlayer)player);
        } else {
            ((LocalPlayer)player).setNeedsToBeIncludedInGreeting(true);
        }
        return true;
    }

    protected void send_msgQuit(int who) {
        C_Quit msg = new C_Quit();
        msg.Who = who;
        this.send(msg);
    }

    @Override
    protected void send_msgQuit() {
        this.send_msgQuit(0);
    }

    public void chat(String msg, int localPlayerID) {
        this.send_msgChat(msg, localPlayerID);
    }

    protected void send_msgChat(String text, int who) {
        C_ChatMessage msg = new C_ChatMessage();
        msg.Message = text;
        msg.Who = who;
        this.send(msg);
    }

    @Override
    protected void util_checkSignature(DataInputStream in, String signature) throws IOException {
        super.util_checkSignature(in, signature);
    }

    @Override
    protected void onPingRequest() {
        super.onPingRequest();
        this.send(new C_PingResponse());
    }

    protected void onPasswordRequest(S_PasswordRequest msg) throws AppProtocolException {
        this._serverHasAskedForPassword = true;
        if (this.isFullyConnected()) {
            throw new AppProtocolException("Password requested while already connected?");
        }
        ((GameState)this.getAppState()).onServerPasswordRequired(x -> this.onPasswordEntered(s_PasswordRequest.ServerSalt, (String)x));
    }

    protected void onPasswordEntered(byte[] serverSalt, String password) {
        if (this._clientPasswordSalt == null) {
            return;
        }
        C_PasswordResponse msg = new C_PasswordResponse();
        GameProtocol protocol = this.getProtocol();
        msg.PasswordHash = protocol.getPasswordHash(this._clientPasswordSalt, serverSalt, protocol.getPasswordBytes(password));
        this.send(msg);
    }

    @Override
    protected void registerUngreetedMessages() {
        GameState appState = (GameState)this.getAppState();
        this.registerMessage((byte)10, appState::msgx_greeting);
        this.registerMessage((byte)12, appState::msgx_disconnect);
        this.registerMessage(() -> new S_PasswordRequest(this.getProtocol()), this::onPasswordRequest);
    }

    @Override
    protected void registerMessages() {
        this.registerMessage(S_PingRequest::new, (T x) -> this.onPingRequest());
        GameState appState = (GameState)this.getAppState();
        this.registerMessage((byte)21, appState::msgx_nojoin);
        this.registerMessage((byte)22, appState::msgx_join);
        this.registerMessage((byte)14, appState::msgx_setConnecting);
        this.registerMessage((byte)15, appState::msgx_addPlayer);
        this.registerMessage((byte)16, appState::msgx_removePlayer);
        this.registerMessage((byte)17, appState::msgx_swapSlot);
        this.registerMessage((byte)13, appState::msgx_chatMsg);
        this.registerMessage((byte)20, appState::msgx_command);
        this.registerMessage((byte)19, appState::msgx_serverupdate);
        this.registerMessage((byte)18, appState::msgx_playerupdate);
        this.registerMessage((byte)23, appState::msg_startBlock);
        this.registerMessage((byte)24, appState::msg_endBlock);
    }

    @Override
    protected void onProtocolError(UnexpectedIOException ex) {
        super.onProtocolError(ex);
        ((Game)this.Game).addToErrorLog(ex);
    }

    @Override
    protected void run(IMessage msg) {
        try {
            if (this.isConnected() && !((GameState)this.getAppState()).tryAddBlockMessage(msg)) {
                msg.run();
            }
        }
        catch (UnexpectedIOException ex) {
            this.onProtocolError(ex);
        }
    }

    @Override
    public boolean isVerifiedPeer() {
        return ((GameState)this.getAppState()).ConnectionStep.get() != "Waiting" || this._serverHasAskedForPassword;
    }

    protected void fillReasonMappings(Map<Integer, String> rr) {
        rr.put(1, "Kick");
        rr.put(8, "Custom");
        rr.put(2, "Ban");
        rr.put(3, "Protocol");
        rr.put(4, "Timeout");
        rr.put(5, "Left");
        rr.put(6, "Lost");
        rr.put(9, "Overflow");
        rr.put(7, "Version");
        rr.put(10, "Protocol");
    }

    public String tryGetRemoveReasonTextByID(int removeReasonID) {
        return this.removeReasonLocalizationMapping.get(removeReasonID);
    }
}

