/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.ioengine.game.client;

import com.iosoft.helpers.Misc;
import com.iosoft.helpers.localizer.TextWithArguments;
import com.iosoft.ioengine.game.client.GameState;
import com.iosoft.ioengine.game.client.LocalPlayer;

public abstract class ClientPlayerSlot<S extends GameState<?, ? extends ClientPlayerSlot<S>, ?, ?>> {
    protected S _gs;
    protected boolean admin;
    protected boolean _ready;
    protected boolean _ai;
    protected boolean _lagging;
    protected int _nr;
    protected int slotState;
    protected int _ping;
    protected String _name;
    protected LocalPlayer<?, ?> localPlayer;

    public void reset() {
        this._name = "Player " + this._nr;
        this.slotState = 0;
        this.admin = false;
        this._ready = false;
        this._ai = false;
        this._lagging = false;
        this._ping = 0;
        this.localPlayer = null;
    }

    public void onRemoved(TextWithArguments reason) {
        this.slotState = 0;
    }

    public void onConnecting() {
        this.reset();
        this.slotState = 1;
    }

    public void onConnected() {
        this.slotState = 2;
    }

    public void readFlags(int flags) {
        this.setAdmin(Misc.getFlag(flags, 1));
        this.setAI(Misc.getFlag(flags, 2));
        this.setReady(Misc.getFlag(flags, 4));
        this.setLagging(Misc.getFlag(flags, 8));
    }

    protected void setAdmin(boolean admin) {
        this.admin = admin;
        ((GameState)this._gs).checkIsAdmin();
    }

    protected void setAI(boolean ai) {
        this._ai = ai;
    }

    protected void setReady(boolean ready) {
        this._ready = ready;
    }

    protected void setLagging(boolean lagging) {
        this._lagging = lagging;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public int getNr() {
        return this._nr;
    }

    public void setNr(int nr) {
        this._nr = nr;
    }

    public void setGame(S gs, int nr) {
        this._gs = gs;
        this._nr = nr;
    }

    public S getGameState() {
        return this._gs;
    }

    public void setPing(int ping) {
        this._ping = ping;
    }

    public int getPing() {
        return this._ping;
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public boolean isAI() {
        return this._ai;
    }

    public boolean isReady() {
        return this._ready;
    }

    public boolean isLagging() {
        return this._lagging;
    }

    public boolean isFree() {
        return this.slotState == 0;
    }

    public boolean isConnecting() {
        return this.slotState == 1;
    }

    public boolean isPlaying() {
        return this.slotState == 2;
    }

    public boolean isClosed() {
        return this.slotState == 3;
    }

    public <L extends LocalPlayer<?, ?>> L getLocalPlayer() {
        return (L)this.localPlayer;
    }

    public boolean isOccupied() {
        return this.isConnecting() || this.isPlaying();
    }

    public boolean isLocal() {
        return this.localPlayer != null;
    }

    protected void fireChanged() {
        ((GameState)this._gs).firePlayerChanged((ClientPlayerSlot)this);
    }

    public String toString() {
        return String.valueOf(Misc.getClassName(this)) + "(" + this.getNr() + ", " + (this.isLocal() ? Integer.valueOf(((LocalPlayer)this.getLocalPlayer())._localID) : "-") + ", '" + this.getName() + "')";
    }
}

