/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.ioengine.game;

import com.iosoft.helpers.Log;
import com.iosoft.helpers.Misc;
import com.iosoft.helpers.Mutable;
import com.iosoft.helpers.Pair;
import com.iosoft.helpers.async.Async;
import com.iosoft.helpers.async.VTask;
import com.iosoft.helpers.async.dispatcher.Dispatcher;
import com.iosoft.helpers.async.dispatcher.LockingDispatcher;
import com.iosoft.helpers.awt.ImageCollection;
import com.iosoft.helpers.awt.MiscImg;
import com.iosoft.helpers.datasource.Resource;
import com.iosoft.helpers.io.MiscIO;
import com.iosoft.helpers.localizer.LocalizationParser;
import com.iosoft.helpers.localizer.Localizer;
import com.iosoft.helpers.localizer.TextWithArguments;
import com.iosoft.helpers.network.IpPort;
import com.iosoft.helpers.network.IpPortBase;
import com.iosoft.helpers.network.IpPortOptional;
import com.iosoft.helpers.network.MiscNet;
import com.iosoft.helpers.network.StreamPair;
import com.iosoft.helpers.network.util.IpVersion;
import com.iosoft.ioengine.app.client.ClientApp;
import com.iosoft.ioengine.app.server.ServerApp;
import com.iosoft.ioengine.base.NetworkActor;
import com.iosoft.ioengine.base.client.BaseClientApp;
import com.iosoft.ioengine.base.server.BaseServerApp;
import com.iosoft.ioengine.game.GameProtocol;
import com.iosoft.ioengine.game.HeadlessMode;
import com.iosoft.ioengine.game.LoadMode;
import com.iosoft.ioengine.game.NetGameSettings;
import com.iosoft.ioengine.game.SharedData;
import com.iosoft.ioengine.game.client.GameClientApp;
import com.iosoft.ioengine.game.client.GameState;
import com.iosoft.ioengine.game.server.GameData;
import com.iosoft.ioengine.game.server.GameDedicatedInfo;
import com.iosoft.ioengine.game.server.GameServerApp;
import com.iosoft.ioengine.game.ui.GameUI;
import com.iosoft.ioengine.serverbrowser.client.ServerDataDto;
import com.iosoft.ioengine.serverbrowser.client.ui.IServerBrowserMiscProvider;
import com.iosoft.iogame.Game;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;

public abstract class NetworkGame<C extends GameClientApp<?, ?, ?>, S extends GameServerApp<?, ?, ?, ?>, P extends SharedData<? extends GameProtocol>, TSettings extends NetGameSettings>
extends Game<TSettings>
implements IServerBrowserMiscProvider {
    public final P SharedData;
    public final boolean OwnsSharedData;
    protected boolean _dedicated;
    protected boolean _headless;
    protected S _server;
    protected C _client;
    protected ImageIcon[] _serverBrowserIcons;
    protected HeadlessMode<? extends NetworkGame<C, S, P, TSettings>, S, ? extends GameDedicatedInfo> _headlessMode;
    private String _headlessModeConfigSuffix = "";
    protected IpPortOptional _launchConnect;
    private boolean _hasLoaded;

    protected NetworkGame() {
        this.OwnsSharedData = true;
        this.SharedData = this.createSharedData();
    }

    protected <T extends NetworkGame<C, S, P, TSettings>> NetworkGame(T copyFrom) {
        super(copyFrom.Localizer);
        this.OwnsSharedData = false;
        this.SharedData = copyFrom.SharedData;
        ((SharedData)this.SharedData).waitForLoaded().waitBlockingCrashOnInterrupt();
    }

    @Override
    protected void initialize() {
        super.initialize();
        if (this._headless) {
            this._headlessMode = this.createHeadlessMode();
            this._headlessMode.setGame(this);
        }
        this._server = this.createServer();
        if (!this._headless) {
            this._client = this.createClient();
            if (this._client != null) {
                ((ClientApp)this._client).initialize();
            }
        }
    }

    @Override
    protected void postInitialize() {
        super.postInitialize();
        if (this._client != null) {
            ((BaseClientApp)this._client).doInit();
        }
    }

    @Override
    protected void initSettings() {
        super.initSettings();
        ((NetGameSettings)this.Settings).initNet(((GameProtocol)((SharedData)this.SharedData).Protocol).getDefaultPort(), this._headlessModeConfigSuffix);
    }

    protected LoadMode getLoadMode() {
        LoadMode loadMode = new LoadMode();
        loadMode.IsDevmode = this.isDevmode();
        loadMode.HasClient = this._client != null;
        loadMode.HasUI = !this.isHeadless();
        return loadMode;
    }

    @Override
    protected VTask loadImportantAssetsAsync() {
        VTask task = super.loadImportantAssetsAsync();
        if (this.OwnsSharedData) {
            task = task.awaitAndContinueVTask(() -> ((SharedData)this.SharedData).loadImportantAssetsAsync(this.getLoadMode()));
        }
        return task;
    }

    @Override
    protected boolean shouldLoadLocalizations() {
        return this.OwnsSharedData;
    }

    @Override
    protected VTask loadAssetsAsync() {
        VTask task = super.loadAssetsAsync().awaitAndContinueVTask(() -> VTask.runAsync(MiscNet::ensureNetworkingWarmupIsDone));
        if (this.OwnsSharedData) {
            task = task.awaitAndContinueVTask(() -> ((SharedData)this.SharedData).loadAssetsAsync(this.getLoadMode()));
        }
        if (this.skipLoadMedia()) {
            return task;
        }
        return task.awaitAndContinueVTask(() -> Async.runAsyncEnforced(() -> new Pair<BufferedImage[], BufferedImage>(new ImageCollection((BufferedImage)MiscImg.loadImage((String)"/res/ioengine/images/serverbrowser.png"), (int)6, (int)1).Images, MiscImg.loadImage("/res/ioengine/images/serverbrowser_sort.png"))).awaitAndContinue(images -> {
            this._serverBrowserIcons = new ImageIcon[((BufferedImage[])images.V1).length + 2];
            this._serverBrowserIcons[0] = new ImageIcon((Image)images.V2);
            this._serverBrowserIcons[1] = new ImageIcon(MiscImg.rotate90DegreeSteps((Image)images.V2, 2));
            int i = 0;
            while (i < ((BufferedImage[])images.V1).length) {
                this._serverBrowserIcons[i + 2] = new ImageIcon(((BufferedImage[])images.V1)[i]);
                ++i;
            }
        }));
    }

    @Override
    protected void onImportantLoaded() {
        super.onImportantLoaded();
        if (this._client != null) {
            ((ClientApp)this._client).onImportantLoaded();
        }
    }

    @Override
    protected void onLoaded() {
        if (this.OwnsSharedData) {
            ((SharedData)this.SharedData).onEverythingLoaded();
        }
        if (this._client != null) {
            ((GameClientApp)this._client).onLoaded();
        }
        super.onLoaded();
        if (this._headless) {
            this._headlessMode.start();
        }
    }

    protected abstract P createSharedData();

    @Override
    public GameProtocol getProtocol() {
        return (GameProtocol)((SharedData)this.SharedData).Protocol;
    }

    @Override
    protected Dispatcher createDispatcher() {
        if (!this._headless) {
            return this.createUIDispatcher();
        }
        LockingDispatcher dispatcher = new LockingDispatcher();
        dispatcher.dispatch(() -> this.ShutdownDone.await(dispatcher::dispose));
        return dispatcher;
    }

    protected abstract Dispatcher createUIDispatcher();

    public boolean tryConnectTo(SocketAddress address) {
        return this.tryConnectTo(Collections.singletonList(address));
    }

    @Override
    public boolean tryConnectTo(Iterable<SocketAddress> addresses) {
        if (!((BaseClientApp)this._client).isConnectable()) {
            return false;
        }
        Iterator<SocketAddress> iter = addresses.iterator();
        if (!iter.hasNext()) {
            return false;
        }
        Mutable mutHandler = new Mutable();
        Runnable stop = () -> ((GameClientApp)this._client).ConnectionStateChanged.unregister((Runnable)mutable.Value);
        Runnable connectNext = () -> {
            SocketAddress address = (SocketAddress)iter.next();
            if (!iter.hasNext()) {
                stop.run();
            }
            ((BaseClientApp)this._client).connect(address);
        };
        mutHandler.Value = () -> {
            if (((NetworkActor)this._client).isConnected()) {
                stop.run();
            } else if (((BaseClientApp)this._client).isConnectable()) {
                VTask.yield().await(() -> {
                    if (!((BaseClientApp)this._client).isConnectable()) {
                        stop.run();
                        return;
                    }
                    connectNext.run();
                });
            }
        };
        ((GameClientApp)this._client).ConnectionStateChanged.register((Runnable)mutHandler.Value);
        connectNext.run();
        return true;
    }

    @Override
    public boolean tryConnectTo(IpPortBase target) {
        if (!((BaseClientApp)this._client).isConnectable()) {
            return false;
        }
        ((BaseClientApp)this._client).connect(target instanceof IpPort ? (IpPort)target : ((IpPortOptional)target).withFallbackPort(this.getProtocol().getDefaultPort()));
        return true;
    }

    @Override
    public boolean isCompatible(String version) {
        return this.getVersion().equals(version);
    }

    @Override
    public ImageIcon getServerBrowserIcon(int nr) {
        if (nr >= 0 && nr < this._serverBrowserIcons.length) {
            return this._serverBrowserIcons[nr];
        }
        return null;
    }

    public String translateDisconnectReason(TextWithArguments reason) {
        return this.Localizer.translate("_DisconnectReason_" + reason.Text, reason.Args);
    }

    protected String getForceHeadlessCheckResourcePath() {
        return "/res/ioengine/images/serverbrowser.png";
    }

    @Override
    protected boolean skipLoadMedia() {
        return this._headless;
    }

    protected boolean isProbablyHeadless() {
        String res = this.getForceHeadlessCheckResourcePath();
        return res != null && !MiscIO.resourceExists(res);
    }

    @Override
    protected void parseArguments(List<String> cmds) {
        String connectTo;
        super.parseArguments(cmds);
        if (cmds.contains("-dedicated") || cmds.contains("-dedi")) {
            this._dedicated = true;
            if (!this.hasNonHeadlessDedicated()) {
                this._headless = true;
            }
        }
        for (String cmd : cmds) {
            if (cmd.startsWith("-dedi:")) {
                this._headlessModeConfigSuffix = cmd.substring("-dedi:".length());
                this._dedicated = true;
                if (this.hasNonHeadlessDedicated()) continue;
                this._headless = true;
                continue;
            }
            if (!cmd.startsWith("-dedicated:")) continue;
            this._headlessModeConfigSuffix = cmd.substring("-dedicated:".length());
            this._dedicated = true;
            if (this.hasNonHeadlessDedicated()) continue;
            this._headless = true;
        }
        if (cmds.contains("-console") || cmds.contains("-headless")) {
            this._headless = true;
        }
        if (!this._headless && this.isProbablyHeadless()) {
            this._headless = true;
        }
        if (this._headless && !this.hasHeadlessClient()) {
            this._dedicated = true;
        }
        if ((connectTo = Misc.tryGetNextCmdArg(cmds, "-connect")) != null) {
            this._launchConnect = IpPortOptional.tryParse(connectTo);
        }
    }

    @Override
    protected void addLocalizationPaths(LocalizationParser parser) {
        super.addLocalizationPaths(parser);
        parser.addTextsPropDB(new Resource("/res/ioengine/text/"), "languages_network.txt");
    }

    @Override
    protected void onUpdateFound(String newVersion, String otherData) {
        Log.App.info("*******************");
        Log.App.info(" Update available! ");
        Log.App.info(" " + newVersion);
        Log.App.info("*******************");
        if (!this.isHeadless()) {
            ((GameUI)((GameState)((ClientApp)this._client).getAppState()).getUI()).onUpdateFound(newVersion, otherData);
        }
    }

    protected void initializeServer() {
        ((BaseServerApp)this._server).initialize();
        GameData data = (GameData)((ServerApp)this._server).getData();
        data.setOpenGame(((NetGameSettings)this.Settings).OpenGame);
        data.setMaxPlayers(((NetGameSettings)this.Settings).Maxplayers);
    }

    public final void startServerAndConnectDirect(boolean network, char hostPort, boolean announceLAN, boolean announceInternet, Character udpPort, boolean dedicated, String serverName) {
        this.initializeServer();
        this.startServerAndConnect(network, hostPort, announceLAN, announceInternet, udpPort, dedicated, serverName);
    }

    protected final void startServerAndConnect(boolean network, char hostPort, boolean announceLAN, boolean announceInternet, Character udpPort, boolean dedicated, String serverName) {
        if (network) {
            ((NetGameSettings)this.Settings).setHostOptions(hostPort, announceLAN, announceInternet, udpPort);
        }
        ((BaseServerApp)this._server).setNetwork(network);
        ((GameServerApp)this._server).setAnnounce(announceLAN, announceInternet, udpPort);
        ((BaseServerApp)this._server).setDedicated(dedicated);
        ((GameServerApp)this._server).setName(serverName);
        ((BaseServerApp)this._server).setPort(hostPort);
        if (dedicated) {
            ((BaseServerApp)this._server).start();
        } else {
            StreamPair lc = ((BaseClientApp)this._client).connectToSelf();
            ((BaseServerApp)this._server).start();
            ((BaseServerApp)this._server).connectLocal(lc);
        }
    }

    protected boolean hasNonHeadlessDedicated() {
        return false;
    }

    protected boolean hasHeadlessClient() {
        return false;
    }

    public boolean isDedicated() {
        return this._dedicated;
    }

    public boolean isHeadless() {
        return this._headless;
    }

    @Override
    protected TSettings createSettings() {
        return (TSettings)new NetGameSettings();
    }

    protected HeadlessMode<? extends NetworkGame<C, S, P, TSettings>, S, ? extends GameDedicatedInfo> createHeadlessMode() {
        return new HeadlessMode();
    }

    protected abstract C createClient();

    protected abstract S createServer();

    public C getClient() {
        return this._client;
    }

    public S getServer() {
        return this._server;
    }

    @Override
    protected void onFatalError(Throwable ex) {
        if (!this.isHeadless()) {
            this.onFatalErrorUI(ex);
        }
    }

    protected void onFatalErrorUI(Throwable ex) {
        Object ui;
        GameState as;
        if (this._client != null && (as = (GameState)((ClientApp)this._client).getAppState()) != null && (ui = as.getUI()) != null) {
            ((GameUI)ui).onError(ex);
        }
    }

    @Override
    protected void onStop() {
        super.onStop();
        if (this._server != null) {
            try {
                ((BaseServerApp)this._server).tryStop();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (this._client != null) {
            try {
                ((BaseClientApp)this._client).shutdown();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (this._headlessMode != null) {
            this._headlessMode.onServerExit();
        }
    }

    @Override
    protected final VTask doShutDownAsync() {
        return Async.awaitAll(true, VTask.delay(1.0), this.doShutDownGameAsync());
    }

    protected VTask doShutDownGameAsync() {
        return super.doShutDownAsync();
    }

    public String getGameName() {
        return this.getName();
    }

    public void addDediChat(String str) {
        if (this.isHeadless()) {
            this._headlessMode.addDediChat(str);
        } else {
            ((GameUI)((GameState)((ClientApp)this._client).getAppState()).getUI()).addDediChat(str);
        }
    }

    @Override
    public List<ServerDataDto> getFavoritesServers() {
        return ((NetGameSettings)this.Settings).Favorites;
    }

    @Override
    public void setFavoritesServers(List<ServerDataDto> favorites) {
        ((NetGameSettings)this.Settings).Favorites = favorites;
        ((NetGameSettings)this.Settings).save();
    }

    @Override
    public Localizer getLocalizer() {
        return this.Localizer;
    }

    @Override
    public IpVersion getPreferredIpVersion() {
        return ((NetGameSettings)this.Settings).getPreferredIpVersion();
    }

    protected boolean canLaunchConnect() {
        return this._hasLoaded;
    }

    public void canLaunchConnectNow() {
        this._hasLoaded = true;
        this.checkLaunchConnect();
    }

    public void checkLaunchConnect() {
        if (this._launchConnect != null && this.canLaunchConnect() && this.tryConnectTo(this._launchConnect)) {
            this._launchConnect = null;
        }
    }

    public String getHeadlessModeConfigSuffix() {
        return this._headlessModeConfigSuffix;
    }
}

