/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.ioengine.game;

import com.iosoft.helpers.Misc;
import com.iosoft.helpers.network.IpPort;
import com.iosoft.helpers.network.util.IpVersion;
import com.iosoft.ioengine.serverbrowser.client.ServerDataDto;
import com.iosoft.iogame.GameSettings;
import com.iosoft.iogame.saveload.IKVNode;
import com.iosoft.iogame.saveload.IKVRW;
import com.iosoft.iogame.saveload.IKVRead;
import com.iosoft.iogame.saveload.IKVWrite;
import java.util.ArrayList;
import java.util.List;

public class NetGameSettings
extends GameSettings {
    protected static final String S_LastJoinTarget = "lastJoinTarget";
    protected static final String S_Favorites = "favorites";
    protected static final String S_Fav_IP = "ip";
    protected static final String S_Fav_Port = "port";
    public IpPort LastJoinTarget;
    public char HostPort;
    public Character AnnounceInternetPort;
    public int Maxplayers;
    public boolean OpenGame = true;
    public boolean AnnounceLAN = true;
    public boolean AnnounceInternet = true;
    public List<ServerDataDto> Favorites = new ArrayList<ServerDataDto>();
    protected boolean _allowOpenStart;
    protected IpVersion _preferredIpVersion = IpVersion.Unknown;
    private IpPort _defaultJoinTarget;
    private char _defaultPort;
    private String _headlessModeConfigSuffix;

    public void initNet(char defaultPort, String headlessModeConfigSuffix) {
        this._defaultPort = defaultPort;
        this.LastJoinTarget = this._defaultJoinTarget = new IpPort("127.0.0.1", defaultPort);
        this._headlessModeConfigSuffix = headlessModeConfigSuffix;
        this.HostPort = defaultPort;
        this.Maxplayers = this.getDefaultMaxplayers();
    }

    public IKVNode getHeadlessNode() {
        return this._root.getSub("HeadlessConfig" + this._headlessModeConfigSuffix);
    }

    @Override
    protected void read(IKVRead kv) {
        super.read(kv);
        this._allowOpenStart = kv.getBool("allowOpenStart", this._allowOpenStart);
        this._preferredIpVersion = NetGameSettings.parseIpVersion(kv.getInt("preferIpVersion", 0));
        this.LastJoinTarget = IpPort.tryParse(kv.getString(S_LastJoinTarget, ""), this._defaultPort);
        if (this.LastJoinTarget == null) {
            this.LastJoinTarget = this._defaultJoinTarget;
        }
        kv.getArray(S_Favorites, (x, i) -> {
            String ip = x.tryGetString(S_Fav_IP);
            String portString = x.tryGetString(S_Fav_Port);
            if (!Misc.isNullOrEmpty(ip)) {
                this.Favorites.add(new ServerDataDto(ip, portString == null ? null : Misc.tryGetAsUShort(portString)));
            }
        });
    }

    @Override
    protected void write(IKVWrite kv) {
        super.write(kv);
        kv.setString(S_LastJoinTarget, this.LastJoinTarget.toString());
        kv.setArray(S_Favorites, this.Favorites, (node, item) -> {
            node.setString(S_Fav_IP, item.IP);
            if (item.Port != null) {
                node.setChar(S_Fav_Port, item.Port.charValue());
            }
        });
    }

    @Override
    protected void rw(IKVRW rw) {
        super.rw(rw);
        this.HostPort = rw.rwChar("hostPort", this.HostPort);
        this.AnnounceInternetPort = Character.valueOf(rw.rwChar("announceInternetPort", this.AnnounceInternetPort == null ? (char)'\u0000' : this.AnnounceInternetPort.charValue()));
        if (this.AnnounceInternetPort.charValue() == '\u0000') {
            this.AnnounceInternetPort = null;
        }
        this.Maxplayers = rw.rwInt("maxplayers", this.Maxplayers);
        this.OpenGame = rw.rwBool("openGame", this.OpenGame);
        this.AnnounceInternet = rw.rwBool("announceInternet", this.AnnounceInternet);
        this.AnnounceLAN = rw.rwBool("announceLAN", this.AnnounceLAN);
    }

    public boolean getAllowOpenStart() {
        return this._allowOpenStart;
    }

    public IpVersion getPreferredIpVersion() {
        return this._preferredIpVersion;
    }

    public void setMaxPlayers(int value) {
        if (this.Maxplayers != value) {
            this.Maxplayers = value;
            this.save();
        }
    }

    public void setOpenGame(boolean value) {
        if (this.OpenGame != value) {
            this.OpenGame = value;
            this.save();
        }
    }

    public void setHostOptions(char hostPort, boolean announceLAN, boolean announceInternet, Character udpPort) {
        this.HostPort = hostPort;
        this.AnnounceLAN = announceLAN;
        this.AnnounceInternet = announceInternet;
        this.AnnounceInternetPort = udpPort;
        this.save();
    }

    public void setJoinOptions(IpPort joinTarget) {
        this.LastJoinTarget = joinTarget;
        this.save();
    }

    public void setGameSettings(int players, boolean openGame) {
        if (this.Maxplayers == players && this.OpenGame == openGame) {
            return;
        }
        this.Maxplayers = players;
        this.OpenGame = openGame;
        this.save();
    }

    private static IpVersion parseIpVersion(int number) {
        switch (number) {
            case 1: 
            case 4: {
                return IpVersion.IpV4;
            }
            case 2: 
            case 6: {
                return IpVersion.IpV6;
            }
        }
        return IpVersion.Unknown;
    }

    protected char getDefaultPort() {
        return this._defaultPort;
    }

    protected int getDefaultMaxplayers() {
        return 5;
    }
}

