/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.ioengine.game;

import com.iosoft.helpers.Misc;
import com.iosoft.helpers.iter.SkippingIterator;
import com.iosoft.helpers.network.util.IpVersion;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;

public class IpAddressPair {
    public final Inet4Address IpV4;
    public final Inet6Address IpV6;

    public IpAddressPair(Inet4Address ipv4, Inet6Address ipv6) {
        this.IpV4 = Misc.notNull(ipv4);
        this.IpV6 = Misc.notNull(ipv6);
    }

    public Iterable<InetAddress> list(final IpVersion preferredIpVersion) {
        return () -> new SkippingIterator<InetAddress>(){
            int state = 0;

            @Override
            protected InetAddress findNextElement() {
                switch (this.state) {
                    case 0: {
                        this.state = 1;
                        return preferredIpVersion == IpVersion.IpV6 ? IpAddressPair.this.IpV6 : IpAddressPair.this.IpV4;
                    }
                    case 1: {
                        this.state = 2;
                        return preferredIpVersion == IpVersion.IpV6 ? IpAddressPair.this.IpV4 : IpAddressPair.this.IpV6;
                    }
                }
                this.onEndReached();
                return null;
            }
        };
    }
}

