/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.ioengine.game;

import com.iosoft.helpers.Misc;
import com.iosoft.helpers.async.VTask;
import com.iosoft.helpers.console.ConsoleReader;
import com.iosoft.helpers.web.ExternalIP;
import com.iosoft.ioengine.app.server.DedicatedInfo;
import com.iosoft.ioengine.app.server.ServerApp;
import com.iosoft.ioengine.base.server.BaseServerApp;
import com.iosoft.ioengine.game.NetGameSettings;
import com.iosoft.ioengine.game.NetworkGame;
import com.iosoft.ioengine.game.server.GameData;
import com.iosoft.ioengine.game.server.GameDedicatedInfo;
import com.iosoft.ioengine.game.server.GameServerApp;
import com.iosoft.iogame.ConsoleCommand;
import com.iosoft.iogame.Game;
import com.iosoft.iogame.saveload.IKVArray;
import com.iosoft.iogame.saveload.IKVNode;
import com.iosoft.iogame.saveload.IKVRead;
import com.iosoft.iogame.saveload.IKVReadItem;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;

public class HeadlessMode<T extends NetworkGame<?, S, ?, ?>, S extends GameServerApp, H extends GameDedicatedInfo> {
    protected String _serverName;
    protected String _ip;
    protected boolean _announceInet;
    protected boolean _announceLAN;
    protected char _port;
    protected Character _inetPort;
    protected String[] _args;
    protected T _game;
    protected S _server;
    private boolean _exited = false;
    private VTask _consoleTextReceiver;
    private VTask _taskIpGetter;

    public void setGame(T game) {
        this._game = game;
        this.init();
    }

    protected void init() {
        System.out.println("-------------------------------");
        System.out.println(this.getGameString());
        System.out.println("headless mode dedicated server");
        System.out.println("-------------------------------");
        System.out.println();
    }

    public void start() {
        this._server = ((NetworkGame)this._game).getServer();
        this.loadConfig();
    }

    protected String getGameString() {
        return String.valueOf(((Game)this._game).getName()) + " v" + ((Game)this._game).getVersion();
    }

    protected void loadConfig() {
        System.out.println("Loading config...");
        if (!this.loadIt()) {
            System.out.println("You need to enable the headless mode in your config file first. Please edit");
            System.out.println("\t" + ((Game)this._game).getSettingsProvider().getSettingsFile().getPath());
            System.out.println("with your text editor of choice.");
            this.tryExit();
        } else {
            System.out.println("Headless mode settings:\n");
            this.displayInfo();
            System.out.println();
            System.out.println();
            VTask.delay(1.0).await(this::startServer);
        }
    }

    protected void displayInfo() {
        System.out.println("\tConfig:\t\t" + ((NetworkGame)this._game).getHeadlessModeConfigSuffix());
        System.out.println("\tIP:\t\t" + (this._ip.isEmpty() ? "(default)" : this._ip));
        System.out.println("\tPort:\t\t" + this._port);
        System.out.println("\tName:\t\t" + this._serverName);
        System.out.println("\tInternet:\t" + (this._announceInet ? "Yes (UDP " + (this._inetPort == null ? "default" : "" + this._inetPort.charValue()) + ")" : "No"));
        System.out.println("\tLAN:\t\t" + (this._announceLAN ? "Yes" : "No"));
        System.out.println("\t#args:\t\t" + this._args.length);
    }

    private boolean loadIt() {
        Collection<IKVReadItem> argsArray;
        NetGameSettings settings = (NetGameSettings)((NetworkGame)this._game).Settings;
        IKVNode root = settings.getHeadlessNode();
        Boolean enabled = root.getBoolean("enabled", null);
        boolean save = false;
        if (enabled == null) {
            root.setBool("enabled", false);
            save = true;
        }
        if ((argsArray = root.tryGetArray("args")) == null) {
            Throwable throwable = null;
            Object var7_8 = null;
            try (IKVArray array = root.setArray("args");){
                array.addString("maxplayers " + ((NetGameSettings)((NetworkGame)this._game).Settings).getDefaultMaxplayers());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            save = true;
        }
        if (save) {
            settings.save();
        }
        if (enabled != Boolean.TRUE) {
            return false;
        }
        this._args = (String[])argsArray.stream().map(x -> x.getString(null)).filter(x -> x != null).toArray(String[]::new);
        this.loadSettings(root);
        return true;
    }

    protected void loadSettings(IKVRead root) {
        this._ip = root.getString("ip", "");
        this._port = root.getChar("port", ((NetworkGame)this._game).getProtocol().getDefaultPort());
        this._serverName = root.getString("serverName", String.valueOf(((Game)this._game).getName()) + " Server");
        this._inetPort = Character.valueOf(root.getChar("inetPort", '\u0000'));
        if (this._inetPort.charValue() == '\u0000') {
            this._inetPort = null;
        }
        this._announceInet = root.getBool("announceInet", true);
        this._announceLAN = root.getBool("announceLAN", false);
    }

    protected boolean configureServer() {
        ((BaseServerApp)this._server).initialize();
        try {
            ((BaseServerApp)this._server).setForceIP(this._ip.isEmpty() ? null : InetAddress.getByName(this._ip));
        }
        catch (UnknownHostException e) {
            System.out.println("ERROR: The address '" + this._ip + "' seems to be invalid. Leave this blank to use the default address.");
            return false;
        }
        ((BaseServerApp)this._server).setNetwork(true);
        ((GameServerApp)this._server).setAnnounce(this._announceLAN, this._announceInet, this._inetPort);
        ((BaseServerApp)this._server).setDedicated(true);
        ((GameServerApp)this._server).setName(this._serverName);
        ((BaseServerApp)this._server).setPort(this._port);
        ((GameData)((ServerApp)this._server).getData()).setOpenGame(true);
        ((GameServerApp)this._server).setStartArgs(this._args);
        return true;
    }

    protected void startServer() {
        System.out.println("Initializing server with specified options...");
        if (!this.configureServer()) {
            this.tryExit();
            return;
        }
        ((BaseServerApp)this._server).start();
        DedicatedInfo dedi = ((ServerApp)this._server).getDedicatedInfo();
        if (dedi.noNetwork) {
            System.out.println("ERROR: The server listener could not be started. The specified ip address or port might be invalid or already in use.");
            this.tryExit();
            return;
        }
        this._consoleTextReceiver = ConsoleReader.readAsync(line -> {
            if (((BaseServerApp)this._server).isRunning()) {
                this.processInput((String)line);
            }
        }).awaitAndContinue(ex -> {
            this._consoleTextReceiver = null;
            ex.printStackTrace();
            this.tryExit();
        });
    }

    protected void onServerExit() {
        if (this._consoleTextReceiver != null) {
            this._consoleTextReceiver.cancel();
            this._consoleTextReceiver = null;
        }
        this.tryExit();
    }

    protected void displayStatus(H info) {
        StringBuilder text = new StringBuilder();
        text.append("SERVER STATUS\n----------------\nServer name: " + ((GameDedicatedInfo)info).serverName + "\nPlayers: " + ((GameDedicatedInfo)info).connectedClients + " / " + ((GameDedicatedInfo)info).maxClients + " (+" + ((GameDedicatedInfo)info).numAIs + " AI) - Total: " + DedicatedInfo.time2String(((GameDedicatedInfo)info).time_running) + " - Current game: " + DedicatedInfo.time2String(((GameDedicatedInfo)info).time_sessionRunning) + "\n");
        if (((GameDedicatedInfo)info).noNetwork) {
            text.append("NETWORK COULD NOT BE STARTED, ADDRESS/PORT PROBABLY ALREADY IN USE OR INVALID!\n");
        }
        text.append("In progress: " + (((GameDedicatedInfo)info).inProgress ? "yes" : "no") + " | ");
        text.append("Open game: " + (((GameDedicatedInfo)info).open ? "yes" : "no") + "\n");
        this.displayGameStatus(text, info);
        text.append("State - Name - IP - Ping - Admin - Version\n");
        int iC = ((GameDedicatedInfo)info).clients.length;
        int i = 0;
        while (i < iC) {
            GameDedicatedInfo.GameClientSlot p = (GameDedicatedInfo.GameClientSlot)((GameDedicatedInfo)info).clients[i];
            if (p != null) {
                text.append(i + ": ");
                text.append(p.greeted ? "rdy" : "w4g");
                if (p.name != null) {
                    text.append(" - " + p.name + " - " + (p.ip == null ? "local" : p.ip) + " - " + p.ping + " - " + p.admin + " - " + p.version);
                }
                text.append("\n");
            }
            ++i;
        }
        System.out.println(text);
    }

    protected void displayGameStatus(StringBuilder text, H info) {
    }

    protected void cancelExternalIPTask() {
        if (this._taskIpGetter != null) {
            System.out.println("Cancelled external IP getter task.");
            this._taskIpGetter.cancel();
            this._taskIpGetter = null;
        }
    }

    protected void processInput(String line) {
        if (line.startsWith("cmd ")) {
            ((GameServerApp)this._server).processCommand(line.substring("cmd ".length()));
            return;
        }
        if (line.startsWith("say ")) {
            ((GameServerApp)this._server).onDedicatedInput(line.substring("say ".length()));
            return;
        }
        ConsoleCommand command = ConsoleCommand.parse(line);
        switch (command.Action) {
            case "ip": {
                this.cancelExternalIPTask();
                System.out.println("Looking up external IP address... (may take up to a minute)");
                this._taskIpGetter = ExternalIP.getAsync(true).awaitAndContinue(externalIp -> {
                    System.out.println("Best external IP: " + externalIp);
                    this._taskIpGetter = null;
                });
                break;
            }
            case "status": {
                this.displayStatus((GameDedicatedInfo)((ServerApp)this._server).getDedicatedInfo());
                break;
            }
            case "banlist": {
                InetAddress[] bans = ((BaseServerApp)this._server).getBanList();
                System.out.println(bans.length + " bans:");
                int i = 0;
                while (i < bans.length) {
                    System.out.println("\t" + i + "\t" + bans[i].toString());
                    ++i;
                }
                break;
            }
            case "ban": {
                InetAddress ip;
                if (command.Params.length <= 0 || (ip = HeadlessMode.tryGetIpAddress(command.Params[0])) == null) break;
                this.ban(ip);
                break;
            }
            case "kickban": {
                InetAddress ip;
                if (command.Params.length <= 0 || (ip = HeadlessMode.tryGetIpAddress(command.Params[0])) == null) break;
                ((BaseServerApp)this._server).kickIP(ip);
                this.ban(ip);
                break;
            }
            case "kick": {
                InetAddress ip;
                if (command.Params.length <= 0 || (ip = HeadlessMode.tryGetIpAddress(command.Params[0])) == null) break;
                ((BaseServerApp)this._server).kickIP(ip);
                break;
            }
            case "unban": {
                if (command.Params.length <= 0) break;
                String arg = command.Params[0];
                InetAddress[] bans = ((BaseServerApp)this._server).getBanList();
                if (arg.equals("all")) {
                    ((BaseServerApp)this._server).clearBanList();
                    System.out.println("Unbanned all " + bans.length + " IPs");
                    break;
                }
                int toUnban = Misc.getAsInt(arg);
                if (toUnban >= 0 && toUnban < bans.length) {
                    ((BaseServerApp)this._server).unban(bans[toUnban]);
                    System.out.println("Unbanned #" + toUnban + " (" + bans[toUnban] + ")");
                    break;
                }
                System.out.println("Cannot unban #" + toUnban);
                break;
            }
            case "info": {
                this.displayInfo();
                break;
            }
            case "help": {
                System.out.println("Commands:");
                System.out.println("\tsay - Broadcast a chat message");
                System.out.println("\tip - Find the external IP and print it");
                System.out.println("\tstatus - Query server status");
                System.out.println("\tinfo - Display launch info");
                System.out.println("\tkick - Kick the specified IP");
                System.out.println("\tban - Ban the specified IP");
                System.out.println("\tkickban - Ban and kick the specified IP");
                System.out.println("\tbanlist - Display bans");
                System.out.println("\tunban - Unban the specified number or 'all'");
                System.out.println("\thelp - This list");
                System.out.println("\texit / quit - Kill the server");
                break;
            }
            case "exit": 
            case "quit": {
                this.tryExit();
                break;
            }
            default: {
                System.out.println("Unknown command '" + command.Action + "'");
            }
        }
    }

    private void tryExit() {
        if (this._exited) {
            return;
        }
        this._exited = true;
        System.out.println("Stopping...");
        ((Game)this._game).shutDown();
        this.cancelExternalIPTask();
    }

    private static InetAddress tryGetIpAddress(String ipAddress) {
        if (ipAddress.isEmpty()) {
            return null;
        }
        try {
            return InetAddress.getByName(ipAddress);
        }
        catch (UnknownHostException e) {
            System.out.println("'" + ipAddress + "' is an invalid IP address!");
            return null;
        }
    }

    private void ban(InetAddress banIP) {
        if (((BaseServerApp)this._server).addBan(banIP)) {
            System.out.println("Added " + banIP + " to the banlist.");
        } else {
            System.out.println(banIP + " is already banned.");
        }
        ((BaseServerApp)this._server).kickIP(banIP);
    }

    public void addDediChat(String str) {
        System.out.println(str);
    }
}

