/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.ioengine.game;

import com.iosoft.helpers.Misc;
import com.iosoft.helpers.WrapException;
import com.iosoft.ioengine.app.AppProtocol;
import com.iosoft.ioengine.game.IpAddressPair;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ThreadLocalRandom;

public abstract class GameProtocol
extends AppProtocol {
    public static final String GeneralMasterServer = "https://para-welt.com/main/ayce/misc/generalserverbrowser.php";
    public static final int DISCONNECT_CUSTOM_KICK = 40;
    public static final int DISCONNECT_GAMEINPROGRESS = 41;
    public static final int DISCONNECT_TOOMANYLOCALPLAYERS = 42;
    public static final int DISCONNECT_WRONG_PASSWORD = 43;
    public static final byte C_MSG_GREETING = 10;
    public static final byte C_MSG_PASSWORD_RESPONSE = 13;
    public static final byte C_MSG_PINGANSWER = 111;
    public static final byte C_MSG_QUIT = 112;
    public static final byte C_MSG_CHAT = 113;
    public static final byte C_MSG_COMMAND = 114;
    public static final byte C_MSG_JOIN = 115;
    public static final byte S_MSG_GREETING = 10;
    public static final byte S_MSG_PINGREQUEST = 11;
    public static final byte S_MSG_DISCONNECT = 12;
    public static final byte S_MSG_CHAT = 13;
    public static final byte S_MSG_CONNECTING = 14;
    public static final byte S_MSG_ADDPLAYER = 15;
    public static final byte S_MSG_REMOVEPLAYER = 16;
    public static final byte S_MSG_SWAPSLOT = 17;
    public static final byte S_MSG_PLAYERUPDATE = 18;
    public static final byte S_MSG_SERVERUPDATE = 19;
    public static final byte S_MSG_COMMAND = 20;
    public static final byte S_MSG_NOJOIN = 21;
    public static final byte S_MSG_JOIN = 22;
    public static final byte S_MSG_START_BLOCK = 23;
    public static final byte S_MSG_END_BLOCK = 24;
    public static final byte S_MSG_PASSWORD_REQUEST = 25;
    public static final int SERVERUPDATE_MAXPLAYERS = 0;
    public static final int SERVERUPDATE_FLAGS = 1;
    public static final int SERVERUPDATE_NAME = 2;
    public static final int SERVERFLAG_OPEN = 1;
    public static final int SERVERFLAG_SINGLEPLAYER = 2;
    public static final int SLOT_STATE_FREE = 0;
    public static final int SLOT_STATE_CONNECTING = 1;
    public static final int SLOT_STATE_FULL = 2;
    public static final int SLOT_STATE_CLOSED = 3;
    public static final int PLAYERUPDATE_FLAGS = 0;
    public static final int PLAYERUPDATE_NAME = 1;
    public static final int PLAYERUPDATE_PING = 2;
    public static final int PLAYERFLAG_ADMIN = 1;
    public static final int PLAYERFLAG_AI = 2;
    public static final int PLAYERFLAG_READY = 4;
    public static final int PLAYERFLAG_LAGGING = 8;
    public static final int REASON_GENERIC = 0;
    public static final int REASON_KICK = 1;
    public static final int REASON_BAN = 2;
    public static final int REASON_PROTOCOL_ERROR = 3;
    public static final int REASON_TIMEOUT = 4;
    public static final int REASON_LEFT = 5;
    public static final int REASON_CONNECTION_LOST = 6;
    public static final int REASON_WRONG_VERSION = 7;
    public static final int REASON_CUSTOM_KICK = 8;
    public static final int REASON_OVERFLOW = 9;
    public static final int REASON_NOT_A_CLIENT = 10;
    public static final String C_CMD_MAXPLAYERS = "maxplayers ";
    public static final String C_CMD_OPENGAME = "opengame ";
    public static final String C_CMD_SERVERNAME = "servername ";
    public static final String C_CMD_PASSWORD = "password ";
    public static final int SLOT_SYSTEM = 255;
    protected final String _gameName;
    private final int _passwordHashLength = this.getPasswordHash(Misc.EMPTYBYTES, Misc.EMPTYBYTES, Misc.EMPTYBYTES).length;

    public GameProtocol(String gameName) {
        this._gameName = gameName;
    }

    public String getSBClientIdentify() {
        return String.valueOf(this._gameName) + " Request";
    }

    public String getSBServerIdentify() {
        return String.valueOf(this._gameName) + " Metadata";
    }

    public String getClientGreeting() {
        return String.valueOf(this._gameName) + " Client";
    }

    public String getServerGreeting() {
        return String.valueOf(this._gameName) + " Server";
    }

    public abstract int getMaxPlayers();

    public int getMaxPlayerNameLength() {
        return 16;
    }

    public int getMaxChatLength() {
        return 50;
    }

    @Override
    public String getMasterServerURL() {
        return GeneralMasterServer;
    }

    @Override
    protected IpAddressPair makeLANMulticastIPs() {
        try {
            int multicastNumber = this.getMulticastNumber() + 1;
            return new IpAddressPair((Inet4Address)InetAddress.getByName("239.228.228." + multicastNumber), (Inet6Address)InetAddress.getByName("FF02:0:0:0:0:0:0228:" + Integer.toHexString(multicastNumber)));
        }
        catch (UnknownHostException e) {
            throw new WrapException(e);
        }
    }

    protected int getMulticastNumber() {
        return 0;
    }

    public int getRandomPasswordSaltLength() {
        return 16;
    }

    public byte[] getRandomPasswordSalt() {
        byte[] bytes = new byte[this.getRandomPasswordSaltLength()];
        ThreadLocalRandom.current().nextBytes(bytes);
        return bytes;
    }

    public byte[] getPasswordBytes(String password) {
        return (String.valueOf(this._gameName) + " Password: " + password).getBytes(StandardCharsets.UTF_8);
    }

    public byte[] getPasswordHash(byte[] clientBytes, byte[] serverBytes, byte[] password) {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                baos.write(clientBytes);
                baos.write(serverBytes);
                baos.write(password);
                return Misc.sha256(baos.toByteArray());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new WrapException(e);
        }
    }

    public int getPasswordHashLength() {
        return this._passwordHashLength;
    }
}

