/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.ioengine.base.server;

import com.iosoft.helpers.Log;
import com.iosoft.helpers.Misc;
import com.iosoft.helpers.MiscLINQ;
import com.iosoft.helpers.Stopwatch;
import com.iosoft.helpers.WeirdException;
import com.iosoft.helpers.WrapException;
import com.iosoft.helpers.async.Ticker;
import com.iosoft.helpers.async.VTask;
import com.iosoft.helpers.io.DataHelper;
import com.iosoft.helpers.localizer.TextWithArguments;
import com.iosoft.helpers.network.StreamPair;
import com.iosoft.helpers.network.tcp.TcpConnection;
import com.iosoft.helpers.network.tcp.TcpListener;
import com.iosoft.helpers.network.tcp.TcpOptions;
import com.iosoft.helpers.network.util.NetworkMessage;
import com.iosoft.ioengine.base.NetworkActor;
import com.iosoft.ioengine.base.server.BaseClient;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;

public abstract class BaseServerApp<C extends BaseClient<? extends BaseServerApp<C>>> {
    protected final Set<InetAddress> bannedIPs = new HashSet<InetAddress>();
    protected final DataHelper Dh = new DataHelper();
    protected final DataOutputStream Net;
    private final Ticker ticker;
    private final TcpListener serverListener;
    protected InetAddress _hostAddress;
    protected final List<C> _clients;
    protected String serverName;
    protected long sw_start;
    protected boolean dedicated;
    protected boolean networkFailed;
    protected boolean stopping;
    protected char port;
    protected boolean running;
    protected boolean network;
    protected boolean networkStarted;
    protected boolean hasLaggers;
    private boolean empty;
    private boolean initialized;
    private double ticksPerSecond;
    private boolean _inTick;
    public volatile long ms_serverTickTime;
    public volatile long firstClientSentBytes;
    public volatile long firstClientSentPackets;

    public BaseServerApp() {
        this.Net = this.Dh.Stream;
        this._clients = new ArrayList<C>();
        this.empty = true;
        this.initialized = false;
        this.ticksPerSecond = 30.0;
        this.serverListener = new TcpListener(this::onConnectAsync);
        this.ticker = new Ticker("Server Ticker", this.getTicksPerSecond(), this::tick);
        this.setTicker();
    }

    private void tick() {
        long sw_tick = Stopwatch.start();
        if (this.wholeEngineStopped()) {
            this.ticker.stop();
            return;
        }
        if (this.running) {
            this.hasLaggers = false;
            Iterator<C> iter = this._clients.iterator();
            this._inTick = true;
            while (iter.hasNext()) {
                BaseClient client = (BaseClient)iter.next();
                client.clientTick(sw_tick);
                if (client.isFullyConnected() && client.needsTime()) {
                    this.hasLaggers = true;
                }
                if (!client.isUnconnected()) continue;
                iter.remove();
                this.checkEmpty();
            }
            this._inTick = false;
            this.serverTick();
            C localClient = this.tryGetLocalClient(false);
            this.firstClientSentBytes = localClient == null ? 0L : ((NetworkActor)localClient).getBytesSent();
            this.firstClientSentPackets = localClient == null ? 0L : ((NetworkActor)localClient).getPacketsSent();
        }
        this.ms_serverTickTime = Stopwatch.getMillis(sw_tick);
    }

    public C tryGetLocalClient(boolean mustBeFullyConnected) {
        BaseClient client = (BaseClient)MiscLINQ.firstOrDefault(this._clients);
        if (client != null && client.isLocalOwner() && (!mustBeFullyConnected || client.isFullyConnected())) {
            return (C)client;
        }
        return null;
    }

    private void setTicker() {
        this.ticker.AutoSyncSeconds = Math.max(2.0, 2.0 / this.ticksPerSecond);
        this.ticker.setTicksPerSecond(this.ticksPerSecond, 1.0 / this.ticksPerSecond);
    }

    public final double getTicksPerSecond() {
        return this.ticksPerSecond;
    }

    public int getSecondsInTicks(double seconds) {
        return (int)Math.ceil(seconds * this.ticksPerSecond);
    }

    public double getSecondsPerTick() {
        return 1.0 / this.ticksPerSecond;
    }

    public void setTicksPerSecond(double newTPS) {
        if (newTPS != this.ticksPerSecond) {
            this.ticksPerSecond = newTPS;
            this.setTicker();
        }
    }

    protected abstract boolean wholeEngineStopped();

    protected C tryFindClient(int slotId) {
        return (C)MiscLINQ.firstOrDefault(this._clients, x -> x.isConnected() && x.getSlotId() == slotId);
    }

    protected abstract void serverTick();

    public void setPort(char port) {
        this.port = port;
        if (this.isRunning() && this.networkStarted) {
            this.startNetwork();
        }
    }

    public int getPort() {
        return this.port;
    }

    public TcpOptions getTcpOptions() {
        return TcpOptions.Default.copy();
    }

    public void setBufferMessages(boolean buffer) {
        for (BaseClient c : this._clients) {
            if (!c.isFullyConnected()) continue;
            c.setSending(!buffer);
        }
    }

    public void flushMessages() {
        for (BaseClient c : this._clients) {
            if (!c.isFullyConnected() || c.isSending()) continue;
            c.flushMessages();
        }
    }

    private void deInit() {
        this.initialized = false;
    }

    public void tryStop() {
        if (this.isRunning()) {
            this.stop();
        } else {
            this.deInit();
        }
    }

    public void stop() {
        this.deInit();
        if (!this.running) {
            Log.Server.info("Not running");
            return;
        }
        this.running = false;
        this.stopping = true;
        Log.Server.info("Stopping server...");
        this.onStopping();
        this.serverListener.stop();
        this.ticker.stop();
        for (BaseClient client : new ArrayList<C>(this._clients)) {
            client.disconnect(new TextWithArguments("Serverstop", new Object[0]));
        }
        this.stopping = false;
    }

    protected void onStopping() {
    }

    public void setForceIP(InetAddress hostAddress) {
        this._hostAddress = hostAddress;
    }

    public boolean addBan(InetAddress addr) {
        return this.bannedIPs.add(addr);
    }

    public boolean unban(InetAddress addr) {
        return this.bannedIPs.remove(addr);
    }

    public InetAddress[] getBanList() {
        return this.bannedIPs.toArray(new InetAddress[this.bannedIPs.size()]);
    }

    public void clearBanList() {
        this.bannedIPs.clear();
    }

    public void kickIP(InetAddress ip) {
        if (ip == null) {
            return;
        }
        for (BaseClient client : MiscLINQ.iter(this.clients(false).filter(c -> ip.equals(c.tryGetIPAddr())))) {
            client.kick(this.bannedIPs.contains(ip));
        }
    }

    public void setNetwork(boolean network) {
        this.network = network;
    }

    public boolean getNetwork() {
        return this.network;
    }

    public void setDedicated(boolean dedicated) {
        this.dedicated = dedicated;
    }

    public void setName(String name) {
        this.serverName = name;
    }

    public String getName() {
        return this.serverName;
    }

    public void initialize() {
        if (this.running) {
            throw new IllegalStateException("Cannot start server, already running.");
        }
        this.serverInit();
        this.initialized = true;
    }

    protected abstract void serverInit();

    public void start() {
        if (this.running) {
            throw new IllegalStateException("Cannot start server, already running.");
        }
        if (!this.initialized) {
            throw new IllegalStateException("Must be initialized before starting");
        }
        this.sw_start = Stopwatch.start();
        this._clients.clear();
        this.empty = true;
        this.networkFailed = false;
        this.networkStarted = false;
        this.running = true;
        this.ticker.start();
        this.onServerStarted();
        if (this.isDedicated()) {
            this.networkMayNowStart();
        }
    }

    protected abstract int getMaxClients();

    protected void onServerStarted() {
        Log.Server.info(String.valueOf(this.isDedicated() ? "Dedicated server started" : "Server started") + ": '" + this.serverName + "' (" + (this.network ? String.valueOf(Misc.getLocalInetAddress().getHostAddress()) + ":" + this.port : "local only") + ")");
    }

    public void networkMayNowStart() {
        if (this.running && this.network && !this.networkStarted) {
            this.startNetwork();
        }
    }

    private void startNetwork() {
        this.serverListener.Options = this.getTcpOptions();
        if (!this.serverListener.tryStart(this._hostAddress, this.port)) {
            Log.Server.error("Listener could not be started!");
            this.networkFailed = true;
            this.onNetworkFailed();
        } else {
            this.networkStarted = true;
            Log.Server.info("Listener running on port " + this.port + ", nodelay=" + (this.serverListener.Options == null ? null : this.serverListener.Options.Nodelay));
            this.onNetworkStarted();
        }
    }

    protected abstract void onNetworkFailed();

    protected abstract void onNetworkStarted();

    public void connectLocal(StreamPair localConnection) {
        Misc.notNull(localConnection, "localConnection");
        if (!this.running) {
            localConnection.close();
            return;
        }
        Log.Server.info("LocalConnection accepted");
        C c = this.createClient();
        ((BaseClient)c).setLocalOwner(true);
        ((BaseClient)c).setSlot(0);
        ((NetworkActor)c).initialize();
        this.addClient(c);
        ((BaseClient)c).bind(localConnection);
        this.onSuccessfulConnect(c);
    }

    protected abstract C createClient();

    protected TextWithArguments canNotAddNewClientBecause(Socket socket) {
        if (this.bannedIPs.contains(socket.getInetAddress())) {
            return new TextWithArguments("Banned", new Object[0]);
        }
        if (this.tryGetFreeSlot() == -1) {
            return new TextWithArguments("Full", new Object[0]);
        }
        return this.canNotConnectBecause(socket);
    }

    protected abstract TextWithArguments canNotConnectBecause(Socket var1);

    protected abstract void onSuccessfulConnect(C var1);

    public void sendToAll(byte[] data) {
        if (!this.empty && this.isRunning()) {
            for (BaseClient c : this._clients) {
                if (!c.isFullyConnected()) continue;
                c.send(data);
            }
        }
    }

    public void sendToAll(NetworkMessage message) {
        if (this.empty) {
            return;
        }
        try {
            message.writeMessage(this.Net);
        }
        catch (IOException e) {
            throw new WrapException("?", e);
        }
        this.sendToAll(this.Dh.finish());
    }

    public void sendToAll(byte[] data, BaseClient<?> ... not) {
        List<BaseClient<?>> notList = Arrays.asList(not);
        for (BaseClient c : this._clients) {
            if (!c.isFullyConnected() || notList.contains(c)) continue;
            c.send(data);
        }
    }

    @Deprecated
    protected void sendToNonLagging(byte[] data, C exceptTo) {
        for (BaseClient c : this._clients) {
            if (!c.isFullyConnected() || c.needsTime() || c == exceptTo) continue;
            c.send(data);
        }
    }

    protected void checkEmpty() {
        this.empty = !this.clients(true).findAny().isPresent();
    }

    public Stream<C> clients(boolean fullyConnected) {
        return this._clients.stream().filter(fullyConnected ? NetworkActor::isFullyConnected : NetworkActor::isConnected);
    }

    public int getNumConnectedClients() {
        return (int)this.clients(true).count();
    }

    public boolean isEmpty() {
        return this.empty;
    }

    protected int tryGetFreeSlot() {
        int nextId = 0;
        for (BaseClient client : this._clients) {
            if (!client.isConnected()) continue;
            if (client.getSlotId() != nextId) {
                return nextId;
            }
            ++nextId;
        }
        if (nextId < this.getMaxClients()) {
            return nextId;
        }
        return -1;
    }

    private void addClient(C client) {
        if (this._inTick) {
            throw new IllegalStateException("Cannot add a client while iterating!");
        }
        this._clients.add(client);
        this._clients.sort(Comparator.comparingInt(BaseClient::getSlotId));
    }

    protected void removeClient(C c) {
        if (!this._inTick) {
            if (!this._clients.remove(c)) {
                throw new IllegalStateException("Something is wrong");
            }
            this.checkEmpty();
        }
    }

    private VTask onConnectAsync(Socket socket) {
        Log.Server.info(socket.getInetAddress() + " is connecting...");
        TextWithArguments cannotConnectReason = this.canNotAddNewClientBecause(socket);
        if (cannotConnectReason == null) {
            this.tryConnectingClient(socket);
        } else {
            byte[] message;
            Log.Server.info("But is refused (" + cannotConnectReason + ")");
            if (this.useDummyConnection() && (message = this.tryGetNoConnectReasonMsg(cannotConnectReason)) != null) {
                try {
                    Throwable throwable = null;
                    Object var5_7 = null;
                    try (TcpConnection connection = new TcpConnection(socket, null, null);){
                        connection.send(message);
                        connection.disconnect(1.0);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (WeirdException e) {
                    Misc.forceClose(socket);
                }
            } else {
                Misc.forceClose(socket);
            }
        }
        return VTask.COMPLETED_TASK;
    }

    private void tryConnectingClient(Socket socket) {
        int slot = this.tryGetFreeSlot();
        if (slot == -1) {
            throw new IllegalStateException("Client did not get a slot even though we should have checked beforehand!?");
        }
        C c = this.createClient();
        ((BaseClient)c).setSlot(slot);
        ((NetworkActor)c).initialize();
        try {
            ((BaseClient)c).bind(socket);
        }
        catch (WeirdException e) {
            Log.Server.warning("... but had a weird error (" + e + ")");
            return;
        }
        this.addClient(c);
        this.onSuccessfulConnect(c);
        this.checkEmpty();
    }

    protected boolean useDummyConnection() {
        return true;
    }

    protected abstract byte[] tryGetNoConnectReasonMsg(TextWithArguments var1);

    public boolean isNetwork() {
        return this.network;
    }

    public boolean isDedicated() {
        return this.dedicated;
    }

    public boolean isStopping() {
        return this.stopping;
    }

    public boolean isRunning() {
        return this.running;
    }
}

