/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.ioengine.base.server;

import com.iosoft.helpers.Log;
import com.iosoft.helpers.Misc;
import com.iosoft.helpers.Stopwatch;
import com.iosoft.helpers.WeirdException;
import com.iosoft.helpers.localizer.TextWithArguments;
import com.iosoft.helpers.network.IInetConnection;
import com.iosoft.helpers.network.StreamPair;
import com.iosoft.ioengine.AppProtocolException;
import com.iosoft.ioengine.base.NetworkActor;
import com.iosoft.ioengine.base.server.BaseServerApp;
import java.net.InetAddress;
import java.net.Socket;

public abstract class BaseClient<T extends BaseServerApp<?>>
extends NetworkActor {
    public final T Server;
    private boolean needsTime;
    private boolean local;
    private boolean localOwner;
    protected int _ping;
    private int _slotId = -1;
    protected Long sw_ping;
    protected long _swTimeout;
    protected long _swNextPing;

    public BaseClient(T server) {
        this.Server = server;
        this.connectionState = NetworkActor.ConnectionState.WAIT_FOR_GREETING;
    }

    protected void setSlot(int slotId) {
        this._slotId = slotId;
    }

    protected double getTimeoutSecondsGreeting() {
        return 10.0;
    }

    protected double getTimeoutSecondsMsgs() {
        return 30.0;
    }

    protected double getTimeoutSecondsNextPing() {
        return 1.0;
    }

    public void bind(Socket socket) throws WeirdException {
        this.initializeTcpConnection(socket);
        this.initPost(false);
    }

    public void bind(StreamPair streamPair) {
        this.initializeLocalConnection(streamPair);
        this.initPost(true);
    }

    public String getName() {
        return "Client #" + this.getSlotId();
    }

    public boolean isLocal() {
        return this.local;
    }

    public boolean isLocalOwner() {
        return this.localOwner;
    }

    protected void setLocalOwner(boolean locow) {
        this.localOwner = locow;
    }

    public int getSlotId() {
        return this._slotId;
    }

    public InetAddress tryGetIPAddr() {
        return this._connection instanceof IInetConnection ? ((IInetConnection)this._connection).getRemoteAddress() : null;
    }

    private void initPost(boolean isLocal) {
        this._ping = -1;
        this.setTimeout(Stopwatch.start(), this.getTimeoutSecondsGreeting());
        this.local = isLocal;
        this.init();
    }

    protected void setTimeout(long swNow, double seconds) {
        this._swTimeout = swNow + Stopwatch.fromSeconds(seconds);
    }

    protected abstract void init();

    protected void clientTick(long swNow) {
        boolean neededTime = this.needsTime;
        if (!this.checkTimeout(swNow)) {
            if (!this.isLocal()) {
                this.disconnect("Timeout");
                return;
            }
            this.getLogCategory().error("Local client would time out now. Fix your code!");
        }
        if (this.connectionState == NetworkActor.ConnectionState.READY) {
            this.needsTime = !this.checkPing(swNow);
        }
        this.networkTick();
        if (this.connectionState == NetworkActor.ConnectionState.READY && this.needsTime != neededTime) {
            this.onLagging(this.needsTime);
        }
    }

    protected void onLagging(boolean lagging) {
    }

    public boolean needsTime() {
        return this.needsTime;
    }

    private boolean checkTimeout(long swNow) {
        return this._swTimeout > swNow;
    }

    private boolean checkPing(long swNow) {
        if (this._swNextPing > swNow) {
            return true;
        }
        if (this.sw_ping != null) {
            return false;
        }
        this.sw_ping = swNow;
        this.setNextPing(swNow);
        this.send(this.msgPingRequest());
        return true;
    }

    private void setNextPing(long swNow) {
        this._swNextPing = swNow + Stopwatch.fromSeconds(this.getTimeoutSecondsNextPing());
    }

    public void kick(boolean banned) {
        this.disconnect(new TextWithArguments(banned ? "Banned" : "Kicked", new Object[0]));
    }

    public char getPing() {
        return (char)Misc.clamp(this._ping, 0, 65535);
    }

    @Override
    protected void handleDisconnecting(TextWithArguments reason) {
        ((BaseServerApp)this.Server).removeClient((BaseClient)this);
        super.handleDisconnecting(reason);
    }

    protected abstract byte[] msgPingRequest();

    protected void onPingAnswer() throws AppProtocolException {
        if (this.sw_ping == null) {
            throw new AppProtocolException("Client " + this.getSlotId() + " sent pinganswer without previous request.");
        }
        long swNow = Stopwatch.start();
        this.setTimeout(swNow, this.getTimeoutSecondsMsgs());
        int ping = (int)Stopwatch.getMillis(this.sw_ping, swNow);
        this.sw_ping = null;
        this.setNextPing(swNow);
        this.onPing(ping);
    }

    protected void onGreetingReceived() {
        this.connectionState = NetworkActor.ConnectionState.READY;
        this.setTimeout(Stopwatch.start(), this.getTimeoutSecondsMsgs());
        ((BaseServerApp)this.Server).checkEmpty();
    }

    protected void onPing(int newPing) {
        if (this._ping != newPing) {
            this._ping = newPing;
            this.onNewPing();
        }
    }

    protected abstract void onNewPing();

    @Override
    protected String getNetworkName() {
        InetAddress inetAddress = this.tryGetIPAddr();
        return String.valueOf(this.getName()) + " (" + this.getSlotId() + " | " + (inetAddress == null ? "local" : inetAddress) + ")";
    }

    @Override
    protected String getPeerName() {
        return this.getNetworkName();
    }

    @Override
    protected String getPrefix() {
        return "SrvClient " + this.getSlotId();
    }

    @Override
    protected Log.Category getLogCategory() {
        return Log.Server;
    }
}

