/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.ioengine.base.client;

import com.iosoft.helpers.Log;
import com.iosoft.helpers.Misc;
import com.iosoft.helpers.Stopwatch;
import com.iosoft.helpers.WeirdException;
import com.iosoft.helpers.WrapException;
import com.iosoft.helpers.async.Task;
import com.iosoft.helpers.async.TaskBase;
import com.iosoft.helpers.async.Ticker;
import com.iosoft.helpers.event.Event;
import com.iosoft.helpers.event.EventSource;
import com.iosoft.helpers.io.DataHelper;
import com.iosoft.helpers.localizer.TextWithArguments;
import com.iosoft.helpers.network.IpPort;
import com.iosoft.helpers.network.LocalConnection;
import com.iosoft.helpers.network.StreamPair;
import com.iosoft.helpers.network.tcp.TcpConnecter;
import com.iosoft.helpers.network.tcp.TcpOptions;
import com.iosoft.ioengine.base.NetworkActor;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.UnknownHostException;

public abstract class BaseClientApp
extends NetworkActor {
    public static final String CONNECTING_FAILED = "ConnectingFailed";
    public static final String CONNECT_ARGUMENTS = "InvalidConnectArguments";
    public static final String UNKNOWN_HOST = "UnknownHost";
    public static final String NETWORK_FAILED = "NetworkFail";
    public static final String UNKNOWN_SERVER_REASON = "UnknownServerReason";
    public static final String CANCELLED = "Cancelled";
    public static final String GENERIC = "Generic";
    private final DataHelper Dh = new DataHelper();
    protected final DataOutputStream Net;
    protected final Ticker ticker;
    protected TaskBase<?> _connecter;
    protected long _swTimeout;
    private final EventSource _connectionStateChanged;
    public final Event ConnectionStateChanged;

    protected BaseClientApp() {
        this.Net = this.Dh.Stream;
        this._connectionStateChanged = new EventSource();
        this.ConnectionStateChanged = (Event)this._connectionStateChanged.Event;
        this.connectionState = NetworkActor.ConnectionState.NOT_CONNECTED;
        this.ticker = new Ticker("Client Ticker", this.getTicksPerSecond(), this::tick);
        this.ticker.AutoSyncSeconds = Math.max(1.0, 2.0 / (double)this.getTicksPerSecond());
    }

    private void tick() {
        if (this.wholeEngineStopped()) {
            this.ticker.stop();
            return;
        }
        this.onTick(Stopwatch.start());
    }

    protected double getTimeoutGreetingSeconds() {
        return 10.0;
    }

    protected double getTimeoutMessagesSeconds() {
        return 30.0;
    }

    protected int getTicksPerSecond() {
        return 60;
    }

    protected void onTick(long swNow) {
        if (this.connectionState == NetworkActor.ConnectionState.WAIT_FOR_GREETING || this.connectionState == NetworkActor.ConnectionState.READY) {
            if (swNow > this._swTimeout && !(this._connection instanceof LocalConnection)) {
                this.getLogCategory().info("Server timed out");
                this.disconnect("Timeout");
            } else {
                this.networkTick();
            }
        }
    }

    protected abstract boolean wholeEngineStopped();

    public void doInit() {
        this.init();
        this.reset();
    }

    public void onImportantLoaded() {
        this.ticker.start();
    }

    protected void init() {
    }

    protected void reset() {
        this._connection = null;
        this._connecter = null;
    }

    public boolean isConnectable() {
        return this.isUnconnected() && !this.isConnecting();
    }

    public boolean isConnecting() {
        return this._connecter != null;
    }

    protected void doConnectStuff() {
        if (this.isConnected()) {
            throw new IllegalStateException("Already connected");
        }
        if (this.isConnecting()) {
            throw new IllegalStateException("Already connecting");
        }
        this.reset();
    }

    public StreamPair connectToSelf() {
        this.doConnectStuff();
        this.getLogCategory().info("Connecting to local server...");
        try {
            PipedOutputStream out = new PipedOutputStream();
            PipedInputStream in = new PipedInputStream();
            StreamPair locConClient = new StreamPair(out, in);
            PipedOutputStream serverOut = new PipedOutputStream(in);
            PipedInputStream serverIn = new PipedInputStream(out);
            this.initializeLocalConnection(locConClient);
            StreamPair locConServer = new StreamPair(serverOut, serverIn);
            this.onConnected();
            return locConServer;
        }
        catch (IOException e) {
            throw new WrapException(e);
        }
    }

    public void connect(SocketAddress address) {
        Misc.notNull(address);
        this.doConnectStuff();
        this.reset();
        this.doConnect(address);
    }

    public void connect(IpPort target) {
        Misc.notNull(target);
        this.doConnectStuff();
        this.getLogCategory().info("Resolving '" + target.IpAddress + "' ...");
        this.onResolving(target);
        this._connecter = TcpConnecter.resolveAddressAsync(target.IpAddress).awaitAndContinue(result -> {
            this._connecter = null;
            if (result.Exception != null) {
                this.onConnectFailed((Exception)result.Exception);
            } else {
                this.doConnect(new InetSocketAddress((InetAddress)result.Value, (int)ipPort.Port));
            }
        });
        this._connectionStateChanged.fire();
    }

    protected TcpOptions getTcpOptions() {
        return TcpOptions.Default.copy();
    }

    protected void doConnect(SocketAddress address) {
        this.getLogCategory().info("Connecting to " + address.toString() + " ...");
        Task<TcpConnecter.Result> connecter = TcpConnecter.connectAsync(address, this.getTcpOptions());
        this._connecter = connecter;
        this.onConnecting(address);
        connecter.awaitAndContinue(result -> {
            this._connecter = null;
            if (result.Exception != null) {
                this.onConnectFailed((Exception)result.Exception);
            } else {
                try {
                    this.initializeTcpConnection((Socket)result.Value);
                    this.onConnected();
                }
                catch (WeirdException e) {
                    this.onConnectFailed(e);
                }
            }
        });
    }

    public void abortConnect() {
        if (this._connecter == null) {
            if (this.isUnconnected()) {
                throw new IllegalStateException("Not connecting!");
            }
            this.disconnect(CANCELLED);
        } else {
            this._connecter.cancel();
            this._connecter = null;
            this.onConnectFailed(null);
            this._connectionStateChanged.fire();
        }
    }

    protected void onConnectFailed(Exception exception) {
        this.onDisconnecting(this.getConnectFailedReason(exception));
    }

    protected TextWithArguments getConnectFailedReason(Exception exception) {
        if (exception == null) {
            this.getLogCategory().info("User cancelled the connecting.");
            return new TextWithArguments(CANCELLED, new Object[0]);
        }
        this.getLogCategory().info("Could not connect: " + exception);
        if (exception instanceof UnknownHostException) {
            return new TextWithArguments(UNKNOWN_HOST, exception);
        }
        if (exception instanceof IllegalArgumentException) {
            return new TextWithArguments(CONNECT_ARGUMENTS, exception);
        }
        return new TextWithArguments(CONNECTING_FAILED, exception);
    }

    protected void onConnected() {
        this.connectionState = NetworkActor.ConnectionState.WAIT_FOR_GREETING;
        this.setTimeout(this.getTimeoutGreetingSeconds());
        this._connectionStateChanged.fire();
    }

    protected void setTimeout(double seconds) {
        this._swTimeout = Stopwatch.start() + Stopwatch.fromSeconds(seconds);
    }

    protected abstract void onResolving(IpPort var1);

    protected abstract void onConnecting(SocketAddress var1);

    protected void send() {
        this.send(this.Dh.finish());
    }

    public void quit() {
        this.userDisconnect("Quit");
    }

    public void disconnect() {
        this.userDisconnect(GENERIC);
    }

    protected void userDisconnect(String reason) {
        if (this._connecter != null) {
            this.abortConnect();
            return;
        }
        if (this.isUnconnected()) {
            this.getLogCategory().info("Not connected.");
            return;
        }
        this.disconnect(reason);
    }

    @Override
    protected String getNetworkName() {
        return "Client";
    }

    protected void onDisconnecting(TextWithArguments reason) {
        if (reason.Text == "Quit") {
            this.sendQuitMessage();
        }
        this._connectionStateChanged.fire();
    }

    @Override
    protected void handleDisconnecting(TextWithArguments reason) {
        this.onDisconnecting(reason);
        super.handleDisconnecting(reason);
    }

    @Override
    protected byte[] tryGetDisconnectedMessage(TextWithArguments reason) {
        return (byte[])(reason.Text == "Quit" ? Misc.EMPTYBYTES : null);
    }

    protected void onGreetingReceived() {
        this.setTimeout(this.getTimeoutMessagesSeconds());
        this.connectionState = NetworkActor.ConnectionState.READY;
        this._connectionStateChanged.fire();
    }

    protected abstract void sendQuitMessage();

    @Override
    protected String getPeerName() {
        return "Server";
    }

    @Override
    protected String getPrefix() {
        return "Client";
    }

    @Override
    protected Log.Category getLogCategory() {
        return Log.Client;
    }

    public void shutdown() {
        if (this.isConnected()) {
            this.quit();
        }
        this.ticker.stop();
    }
}

