/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.ioengine.base;

import com.iosoft.helpers.Log;
import com.iosoft.helpers.Misc;
import com.iosoft.helpers.ThrowingConsumer;
import com.iosoft.helpers.UnexpectedIOException;
import com.iosoft.helpers.WeirdException;
import com.iosoft.helpers.WrapException;
import com.iosoft.helpers.io.MiscIO;
import com.iosoft.helpers.localizer.TextWithArguments;
import com.iosoft.helpers.network.IConnection;
import com.iosoft.helpers.network.LocalConnection;
import com.iosoft.helpers.network.ReceiverHelper;
import com.iosoft.helpers.network.ReceivingCallback;
import com.iosoft.helpers.network.ReceivingFunction;
import com.iosoft.helpers.network.StreamPair;
import com.iosoft.helpers.network.lag.LagConnection;
import com.iosoft.helpers.network.lag.LagInetConnection;
import com.iosoft.helpers.network.tcp.TcpConnection;
import com.iosoft.helpers.network.util.NetworkMessage;
import com.iosoft.helpers.network.util.NetworkMessageHandler;
import com.iosoft.ioengine.AppProtocolException;
import com.iosoft.ioengine.base.IMessage;
import com.iosoft.ioengine.game.client.ReceivingFunctionStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.net.Socket;
import java.util.function.Consumer;
import java.util.function.Supplier;

public abstract class NetworkActor {
    public static final String TIMEOUT = "Timeout";
    public static final String PROTOCOL_ERROR = "Protocol";
    public static final String PROTOCOL_ERROR_EARLY = "Not_A_Peer";
    public static final String CONNECTION_LOST = "ConnectionLost";
    public static final String KICKED = "Kicked";
    public static final String BANNED = "Banned";
    public static final String WRONG_VERSION = "Version";
    public static final String QUIT = "Quit";
    public static final String FULL = "Full";
    public static final String OVERFLOW = "Overflow";
    public static final String SERVERSTOP = "Serverstop";
    protected IConnection _connection;
    protected ConnectionState connectionState;
    protected int maxBuffer;
    private ReceivingCallback receivingCallback;
    private final NetworkMessageHandler messageHandler = new NetworkMessageHandler();
    public boolean UseLagTest = false;
    public double LagReceiveSeconds = 0.0;
    public double LagReceiveSecondsRandom = 0.0;
    public double LagSendSeconds = 0.0;
    public double LagSendSecondsRandom = 0.0;
    private boolean greeted;

    public void initialize() {
        this.maxBuffer = this.getMaxBuffer();
        this.registerUngreetedMessages();
        this.messageHandler.StateChecker = x -> this.checkGreeted();
        this.registerMessages();
        this.receivingCallback = this.messageHandler.createReceivingCallback(true);
    }

    public boolean trySetLagTestActive(boolean active) {
        this.UseLagTest = active;
        return this._connection == null || this._connection instanceof LagConnection || !active;
    }

    protected void util_checkSignature(DataInputStream in, String signature) throws IOException {
        this.checkNotGreeted();
        NetworkActor.readSignature(in, signature);
    }

    public static void readSignature(DataInputStream in, String signature) throws IOException {
        String sentSignature = MiscIO.readString(in, signature.length());
        if (!sentSignature.equals(signature)) {
            sentSignature = Misc.sanitizeName(sentSignature);
            throw new AppProtocolException("Received signature '" + sentSignature + "' instead of '" + signature + "'");
        }
    }

    public static void writeSignature(DataOutputStream out, String signature) throws IOException {
        MiscIO.writeCString(out, signature);
    }

    protected void networkTick() {
        int bufferSize;
        if (this._connection instanceof LagConnection) {
            this.setLagOptions((LagConnection)this._connection);
        }
        if ((bufferSize = this._connection.getBufferSize()) > this.maxBuffer) {
            this.getLogCategory().info(String.valueOf(this.getPeerName()) + " exceeded max buffer size " + this.maxBuffer + ", they had " + bufferSize);
            this.disconnect(OVERFLOW);
        }
    }

    private void setLagOptions(LagConnection<?> lagConnection) {
        lagConnection.LagReceiveSeconds = this.LagReceiveSeconds;
        lagConnection.LagReceiveSecondsRandom = this.LagReceiveSecondsRandom;
        lagConnection.LagSendSeconds = this.LagSendSeconds;
        lagConnection.LagSendSecondsRandom = this.LagSendSecondsRandom;
    }

    public void send(byte[] data) {
        this._connection.send(data);
    }

    public void send(NetworkMessage message) {
        this.send(this.messageHandler.write(message));
    }

    protected int getMaxBuffer() {
        return 0x100000;
    }

    public long getBytesSent() {
        return this._connection.getBytesSent();
    }

    public long getPacketsSent() {
        return this._connection.getPacketsSent();
    }

    protected void checkNotGreeted() throws AppProtocolException {
        if (this.greeted) {
            throw new AppProtocolException(String.valueOf(this.getPeerName()) + " sent greeting but has greeted already!");
        }
        this.greeted = true;
    }

    protected void checkGreeted() throws AppProtocolException {
        if (!this.greeted) {
            throw new AppProtocolException(String.valueOf(this.getPeerName()) + " sent a message but hasn't greeted yet!");
        }
    }

    protected abstract String getNetworkName();

    protected abstract String getPeerName();

    protected abstract Log.Category getLogCategory();

    private static boolean isUnusualError(Exception ex) {
        return ex != null && !(ex instanceof IOException);
    }

    private void onConnectionDisconnected(Exception ex) {
        Throwable cause;
        if (this.isUnconnected()) {
            return;
        }
        if (ex instanceof WrapException && (cause = ex.getCause()) instanceof Exception) {
            ex = (Exception)cause;
        }
        if (NetworkActor.isUnusualError(ex)) {
            throw new WrapException(ex);
        }
        this.internalDisconnect(new TextWithArguments(CONNECTION_LOST, ex == null ? "" : ex));
    }

    protected void initializeLocalConnection(StreamPair streamPair) {
        this.preConnection();
        if (this.UseLagTest) {
            LagConnection<LocalConnection> lagConnection = new LagConnection<LocalConnection>(this::doReceiving);
            this.setLagOptions(lagConnection);
            LocalConnection connection = new LocalConnection(streamPair, lagConnection::delayedReceivingCallback, this.getPrefix());
            lagConnection.initialize(connection);
            this.prepareConnection(lagConnection);
        } else {
            this.prepareConnection(new LocalConnection(streamPair, this::doReceiving, this.getPrefix()));
        }
    }

    protected void initializeTcpConnection(Socket socket) throws WeirdException {
        this.preConnection();
        if (this.UseLagTest) {
            LagInetConnection lagConnection = new LagInetConnection(this::doReceiving);
            this.setLagOptions(lagConnection);
            TcpConnection connection = new TcpConnection(socket, lagConnection::delayedReceivingCallback, this.getPrefix());
            lagConnection.initialize(connection);
            this.prepareConnection(lagConnection);
        } else {
            this.prepareConnection(new TcpConnection(socket, this::doReceiving, this.getPrefix()));
        }
    }

    protected void preConnection() {
        this.greeted = false;
    }

    protected void prepareConnection(IConnection newConnection) {
        newConnection.eventOnDisconnected().register((Exception)((Object)((Consumer<Exception>)this::onConnectionDisconnected)));
        this._connection = newConnection;
    }

    protected abstract String getPrefix();

    public void disconnect(String reason) {
        this.disconnect(new TextWithArguments(reason, new Object[0]));
    }

    public void disconnect(TextWithArguments reason) {
        if (this.isUnconnected()) {
            throw new IllegalStateException("Already disconnected");
        }
        this.internalDisconnect(reason);
    }

    public boolean isSending() {
        return this._connection.isSending();
    }

    public void setSending(boolean sending) {
        this._connection.setSending(sending);
    }

    public void flushMessages() {
        this._connection.flushMessages();
    }

    protected void internalDisconnect(TextWithArguments reason) {
        if (this.isUnconnected()) {
            return;
        }
        this.connectionState = ConnectionState.NOT_CONNECTED;
        this.getLogCategory().info(String.valueOf(this.getNetworkName()) + " was disconnected (" + reason.toString() + ")");
        this.setSending(true);
        this.handleDisconnecting(reason);
    }

    protected void handleDisconnecting(TextWithArguments reason) {
        if (this._connection.isConnected()) {
            byte[] disconnectMsg = this.tryGetDisconnectedMessage(reason);
            if (disconnectMsg != null) {
                this.send(disconnectMsg);
                this._connection.disconnect(1.0);
            } else {
                this._connection.disconnect();
            }
        }
    }

    protected abstract byte[] tryGetDisconnectedMessage(TextWithArguments var1);

    private void doReceiving(ReceiverHelper receiver) throws IOException {
        try {
            try {
                this.receivingCallback.accept(receiver);
            }
            catch (UTFDataFormatException ex) {
                throw new AppProtocolException(ex);
            }
        }
        catch (UnexpectedIOException ex) {
            receiver.post(() -> this.onProtocolError(ex));
            receiver.skip();
        }
    }

    public boolean isFullyConnected() {
        return this.connectionState == ConnectionState.READY;
    }

    protected void registerMessage(byte messageID, ReceivingFunction<IMessage> msgReader) {
        Misc.notNull(msgReader);
        this.messageHandler.registerCallback(messageID, x -> {
            IMessage msg = (IMessage)msgReader.apply(x);
            x.post(() -> this.run(msg));
        });
    }

    protected void registerMessage(byte messageID, ReceivingFunctionStream<IMessage> msgReader) {
        Misc.notNull(msgReader);
        this.messageHandler.registerCallback(messageID, x -> {
            IMessage msg = (IMessage)msgReader.apply(x.Stream);
            x.post(() -> this.run(msg));
        });
    }

    protected <T extends NetworkMessage> void registerMessage(Supplier<T> factory, ThrowingConsumer<T, AppProtocolException> handler) {
        Misc.notNull(factory);
        Misc.notNull(handler);
        this.messageHandler.registerMessage(factory, (T x) -> this.run(() -> handler.accept(x)));
    }

    public boolean isConnected() {
        return this.connectionState != ConnectionState.NOT_CONNECTED;
    }

    public boolean isUnconnected() {
        return this.connectionState == ConnectionState.NOT_CONNECTED;
    }

    public abstract boolean isVerifiedPeer();

    protected void run(IMessage msg) {
        try {
            if (!this.isUnconnected()) {
                msg.run();
            }
        }
        catch (UnexpectedIOException ex) {
            this.onProtocolError(ex);
        }
    }

    protected abstract void registerUngreetedMessages();

    protected abstract void registerMessages();

    protected void onProtocolError(String message) {
        if (this.isUnconnected()) {
            return;
        }
        if (this.isVerifiedPeer()) {
            this.getLogCategory().error("Protocol error: " + message);
        }
        this.protocolErrorDisconnect(message);
    }

    protected void onProtocolError(UnexpectedIOException ex) {
        if (this.isUnconnected()) {
            return;
        }
        if (this.isVerifiedPeer()) {
            this.getLogCategory().error("Protocol error: " + ex.getMessage());
            ex.printStackTrace(System.out);
        }
        this.protocolErrorDisconnect(ex);
    }

    protected void protocolErrorDisconnect(Object details) {
        this.internalDisconnect(this.translateProtocolError(details));
    }

    protected TextWithArguments translateProtocolError(Object textOrException) {
        return new TextWithArguments(this.isVerifiedPeer() ? PROTOCOL_ERROR : PROTOCOL_ERROR_EARLY, textOrException);
    }

    protected static enum ConnectionState {
        NOT_CONNECTED,
        WAIT_FOR_GREETING,
        READY;

    }
}

